:- module(solver,
    [is_constraint_functor/1,
    restriction_entailed/2,
    fd_or_num/1,
    reified_equality_solver/3,
    binary_domain/1,
    neq/2,lt/2,eq/2,gt/2,leq/2,geq/2,
    is_identical/2,
    impose_neg_constraints/3,
    solver_search/1,
    is_clp_functor/1,
    solver_rewrite_constraint/2
    ]).
:- use_module(reified_unif,[if_unary_substitute/4,inst/1]).
:- use_module(library(clpr)).

neq(A,B):- {A=\=B}.
lt(A,B):- {A<B}.
eq(A,B):- {A=B}.
gt(A,B):- {A>B}.
leq(A,B):- {A=<B}.
geq(A,B):- {A>=B}.

is_identical(A,B):- entailed(A=B).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% used in ics_quant %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
rel2clp(<>,neq).
rel2clp(<,lt).
rel2clp(=,eq).
rel2clp(>,gt).
rel2clp(=<,leq).
rel2clp(>=,geq).
rel2clp(clp_constraint,clp_constraint).
rel2clp(st,st). /* MG: This is necessary because in Unfolding we call
this module. Since there might remain some st, we have to recognize
it as a constraint, otherwise the quantification will be wrong */

is_clp_functor(C):- memberchk(C,[<>,<,=,>,=<,>=,clp_constraint,st]).

solver_rewrite_constraint(Constraint,{Constraint1}):-
	Constraint=..[F,Arg1,Arg2],
	rel2clp(F,F1),
	Constraint1=..[F1,Arg1,Arg2].

%%%%%%%%%%%%%%%%%%%%%%%%%% used in sokb_parser %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
is_constraint_functor(F):-
    rel2clp(_,F).

%%%%%%%%%%%%%%%%%%%%%%%%%%% Used in quantif %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Checks if the restriction is entailed by a set
% of restrictions.
% It is by far not complete!!!
% Just a collection of simple rules in which entailment
% is easy.

% A restriction is entailed if it was already imposed
restriction_entailed(R,[R1|_]):-
    R == R1, !.
%restriction_entailed(R, [R1|_]):-
%   is_unary(R), is_unary(R1),
%   unary_restriction_entailed(R,R1).

%%%% MG (27 dec 2007) creazione di questo file.
%%%% Per ora tolgo questa regola. Se ci viene in mente un metodo migliore per verificare l'entailment
%%%% nel solver Q, possiamo metterla qui. Ci sarebbe una entailed/1, ma ha bisogno che i vincoli siano
%%%% imposti
%restriction_entailed(X in LowX..HighX,[X1 in Low1 .. High1|_]):-
%    X == X1,
%    leq(Low1,LowX),
%    leq(HighX,High1),!.
restriction_entailed(R,[_|T]):-
    restriction_entailed(R,T).

is_unary(R):-
    term_variables_bag(R,[_]).

%%%%%%%%%%%%%%%%%%%%%%%%%%% Used in reified_unif %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
fd_or_num(X) :- dump([X],_,[]),!.
fd_or_num(X) :- number(X).

reified_equality_solver(X,Y,B):- X #= Y #<=> B.
binary_domain(B):- B in 0..1.

% MarcoG 10 may 2005
% changed because or some reason the choice point gets lost.
% I upgrade to a better version (with reified constraints).
impose_neg_constraints(X,R,Y):-
    impose_neg_constraints(X,R,Y,0).

impose_neg_constraints(_,[],_,1):- !. % SICStus non ottimizza questo cut
impose_neg_constraints(X,[R|T],Y,B):-
    negate(X,R,Y,B1),
    (B1 == 0 -> B=0
    ;   solver_and(B,B1,B2),
        impose_neg_constraints(X,T,Y,B2)
    ).


%impose_neg_constraints(X,[R|_],Y):-
%    negate(X,R,Y).
%impose_neg_constraints(X,[_|T],Y):-
%    impose_neg_constraints(X,T,Y).
%negate(X,R,Y):- negate(X,R,Y,0).

negate(X,R,Y,B):-
    if_unary_substitute(X,R,Y,T),
    reification(T,B),
    inst(B).

solver_and(B,B1,B2):- B #<=> (B1 #/\ B2).

reification(T,B):- call(T #<=> B).

solver_and(B,B1,B2):- B #<=> (B1 #/\ B2).

reification(T,B):- call(T #<=> B).

search(LT1):- labeling([ffc],LT1).
