:- multifile portray/1.

% Prints strings as "ciao" instead of [99,105,97,111]
portray(L):-
    is_code_list(L),
    length(L,Len),
    %prolog_flag(debugger_print_options,O,O),
    %memberchk(print_depth(Depth),O)
    Depth=10,   % Semplifichiamo, mettiamo la Depth di default
    (Depth<Len -> format('"~10s..."',[L])
        ; format('~s',[L])
    ).

is_code_list([]).
is_code_list([H|T]):-
    integer(H),
    is_code_list(T).



:-assert((
portray(ic(Body,Head)):-
    write('ic:'),
    nl,
    print_body(Body),
    nl,
    write('--->\t'),
    print_disjunction(Head), nl
    )).

:-assert((
portray(psic(Body,Head)):-
    write('psic:'),
    nl,
    print_body(Body),
    nl,
    write('--->\t'),
    print_disjunction(Head), nl
    )).

print_disjunction([H]):- !,
    write(H).
print_disjunction([H1,H2|T]):-
    write(H1), nl, write('\\/\t'),
    print_disjunction([H2|T]).

:-assert((
    portray(forallf(X)):-
        put_code(31), % Code of the forall symbol: a black triangle pointing down
        print(X)        
    )).

print_body([]).
print_body([H|T]):- !,
    print_body(H),
    print_body(T).
print_body(A):- print(A).

% CLP constraints

:-assert((
    portray(clpfd:'t=u IND'(A,B)):-
        print(A), write(=), print(B)
    )).
:-assert((
    portray(clpfd:'x\\=y IND'(A,B)):-
        print(A), write(\=), print(B)
    )).

:-assert((
    portray(clpfd:'t=<u+c'(A,B,C)):-
        (C=0    -> print(A=<B);
         C= -1   -> print(A<B);
         C>0    -> print(A=<B+C);
                   print(A=<B), print(C) % Negative number: sign written by print(C)
         )
    )).

:-assert((
    portray(clpfd:'t>=u+c'(A,B,C)):-
        (C=0    -> print(A>=B);
         C=1    -> print(A>B);
         C>0    -> print(A>=B+C);
                   print(A>=B), print(C) % Negative number: sign written by print(C)
         )
    )).
