package sCIFF.launch;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.SWT;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;

import sCIFF.Utility;


public class StartSciffPulldown implements IWorkbenchWindowPulldownDelegate {
	private MenuItem consult;
	private MenuItem compile;
	private Menu menu;
	private String lastRun="compile";

	public Menu getMenu(Control parent) {
		menu=new Menu(parent);
		
		compile=new MenuItem(menu,SWT.PUSH);
		compile.setText("compile");
		compile.addSelectionListener(new SelectionAdapter(){
			public void widgetSelected(SelectionEvent e) 
			{
				if (e.getSource().equals(compile))
				{
				lastRun="compile";
				startCompile();
				}
			}
		});
		
		consult=new MenuItem(menu,SWT.PUSH);
		consult.setText("consult");
		consult.addSelectionListener(new SelectionAdapter(){
			public void widgetSelected(SelectionEvent e) 
			{
				if (e.getSource().equals(consult))
				{
				lastRun="consult";
				startConsult();
				}
			}
		});
		
		return menu;
	}

	public void dispose() {

	}

	public void init(IWorkbenchWindow window) {
		// TODO Auto-generated method stub

	}

	public void run(IAction action) {
		if(lastRun.equals("compile"))
			startCompile();
		if(lastRun.equals("consult"))
			startConsult();

	}

	public void selectionChanged(IAction action, ISelection selection) {
	}
	
	public void startConsult()
	{
		boolean found=false;
		ILaunchConfiguration configuration;
		ILaunchManager manager=DebugPlugin.getDefault().getLaunchManager();
		ILaunchConfigurationType type=manager.getLaunchConfigurationType("SCIFF.launchSciffConfigurationType");
		try{
		ILaunchConfiguration[] configurations=manager.getLaunchConfigurations(type);
		for(int i=0;i<configurations.length;i++)
		{
			if (configurations[i].getName().equals(LaunchSciffConfigurationDelegate.START_SCIFF_NAME))
			{
			found=true;
			configuration=configurations[i];
			ILaunchConfigurationWorkingCopy workingCopy=configuration.copy(LaunchSciffConfigurationDelegate.START_SCIFF_NAME);
			workingCopy.setAttribute(LaunchSciffConfigurationDelegate.SCIFF_CONSULT,"consult");
			configuration=workingCopy.doSave();
			DebugUITools.launch(configuration,"profile");
			
			break;
			}
		}
		
		if(!found)
		{
		ILaunchConfigurationWorkingCopy workingCopy=type.newInstance(null,LaunchSciffConfigurationDelegate.START_SCIFF_NAME);
		workingCopy.setAttribute(LaunchSciffConfigurationDelegate.SCIFF_CONSULT,"consult");
		configuration=workingCopy.doSave();
		DebugUITools.launch(configuration,"profile");
		
		}		
		
		}catch(CoreException ex){Utility.showError("Error creating launch configuration.",true);}
	}
	
	public void startCompile()
	{
		boolean found=false;
		ILaunchConfiguration configuration;
		ILaunchManager manager=DebugPlugin.getDefault().getLaunchManager();
		ILaunchConfigurationType type=manager.getLaunchConfigurationType("SCIFF.launchSciffConfigurationType");
		try{
		ILaunchConfiguration[] configurations=manager.getLaunchConfigurations(type);
		for(int i=0;i<configurations.length;i++)
		{
			if (configurations[i].getName().equals(LaunchSciffConfigurationDelegate.START_SCIFF_NAME))
			{
			found=true;
			configuration=configurations[i];
			ILaunchConfigurationWorkingCopy workingCopy=configuration.copy(LaunchSciffConfigurationDelegate.START_SCIFF_NAME);
			workingCopy.setAttribute(LaunchSciffConfigurationDelegate.SCIFF_CONSULT,"compile");
			configuration=workingCopy.doSave();
			DebugUITools.launch(configuration,"profile");
			
			break;
			}
		}
		
		if(!found)
		{
		ILaunchConfigurationWorkingCopy workingCopy=type.newInstance(null,LaunchSciffConfigurationDelegate.START_SCIFF_NAME);
		workingCopy.setAttribute(LaunchSciffConfigurationDelegate.SCIFF_CONSULT,"compile");
		configuration=workingCopy.doSave();
		DebugUITools.launch(configuration,"profile");
		
		}		
		
		}catch(CoreException ex){Utility.showError("Error creating launch configuration.",true);}
	}

}
