package sCIFF.launch;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate;

import sCIFF.Utility;

public class RunProjectPulldown implements IWorkbenchWindowPulldownDelegate {
	private MenuItem run,run_closed,run_open;
	private Menu menu;
	private String lastRun="run";

	public Menu getMenu(Control parent) {
menu=new Menu(parent);
		
		run=new MenuItem(menu,SWT.PUSH);
		run.setText("run");
		run.addSelectionListener(new SelectionAdapter(){
			public void widgetSelected(SelectionEvent e) 
			{
				if (e.getSource().equals(run))
				{
				lastRun="run";
				projectRun();
				}
			}
		});
		
		run_closed=new MenuItem(menu,SWT.PUSH);
		run_closed.setText("run_closed");
		run_closed.addSelectionListener(new SelectionAdapter(){
			public void widgetSelected(SelectionEvent e) 
			{
				if (e.getSource().equals(run_closed))
				{
				lastRun="run_closed";
				projectRunClosed();
				}
			}
		});
		
		run_open=new MenuItem(menu,SWT.PUSH);
		run_open.setText("run_open");
		run_open.addSelectionListener(new SelectionAdapter(){
			public void widgetSelected(SelectionEvent e) 
			{
				if (e.getSource().equals(run_open))
				{
				lastRun="runOpen";
				projectRunOpen();
				}
			}
		});
		
		return menu;
	}

	public void dispose() {
		// TODO Auto-generated method stub

	}

	public void init(IWorkbenchWindow window) {
		// TODO Auto-generated method stub

	}

	public void run(IAction action) {
		if(lastRun.equals("run"))
			projectRun();
		if(lastRun.equals("run_closed"))
			projectRunClosed();
		if(lastRun.equals("run_open"))
			projectRunOpen();

	}

	public void selectionChanged(IAction action, ISelection selection) {
		// TODO Auto-generated method stub

	}
	
	public void projectRun()
	{
		boolean found=false;
		ILaunchConfiguration configuration;
		ILaunchManager manager=DebugPlugin.getDefault().getLaunchManager();
		ILaunchConfigurationType type=manager.getLaunchConfigurationType("SCIFF.launchSciffConfigurationType");
		try{
		ILaunchConfiguration[] configurations=manager.getLaunchConfigurations(type);
		for(int i=0;i<configurations.length;i++)
		{
			if (configurations[i].getName().equals(LaunchSciffConfigurationDelegate.RUN_PROJECT))
			{
			found=true;
			configuration=configurations[i];
			ILaunchConfigurationWorkingCopy workingCopy=configuration.copy(LaunchSciffConfigurationDelegate.RUN_PROJECT);
			workingCopy.setAttribute(LaunchSciffConfigurationDelegate.RUN_PROJECT_MODE,"run");
			configuration=workingCopy.doSave();
			DebugUITools.launch(configuration,"profile");
			
			break;
			}
		}
		
		if(!found)
		{
		ILaunchConfigurationWorkingCopy workingCopy=type.newInstance(null,LaunchSciffConfigurationDelegate.RUN_PROJECT);
		workingCopy.setAttribute(LaunchSciffConfigurationDelegate.RUN_PROJECT_MODE,"run");
		configuration=workingCopy.doSave();
		DebugUITools.launch(configuration,"profile");
		
		}		
		
		}catch(CoreException ex){Utility.showError("Error creating launch configuration.",true);}
	}
	
	public void projectRunClosed()
	{
		boolean found=false;
		ILaunchConfiguration configuration;
		ILaunchManager manager=DebugPlugin.getDefault().getLaunchManager();
		ILaunchConfigurationType type=manager.getLaunchConfigurationType("SCIFF.launchSciffConfigurationType");
		try{
		ILaunchConfiguration[] configurations=manager.getLaunchConfigurations(type);
		for(int i=0;i<configurations.length;i++)
		{
			if (configurations[i].getName().equals(LaunchSciffConfigurationDelegate.RUN_PROJECT))
			{
			found=true;
			configuration=configurations[i];
			ILaunchConfigurationWorkingCopy workingCopy=configuration.copy(LaunchSciffConfigurationDelegate.RUN_PROJECT);
			workingCopy.setAttribute(LaunchSciffConfigurationDelegate.RUN_PROJECT_MODE,"run_closed");
			configuration=workingCopy.doSave();
			DebugUITools.launch(configuration,"profile");
			
			break;
			}
		}
		
		if(!found)
		{
		ILaunchConfigurationWorkingCopy workingCopy=type.newInstance(null,LaunchSciffConfigurationDelegate.RUN_PROJECT);
		workingCopy.setAttribute(LaunchSciffConfigurationDelegate.RUN_PROJECT_MODE,"run_closed");
		configuration=workingCopy.doSave();
		DebugUITools.launch(configuration,"profile");
		
		}		
		
		}catch(CoreException ex){Utility.showError("Error creating launch configuration.",true);}
	}
	
	public void projectRunOpen()
	{
		boolean found=false;
		ILaunchConfiguration configuration;
		ILaunchManager manager=DebugPlugin.getDefault().getLaunchManager();
		ILaunchConfigurationType type=manager.getLaunchConfigurationType("SCIFF.launchSciffConfigurationType");
		try{
		ILaunchConfiguration[] configurations=manager.getLaunchConfigurations(type);
		for(int i=0;i<configurations.length;i++)
		{
			if (configurations[i].getName().equals(LaunchSciffConfigurationDelegate.RUN_PROJECT))
			{
			found=true;
			configuration=configurations[i];
			ILaunchConfigurationWorkingCopy workingCopy=configuration.copy(LaunchSciffConfigurationDelegate.RUN_PROJECT);
			workingCopy.setAttribute(LaunchSciffConfigurationDelegate.RUN_PROJECT_MODE,"run_open");
			configuration=workingCopy.doSave();
			DebugUITools.launch(configuration,"profile");
			
			break;
			}
		}
		
		if(!found)
		{
		ILaunchConfigurationWorkingCopy workingCopy=type.newInstance(null,LaunchSciffConfigurationDelegate.RUN_PROJECT);
		workingCopy.setAttribute(LaunchSciffConfigurationDelegate.RUN_PROJECT_MODE,"run_open");
		configuration=workingCopy.doSave();
		DebugUITools.launch(configuration,"profile");
		
		}		
		
		}catch(CoreException ex){Utility.showError("Error creating launch configuration.",true);}
	}

}
