package sCIFF.launch;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

import sCIFF.Utility;

public class RunClosedMenuDelegate implements IWorkbenchWindowActionDelegate {

	public void dispose() {
		// TODO Auto-generated method stub

	}

	public void init(IWorkbenchWindow window) {

	}

	public void run(IAction action) {
		boolean found=false;
		ILaunchConfiguration configuration;
		ILaunchManager manager=DebugPlugin.getDefault().getLaunchManager();
		ILaunchConfigurationType type=manager.getLaunchConfigurationType("SCIFF.launchSciffConfigurationType");
		try{
		ILaunchConfiguration[] configurations=manager.getLaunchConfigurations(type);
		for(int i=0;i<configurations.length;i++)
		{
			if (configurations[i].getName().equals(LaunchSciffConfigurationDelegate.RUN_PROJECT))
			{
			found=true;
			configuration=configurations[i];
			ILaunchConfigurationWorkingCopy workingCopy=configuration.copy(LaunchSciffConfigurationDelegate.RUN_PROJECT);
			workingCopy.setAttribute(LaunchSciffConfigurationDelegate.RUN_PROJECT_MODE,"run_closed");
			configuration=workingCopy.doSave();
			DebugUITools.launch(configuration,"profile");
			
			break;
			}
		}
		
		if(!found)
		{
		ILaunchConfigurationWorkingCopy workingCopy=type.newInstance(null,LaunchSciffConfigurationDelegate.RUN_PROJECT);
		workingCopy.setAttribute(LaunchSciffConfigurationDelegate.RUN_PROJECT_MODE,"run_closed");
		configuration=workingCopy.doSave();
		DebugUITools.launch(configuration,"profile");
		
		}		
		
		}catch(CoreException ex){Utility.showError("Error creating launch configuration.",true);}

	}

	public void selectionChanged(IAction action, ISelection selection) {
		selection.toString();

	}

}
