package sCIFF.launch;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.SWT;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import sCIFF.Utility;


public class ProjectDialog extends Dialog {
	
	private Combo projectCombo;
	private String project;
	private Button ok;
	private IWorkspaceRoot workRoot;
	private boolean socs_si;

	public ProjectDialog(Shell parentShell,boolean socs_si) {
		super(parentShell);
		this.socs_si=socs_si;
	}

	public ProjectDialog(IShellProvider parentShell,boolean socs_si) {
		super(parentShell);
		this.socs_si=socs_si;
	}

	protected Control createDialogArea(Composite parent) {
		
		if(socs_si==true)
		parent.getShell().setText("run SOCS_SI with project");
		if(socs_si==false)
		parent.getShell().setText("run SCIFF project");
		
				
		
		Composite composite=new Composite(parent,SWT.NULL);
		GridData data = new GridData(GridData.GRAB_HORIZONTAL
                | GridData.GRAB_VERTICAL | GridData.HORIZONTAL_ALIGN_FILL
                | GridData.VERTICAL_ALIGN_CENTER);
		GridLayout layout=new GridLayout();
		
		composite.setLayout(layout);
		composite.setLayoutData(data);
		
		Label label=new Label(composite,SWT.NULL);
		label.setLayoutData(data);
		label.setText("Select a project:");
		
		projectCombo=new Combo(composite,SWT.DROP_DOWN); 
	    
	    projectCombo.setLayoutData(data);
	    
	    workRoot=ResourcesPlugin.getWorkspace().getRoot();
	    
	    try{
	    IProject[] projects=Utility.getSciffNature(workRoot);
	        
	    for(int i=0;i<projects.length;i++)
	    {
	    	projectCombo.add(projects[i].getName());
	    }
	    }catch(CoreException e){Utility.showError("Error during project nature reading.",false);}
	    
	    projectCombo.addModifyListener(new ModifyListener(){
	    	public void modifyText(ModifyEvent e)
	    	{
	    		if (e.widget instanceof Combo)
	    		{
	    			Combo projectName=(Combo)e.widget;
	    			project=projectName.getItem(projectName.getSelectionIndex());
	    			if((project!=null)|(project!=""))
	    			{
	    				ok.setEnabled(true);
	    			}
	    			
	    			
	    		}
	    	}
	    });
	    
	    

	    
	    return parent;
	}
	
	protected void createButtonsForButtonBar(Composite parent) {
        // create OK and Cancel buttons by default
        createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
                true);
        ok=getButton(IDialogConstants.OK_ID);
        ok.setEnabled(false);
        createButton(parent, IDialogConstants.CANCEL_ID,
                IDialogConstants.CANCEL_LABEL, false);
    }
	
	protected void okPressed() {
		if(socs_si==true)
		{
			startSOCS();
		}
		else
		{
			compileSciffProject();
		}
    }
	
	private void startSOCS()
	{
		this.close();
		ILaunchConfigurationType type;
		ILaunchConfiguration configuration;
		ILaunchManager manager=DebugPlugin.getDefault().getLaunchManager();
		
		type=manager.getLaunchConfigurationType("SCIFF.launchSocsConfigurationType");
		try{
		ILaunchConfigurationWorkingCopy workingCopy=type.newInstance(null,"SOCS");
		workingCopy.setAttribute(LaunchSocsConfigurationDelegate.PROJECT_NAME,project);
		configuration=workingCopy.doSave();
		DebugUITools.launch(configuration,"socs");
		}catch(CoreException e){Utility.showError("Error creating launch congiguration.",true);}
	}
	
	private void compileSciffProject()
	{
		this.close();
		boolean found=false;
		ILaunchConfiguration configuration;
		ILaunchManager manager=DebugPlugin.getDefault().getLaunchManager();
		ILaunchConfigurationType type=manager.getLaunchConfigurationType("SCIFF.launchSciffConfigurationType");
		try{
		ILaunchConfiguration[] configurations=manager.getLaunchConfigurations(type);
		for(int i=0;i<configurations.length;i++)
		{
			if (configurations[i].getName().equals(LaunchSciffConfigurationDelegate.COMPILE_PROJECT))
			{
			found=true;
			configuration=configurations[i];
			ILaunchConfigurationWorkingCopy workingCopy=configuration.copy(LaunchSciffConfigurationDelegate.COMPILE_PROJECT);
			workingCopy.setAttribute(LaunchSciffConfigurationDelegate.PROJECT_NAME_ATTRIBUTE,project);
			configuration=workingCopy.doSave();
			DebugUITools.launch(configuration,"profile");
			
			break;
			}
		}
		
		if(!found)
		{
		ILaunchConfigurationWorkingCopy workingCopy=type.newInstance(null,LaunchSciffConfigurationDelegate.COMPILE_PROJECT);
		workingCopy.setAttribute(LaunchSciffConfigurationDelegate.PROJECT_NAME_ATTRIBUTE,project);
		configuration=workingCopy.doSave();
		DebugUITools.launch(configuration,"profile");
		
		}		
		
		}catch(CoreException ex){Utility.showError("Error creating launch configuration.",true);}
		this.close();
	}
	
	private String getProjectPathString(String name)
	{
		IProject project=workRoot.getProject(name);
		String projectPathString=project.getLocation().toOSString();
		return projectPathString;
	}
}
