package sCIFF.launch;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.core.runtime.Status;

import sCIFF.Utility;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Vector;


public class OutJob extends Job {
	private Process sciff;
	private String projectName;
	String message;
	private String markerMessage;
	public static final String SCIFF_FAMILY="sciff_family";

	public OutJob(String name,String message,String projectName) {
		super(name);
		this.sciff=sciff;
		this.projectName=projectName;
		this.message=message;
	}

	protected IStatus run(IProgressMonitor monitor) {
		
		try{
		
		
					getMarker(message);
					}catch(CoreException e){Utility.showError("Error during marker writing.",true);}
					catch(IOException e){Utility.showError("Error during marker writing.",true);}
					
				
		return Status.OK_STATUS;
	}
	
	public Process getProcess()
	{
		return sciff;
	}
	
	public boolean belongsTo(Object family)
	{
		return family==SCIFF_FAMILY;
	}
	
	private void getMarker(String out)
	throws CoreException,IOException{
		
		String[] lines=out.split("(?sm:\n)");
		String[] linesError;
		Vector vLinesError=new Vector();
		for (int i=0;i<lines.length;i++)
		{
			if ((lines[i].matches(".*OK\\r"))||(lines[i].equals("")))
			{}
			else
			vLinesError.add(lines[i]);
				
		}
		
		linesError=new String[vLinesError.size()];
		vLinesError.copyInto(linesError);
		String[] files=linesError[0].split("(?s:file)");
		String file=files[files.length-1];
		file=file.substring(0,file.length()-1);
		file=file.trim();
		String root=ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).getLocation().toString();
		String[] temp=file.split(root+"[/]");
		IPath path=new Path(temp[1]);
		
		IFile iFile=ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).getFile(path);
		File sysFile=new File(ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).getLocation().toOSString()+"\\"+path.toOSString());
		sysFile.exists();
		IMarker marker=iFile.createMarker("org.eclipse.core.resources.problemmarker");
		marker.setAttribute(IMarker.SEVERITY,IMarker.SEVERITY_ERROR);
		
		String[] markerLines=new String[2];
		
		
		if(Utility.isICS(sysFile.getName()))
		{
			
			
			for(int i=0;i<lines.length;i++)
			{
				if (lines[i].matches("(?s:.*Error in IC number.*)"))
				{
					
					markerLines[1]=lines[i];
					markerLines[0]=lines[i];
					for(int l=0;l<i;l++)
					{
						if(lines[l].matches("(?s:.*[***].*)"))
								markerLines[0]=lines[l];	
					}
					
				}
			}
			marker=getErrorLine(markerLines[1],sysFile,marker);
			
			markerMessage=markerLines[0].substring(4,linesError[1].length()-1);
			
			marker.setAttribute(IMarker.MESSAGE,markerMessage);
			
		}
		else
		{	
			for(int i=0;i<lines.length;i++)
			{
				if (lines[i].matches("(?s:.*Error in Event number.*)"))
				{
					
					markerLines[1]=lines[i];
					markerLines[0]=lines[i];
					for(int l=0;l<i;l++)
					{
						if(lines[l].matches("(?s:.*[***].*)"))
								markerLines[0]=lines[l];	
					}
					
				}
			}
			
			
			marker=getErrorLine(markerLines[1],sysFile,marker);
			markerMessage=markerLines[0].substring(4,linesError[1].length()-1);
			marker.setAttribute(IMarker.MESSAGE,markerMessage);
		
		}
		
	}
	
	private IMarker getErrorLine(String error,File file,IMarker marker)
	throws IOException, CoreException{
		String[] errors=error.split("(?s)number");
		errors[1]=errors[1].trim();
		String temp=errors[1].substring(0,errors[1].length()-4);
		Integer integer=new Integer(temp);
		int i=integer.intValue();
		if(Utility.isICS(file.getName()))
		{
			int[] ic=Utility.getLineOfIc(i,file);
			marker.setAttribute(IMarker.CHAR_START,ic[0]);
			marker.setAttribute(IMarker.CHAR_END,ic[1]);
			marker.setAttribute(IMarker.LINE_NUMBER,ic[0]);
			return marker;
		}
		else
		{
			int line=Utility.getLineOfClause(i,file);
			marker.setAttribute(IMarker.LINE_NUMBER,line);
			return marker;
		}
	}
	
	
	private void eraseAllMarkers(String project)
	{
			try{
				ResourcesPlugin.getWorkspace().getRoot().getProject(project).deleteMarkers(IMarker.PROBLEM,false,IProject.DEPTH_INFINITE);
			}catch(CoreException e){Utility.showError("Error deleting marker.",true);}
		
	}
	

}
