package sCIFF.launch;

import java.io.File;
import java.io.BufferedInputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.IOException;
import java.io.FileNotFoundException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.core.model.IProcess; 
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

import sCIFF.Utility;
import sCIFF.Project;
import sCIFF.SCIFFPlugin;

public class LaunchSocsConfigurationDelegate implements
		ILaunchConfigurationDelegate {

	public static final String PROJECT_NAME="project_path";
	public static final String SOCS_PROCESS="socs_process";
	
	private ILaunch launch;
	private IProcess process;
	private MessageConsoleStream stream;

	public void launch(ILaunchConfiguration configuration, String mode,
			ILaunch launch, IProgressMonitor monitor)  {
		try{
			
			MessageConsole messageConsole;
			boolean found=false;
			
			
			
			IConsole[] consoles=ConsolePlugin.getDefault().getConsoleManager().getConsoles();
			
			for(int i=0;i<consoles.length;i++)
			{
				if(consoles[i].getName().equals("SCIFF errors"))
				{
					messageConsole=(MessageConsole)consoles[i];
					stream=messageConsole.newMessageStream();
					found=true;
				}
			}
			if(found==false)
			{
			messageConsole=new MessageConsole("SCIFF errors",ImageDescriptor.getMissingImageDescriptor());
			ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{messageConsole});
			ConsolePlugin.getDefault().getConsoleManager().showConsoleView(messageConsole);
			stream=messageConsole.newMessageStream();
			}
			
			
		this.launch=launch;
		String socs=SCIFFPlugin.getDefault().getPreferenceStore().getString(SCIFFPlugin.socs_path);
		String sciff=SCIFFPlugin.getDefault().getPreferenceStore().getString(SCIFFPlugin.sciff_path);
		String proof=SCIFFPlugin.getDefault().getPreferenceStore().getString(SCIFFPlugin.proof);
		
		String projectName=configuration.getAttribute(LaunchSocsConfigurationDelegate.PROJECT_NAME,"");
		IProject project=ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
		

		Project prj=new Project(project.getFile("project.pl"));
		
		String prefix=project.getLocation().toOSString();
		
		String[] ics=prj.getIcs();
		String icsString="";
		for(int i=0;i<ics.length;i++)
		{
			if(!ics[i].matches(".*/.*"))
			{
				ics[i]="/"+ics[i];
			}
			if(i==ics.length-1)
			{
				ics[i]=ics[i].replaceAll("[/]","\\\\");
				icsString+=prefix+ics[i];
			}else{
			ics[i]=ics[i].replaceAll("[/]","\\\\");
			icsString+=prefix+ics[i]+";";
			}
		}
		
		String[] sokb=prj.getSokb();
		String sokbString="";
		for(int i=0;i<sokb.length;i++)
		{
			if(!sokb[i].matches(".*/.*"))
			{
				sokb[i]="/"+sokb[i];
			}
			if(i==sokb.length-1)
			{
				sokb[i]=sokb[i].replaceAll("[/]","\\\\");
				sokbString+=prefix+sokb[i];
			}else{
			sokb[i]=sokb[i].replaceAll("[/]","\\\\");
			sokbString+=prefix+sokb[i]+";";
			}
		}
		
		String[] history=prj.getHistory();
		String historyString="";
		for(int i=0;i<history.length;i++)
		{
			if(!history[i].matches(".*/.*"))
			{
				history[i]="/"+history[i];
			}
			if(i==history.length-1)
			{
				history[i]=history[i].replaceAll("[/]","\\\\");
				historyString+=prefix+history[i];
			}else
			{
			history[i]=history[i].replaceAll("[/]","\\\\");
			historyString+=prefix+history[i]+";";
			}
		}
		
		
		File socsDir=new File(socs);
		
		if(socsDir.isDirectory())
		{
			String[] cmdLine;
			if (proof.equals("true"))
			{
				String[] proofLine={"cmd","/C",socs+"\\run.bat","--manual","--sourceType","file","--sourceFiles",historyString,"--proof",sciff+"\\sciff_java_gui.pl","--protocols",icsString,"--sokb",sokbString};
				cmdLine=proofLine;
			}
			else
			{
			String[] noProofLine={"cmd","/C",socs+"\\run.bat","--manual","--sourceType","file","--sourceFiles",historyString,"--protocols",icsString,"--sokb",sokbString};
			cmdLine=noProofLine;
			}
			
			
			Process p=DebugPlugin.exec(cmdLine,socsDir);
			//launch.setAttribute(DebugPlugin.ATTR_CAPTURE_OUTPUT,"false");
			process=DebugPlugin.newProcess(launch,p,LaunchSocsConfigurationDelegate.SOCS_PROCESS);
			
		}
		
		
		}catch(CoreException e)
		{
			Utility.showError("Error launching SOCS-SI.",true);
		}
	}

}
