package sCIFF.launch;

import java.io.File;
import java.util.Vector;
import java.util.HashMap;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.console.IConsole;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IViewPart;

import sCIFF.Project;
import sCIFF.SCIFFPlugin;
import sCIFF.Utility;

public class LaunchSciffConfigurationDelegate implements
		ILaunchConfigurationDelegate {
	
	private Process sciff;
	private IProcess process;
	private String projectName;
	private ILaunchConfiguration configuration;
	
	public static String PROJECT_NAME_ATTRIBUTE="project";
	
	public static String SCIFF_PROCESS="SCIFF process";
	public static String SCIFF_CONSULT="SCIFF consult";
	public static String START_SCIFF_NAME="START SCIFF";
	public static String COMPILE_PROJECT="compile_project";
	public static String RUN_PROJECT="run_project";
	public static String RUN_PROJECT_MODE="run_project_mode";
	
	
	private boolean sokbMarkerCreated=false;
	private IFile errorSokbFile=null;
	private int numberSokbError=-1;
	private String descriptionSokbMarker;
	private Project projectHandle;
	private String markerMessage;
	
	
	public static String SICStus_PROCESS="SICStus process";
	private MessageConsoleStream stream;
	private boolean consult;
	
	private IStreamMonitor outMonitor=null;
	private IStreamListener outListener=null;
	private IStreamMonitor errorMonitor=null;
	private IStreamListener errorListener=null;
	

	public void launch(ILaunchConfiguration configuration, String mode,
			ILaunch launch, IProgressMonitor monitor) throws CoreException {
		
		this.configuration=configuration;
		MessageConsole messageConsole;
		boolean found=false;
		
		consult=configuration.getAttribute(LaunchSciffConfigurationDelegate.SCIFF_CONSULT,"").equals("consult");
		
		IConsole[] consoles=ConsolePlugin.getDefault().getConsoleManager().getConsoles();
		
		for(int i=0;i<consoles.length;i++)
		{
			if(consoles[i].getName().equals("SCIFF errors"))
			{
				messageConsole=(MessageConsole)consoles[i];
				stream=messageConsole.newMessageStream();
				found=true;
			}
		}
		if(found==false)
		{
		messageConsole=new MessageConsole("SCIFF errors",ImageDescriptor.getMissingImageDescriptor());
		ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{messageConsole});
		ConsolePlugin.getDefault().getConsoleManager().showConsoleView(messageConsole);
		stream=messageConsole.newMessageStream();
		}
		
		if(configuration.getName().equals(LaunchSciffConfigurationDelegate.START_SCIFF_NAME))
		{
		process=startSciff(launch);
//		OutJob outJob=new OutJob("outJob",sciff,projectName);
//		outJob.schedule();
//		if(outMonitor==null)
//		{
		outMonitor=process.getStreamsProxy().getOutputStreamMonitor();
		outMonitor.addListener(outListener=new IStreamListener()
				{
					public void streamAppended(String text, IStreamMonitor monitor) 
					{
						
						
						if (((text.matches("(?sm:.*Error in IC number.*)"))|(text.matches("(?sm:.*Error in Event number.*)")))&&(!text.matches("(?sm:.*[****] Warning[:] atom in head [***].*)"))){
						
							try{
							getMarker(text,projectName);
							}catch(CoreException e){Utility.showError("Error during marker writing.",true);}
							catch(IOException e){Utility.showError("Error during marker writing.",true);}
					
//							OutJob outJob=new OutJob("outJob",text,projectName);
//							outJob.setPriority(outJob.INTERACTIVE);
//							outJob.schedule();
//							try{
//							outJob.join();
//							}catch(InterruptedException e){}
//							}else{
//							getSokbMarkerFile(text);
//							if(sokbMarkerCheck()&&(!sokbMarkerCreated))
//							{
//									createSokbMarker();
//							}
							}	
							
							
						
					}
				});
//		}
		
//		if(errorMonitor==null)
//		{
//		errorMonitor=process.getStreamsProxy().getErrorStreamMonitor();
//		errorMonitor.addListener(errorListener=new IStreamListener()
//				{
//				
//				
//					
//					public void streamAppended(String text, IStreamMonitor monitor) 
//					{
////							if(text.matches("(?sm:.*no.*)"))
////							{
////								try{
////									IWorkbenchWindow[] windows=SCIFFPlugin.getDefault().getWorkbench().getWorkbenchWindows();
////									for(int i=0;i<windows.length;i++)
////									{
////										IViewPart part=windows[i].getActivePage().findView("org.eclipse.ui.views.ProblemView");
////										windows[i].getActivePage().activate(part);
////									}
////									SCIFFPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(IPageLayout.ID_PROBLEM_VIEW).setFocus();
////								}catch(PartInitException e){}
////						}
//						
//							
//							if(text.matches("(?sm:.*\n!.*)"))
//							{
//								
//								Vector vErrorLines=new Vector();
//								String[] lines=text.split("\n");
//								for(int i=0;i<lines.length;i++)
//								{
//									if (lines[i].startsWith("!"))
//										vErrorLines.add(lines[i]);
//								}
//								String[] errorSokbLines=new String[vErrorLines.size()];
//								vErrorLines.copyInto(errorSokbLines);
//								numberSokbError=getSokbErrorLine(errorSokbLines);
//								if(sokbMarkerCheck()&&(!sokbMarkerCreated))
//								{
//										
//										
//										createSokbMarker();
//										
//								}
//								
//							}
//							
//						
//					}
//				});
//		}
		}
		
		if(configuration.getName().equals(LaunchSciffConfigurationDelegate.COMPILE_PROJECT))
		process=compileProject(launch);
		
		if(configuration.getName().equals(LaunchSciffConfigurationDelegate.RUN_PROJECT))
		process=runProject(launch);
		
		
		
		
	}
	
//	public void startSciff()
//	{
//		HashMap map=new HashMap();
//		map.put(IProcess.ATTR_PROCESS_TYPE,"SCIFF_process");
//		map.put(IProcess.ATTR_PROCESS_LABEL,"SCIFF console");
//		
//		try{
//			
//			String[] cmdLine=new String[3];
//			
//			IProcess[] processes=DebugPlugin.getDefault().getLaunchManager().getProcesses();
//			for(int i=0;i<processes.length;i++)
//			{
//				if (processes[i].getLabel().equals(LaunchSciffConfigurationDelegate.SICStus_PROCESS))
//				{
//					processes[i].terminate();
//				}	
//			}	
//			
//			String sciffPath=SCIFFPlugin.getDefault().getPreferenceStore().getString(SCIFFPlugin.sciff_path);
//			File sciffDir=new File(sciffPath);
//			sciffPath=sciffPath.toLowerCase();
//			sciffPath=sciffPath.replaceAll("\\\\","/");
//			String sicstusPath=SCIFFPlugin.getDefault().getPreferenceStore().getString(SCIFFPlugin.sicstus_path);
//			File sicstusExe=new File(sicstusPath);
//			File sicstusDir=sicstusExe.getParentFile();
//			
//			if(consult==true)
//			{
//				cmdLine[0]=sicstusPath;
//				cmdLine[1]="--goal";
//				cmdLine[2]="consult('"+sciffPath+"/sciff.pl').";
//			}else
//			{
//				cmdLine[0]=sicstusPath;
//				cmdLine[1]="--goal";
//				cmdLine[2]="compile('"+sciffPath+"/sciff.pl').";
//			}
//			
//			String temp=sciffDir.getAbsolutePath().replace(File.separatorChar,'/');
//			temp=temp.toLowerCase();
//			
//			stream.println("Executing "+cmdLine[0]+" "+cmdLine[1]+" "+cmdLine[2]+" ");
//			stream.println("in directory "+sciffDir.getPath()+"\n");
//			stream.close();
//			
//			
//			
//			
//			sciff=DebugPlugin.exec(cmdLine,sicstusDir);
//			SicstusThread thread=new SicstusThread(stream,sciff,projectName);
//			thread.run();
//			}catch(CoreException e){Utility.showError("SCIFF not loaded.\n Check the SCIFF path property!",true);
//			sciff.destroy();
//			}
//			catch(IOException e){}
//	}
	
	
	public IProcess startSciff(ILaunch launch)
	{
		HashMap map=new HashMap();
		map.put(IProcess.ATTR_PROCESS_TYPE,"SCIFF_process");
		map.put(IProcess.ATTR_PROCESS_LABEL,"SCIFF console");
		
		try{
			
			String[] cmdLine=new String[3];
			
			IProcess[] processes=DebugPlugin.getDefault().getLaunchManager().getProcesses();
			for(int i=0;i<processes.length;i++)
			{
				if (processes[i].getLabel().equals(LaunchSciffConfigurationDelegate.SICStus_PROCESS))
				{
					processes[i].terminate();
				}	
			}	
			
			String sciffPath=SCIFFPlugin.getDefault().getPreferenceStore().getString(SCIFFPlugin.sciff_path);
			File sciffDir=new File(sciffPath);
			sciffPath=sciffPath.toLowerCase();
			sciffPath=sciffPath.replaceAll("\\\\","/");
			String sicstusPath=SCIFFPlugin.getDefault().getPreferenceStore().getString(SCIFFPlugin.sicstus_path);
			File sicstusExe=new File(sicstusPath);
			File sicstusDir=sicstusExe.getParentFile();
			
			if(consult==true)
			{
				cmdLine[0]=sicstusPath;
				cmdLine[1]="--goal";
				cmdLine[2]="consult('"+sciffPath+"/sciff.pl').";
			}else
			{
				cmdLine[0]=sicstusPath;
				cmdLine[1]="--goal";
				cmdLine[2]="compile('"+sciffPath+"/sciff.pl').";
			}
			
			String temp=sciffDir.getAbsolutePath().replace(File.separatorChar,'/');
			temp=temp.toLowerCase();
			
			stream.println("Executing "+cmdLine[0]+" "+cmdLine[1]+" "+cmdLine[2]+" ");
			stream.println("in directory "+sciffDir.getPath()+"\n");
			stream.close();
			
			
			
			sciff=DebugPlugin.exec(cmdLine,sicstusDir);
			
		
			}catch(CoreException e){Utility.showError("SCIFF not loaded.\n Check the SCIFF path property!",true);
			sciff.destroy();
			}
			catch(IOException e){}
			
			return DebugPlugin.newProcess(launch,sciff,LaunchSciffConfigurationDelegate.SICStus_PROCESS,map);
			
	}
	
	public IProcess runProject(ILaunch launch)
	throws CoreException{
		IProcess[] processes=DebugPlugin.getDefault().getLaunchManager().getProcesses();
		for(int i=0;i<processes.length;i++)
		{
			if (processes[i].getLabel().equals(LaunchSciffConfigurationDelegate.SICStus_PROCESS))
			{
				process=processes[i];
				break;
				
			}
		}	
		
		if (process==null)
		{
			Utility.showError("Start sciff before compiling project.",true);
			return null;
		}
		
		try{
		if(configuration.getAttribute(LaunchSciffConfigurationDelegate.RUN_PROJECT_MODE,"").equals("run"))
			process.getStreamsProxy().write("run(_).\n");
		
		if(configuration.getAttribute(LaunchSciffConfigurationDelegate.RUN_PROJECT_MODE,"").equals("run_closed"))
			process.getStreamsProxy().write("run_closed(_).\n");
		
		if(configuration.getAttribute(LaunchSciffConfigurationDelegate.RUN_PROJECT_MODE,"").equals("run_open"))
			process.getStreamsProxy().write("run_open(_).\n");
		
		}catch(IOException e){}
		return process;
			
	}
	
	public IProcess compileProject(ILaunch launch)
	throws CoreException{
				
		projectName=configuration.getAttribute(PROJECT_NAME_ATTRIBUTE,"");	
		
		if (process==null)
		{
			Utility.showError("Start sciff before compiling project.",true);
			return null;
		}
		else{
			eraseAllMarkers(projectName);
		try{
		process.getStreamsProxy().write("project("+projectName+").\n");
		}catch(IOException e){}
		
		
		}
		
		return process;
	}
	// analizza il testo proveniente dalla console per creare il marker
	private static void getMarker(String out,String projectName)
	throws CoreException,IOException{
		
		String markerMessage;
		String[] lines=out.split("(?sm:\n)");
		String[] linesError;
		Vector vLinesError=new Vector();
		for (int i=0;i<lines.length;i++)
		{
			if ((lines[i].matches(".*OK\\r"))||(lines[i].equals("")))
			{}
			else
			vLinesError.add(lines[i]);
				
		}
		
		linesError=new String[vLinesError.size()];
		vLinesError.copyInto(linesError);
		String[] files=linesError[0].split("(?s:file)");
		String file=files[files.length-1];
		file=file.substring(0,file.length()-1);
		file=file.trim();
		String root=ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).getLocation().toString();
		String[] temp=file.split(root+"[/]");
		IPath path=new Path(temp[1]);
		
		IFile iFile=ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).getFile(path);
		File sysFile=new File(ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).getLocation().toOSString()+"\\"+path.toOSString());
		sysFile.exists();
		IMarker marker=iFile.createMarker("org.eclipse.core.resources.problemmarker");
		marker.setAttribute(IMarker.SEVERITY,IMarker.SEVERITY_ERROR);
		
		String[] markerLines=new String[2];
		
		
		if(Utility.isICS(sysFile.getName()))
		{
			
			
			for(int i=0;i<lines.length;i++)
			{
				if (lines[i].matches("(?s:.*Error in IC number.*)"))
				{
					
					markerLines[1]=lines[i];
					markerLines[0]=lines[i];
					for(int l=0;l<i;l++)
					{
						if(lines[l].matches("(?s:.*[***].*)"))
								markerLines[0]=lines[l];	
					}
					
				}
			}
			marker=getErrorLine(markerLines[1],sysFile,marker);
			
			markerMessage=markerLines[0].substring(4,linesError[1].length()-1);
			
			marker.setAttribute(IMarker.MESSAGE,markerMessage);
			
		}
		else
		{	
			for(int i=0;i<lines.length;i++)
			{
				if (lines[i].matches("(?s:.*Error in Event number.*)"))
				{
					
					markerLines[1]=lines[i];
					markerLines[0]=lines[i];
					for(int l=0;l<i;l++)
					{
						if(lines[l].matches("(?s:.*[***].*)"))
								markerLines[0]=lines[l];	
					}
					
				}
			}
			
			
			marker=getErrorLine(markerLines[1],sysFile,marker);
			markerMessage=markerLines[0].substring(4,linesError[1].length()-1);
			marker.setAttribute(IMarker.MESSAGE,markerMessage);
		
		}
		
	}
	
	private static IMarker getErrorLine(String error,File file,IMarker marker)
	throws IOException, CoreException{
		String[] errors=error.split("(?s)number");
		errors[1]=errors[1].trim();
		String temp=errors[1].substring(0,errors[1].length()-4);
		Integer integer=new Integer(temp);
		int i=integer.intValue();
		if(Utility.isICS(file.getName()))
		{
			int[] ic=Utility.getLineOfIc(i,file);
			marker.setAttribute(IMarker.CHAR_START,ic[0]);
			marker.setAttribute(IMarker.CHAR_END,ic[1]);
			marker.setAttribute(IMarker.LINE_NUMBER,ic[0]);
			return marker;
		}
		else
		{
			int line=Utility.getLineOfClause(i,file);
			marker.setAttribute(IMarker.LINE_NUMBER,line);
			return marker;
		}
	}
	
	
	private void eraseAllMarkers(String project)
	{
			try{
				ResourcesPlugin.getWorkspace().getRoot().getProject(project).deleteMarkers(IMarker.PROBLEM,false,IProject.DEPTH_INFINITE);
			}catch(CoreException e){Utility.showError("Error deleting marker.",true);}
		
	}
	
	private void getSokbMarkerFile(String out)
	{
		String[] lines=out.split("(?sm:\n)");
		String[] linesError;
		Vector vLinesError=new Vector();
		for (int i=0;i<lines.length;i++)
		{
			if ((lines[i].matches(".*OK\\r"))||(lines[i].equals("")))
			{}
			else
			vLinesError.add(lines[i]);
				
		}
		
		linesError=new String[vLinesError.size()];
		vLinesError.copyInto(linesError);
		String pre="Parsing file";
		
		
		String file=linesError[0].substring(pre.length(),linesError[0].length());
		file=file.trim();
		String root=ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).getLocation().toString();
		String[] temp=file.split(root+"[/]");
		IPath path=new Path(temp[1]);
		
		IFile iFile=ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).getFile(path);
		errorSokbFile=iFile;
		
	}
	
	private int getSokbErrorLine(String[] errors)
	{
		descriptionSokbMarker=errors[0];
		int i=0;
		String found=null;
		for(i=0;i<errors.length;i++)
		{
			if(errors[i].matches("(?sm).*in line.*"))
				found=errors[i];
		}
		
		String[] error=found.split("(?s)line");
		error[1]=error[1].substring(0,error[1].length()-1);
		error[1]=error[1].trim();
		Integer integer=new Integer(error[1]);
		
		return integer.intValue();
	}
	
	private boolean sokbMarkerCheck()
	{
		if((errorSokbFile!=null)&&(numberSokbError!=-1))
		return true;
		else return false;
	}
	
	private void createSokbMarker()
	{
		try{
		
		sokbMarkerCreated=true;
		
			if(errorSokbFile.exists())
			{
			IMarker sokbMarker=errorSokbFile.createMarker("org.eclipse.core.resources.problemmarker");
			
			sokbMarker.setAttribute(IMarker.SEVERITY,IMarker.SEVERITY_ERROR);
			sokbMarker.setAttribute(IMarker.MESSAGE,descriptionSokbMarker);
			sokbMarker.setAttribute(IMarker.LINE_NUMBER,numberSokbError);
			
			}
			
			
			
			}catch(CoreException e){
				System.out.println("Creazione marker fallita!\n");
			}
			
	}
	
	
}
