package sCIFF.launch;


import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.debug.core.model.IProcess; 
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugException;

import java.io.FileNotFoundException;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.IMarker;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

import sCIFF.Project;
import sCIFF.SCIFFPlugin;
import sCIFF.Utility;

public class LaunchConfigurationDelegate implements
		ILaunchConfigurationDelegate {
	
	public static String START_SCIFF_NAME="START SCIFF";
	public static String START_PROJECT_NAME="START PROJECT";
	public static String STOP_SCIFF_NAME="STOP SCIFF";
	public static String PROJECT_NAME_ATTRIBUTE="project";
	public static String SICStus_PROCESS="SICStus process";
	
	
	private ILaunchConfiguration configuration;
	private ILaunch launch;
	private String projectName;
	private String markerMessage;
	
	private Project projectHandle;
	private String projectDir;
	
	private String temp="@@@@@@@@@";
	
	private boolean projectCompiled=false;
	
	private boolean sokbMarkerCreated=false;
	private IFile errorSokbFile=null;
	private int numberSokbError=-1;
	private String descriptionSokbMarker;
	private MessageConsoleStream stream;
	
	
	private IProcess process;
	

	public void launch(ILaunchConfiguration configuration, String mode,
			ILaunch launch, IProgressMonitor monitor) throws CoreException {
		this.configuration=configuration;
		this.launch=launch;
		MessageConsole messageConsole;
		boolean found=false;
		
		
		
		IConsole[] consoles=ConsolePlugin.getDefault().getConsoleManager().getConsoles();
		
		for(int i=0;i<consoles.length;i++)
		{
			if(consoles[i].getName().equals("SCIFF errors"))
			{
				messageConsole=(MessageConsole)consoles[i];
				stream=messageConsole.newMessageStream();
				found=true;
			}
		}
		if(found==false)
		{
		messageConsole=new MessageConsole("SCIFF errors",ImageDescriptor.getMissingImageDescriptor());
		ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{messageConsole});
		ConsolePlugin.getDefault().getConsoleManager().showConsoleView(messageConsole);
		stream=messageConsole.newMessageStream();
		}
		
		
		try{
			
		startSciffProject();
		
		}catch(IOException e){
			Utility.showError("Error during the project launch.",true);
		}		
	}
	
	
	
	private void startSciffProject()
	throws  IOException{
		projectCompiled=false;
		sokbMarkerCreated=false;
		errorSokbFile=null;
		numberSokbError=-1;
		
		
		
		String sciffPath=SCIFFPlugin.getDefault().getPreferenceStore().getString(SCIFFPlugin.sciff_path);
		sciffPath=sciffPath.toLowerCase();
		sciffPath=sciffPath.replaceAll("\\\\","/");
		String sicstusPath=SCIFFPlugin.getDefault().getPreferenceStore().getString(SCIFFPlugin.sicstus_path);
		File sciffDir=new File(sciffPath);
		
		try{
		
		projectName=configuration.getAttribute(PROJECT_NAME_ATTRIBUTE,"");
		
		projectDir=ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).getLocation().toString();
		projectDir=projectDir.toLowerCase();
		temp=sciffDir.getAbsolutePath().replace(File.separatorChar,'/');
		temp=temp.toLowerCase();
		
		
		
		
		

		eraseAllMarkers(projectName);
		
		process=null;
		IProcess[] processes=DebugPlugin.getDefault().getLaunchManager().getProcesses();
		for(int i=0;i<processes.length;i++)
		{
			if (processes[i].getLabel().equals(SICStus_PROCESS))
			{
				processes[i].terminate();
			}
		}
		
		if(process==null)
		{
			
			if(sciffDir.isDirectory())
			{
				HashMap map=new HashMap();
				map.put(IProcess.ATTR_PROCESS_TYPE,"SCIFF_process");
				String[] cmdLine={sicstusPath+"\\sicstus.exe","--goal","['"+sciffPath+"/sciff.pl']."};
				stream.println("Executing "+cmdLine[0]+" "+cmdLine[1]+" "+cmdLine[2]+" ");
				stream.println("in directory "+sciffDir.getPath()+"\n");
				stream.close();
				
				Process p=DebugPlugin.exec(cmdLine,sciffDir);
				process=DebugPlugin.newProcess(launch,p,LaunchConfigurationDelegate.SICStus_PROCESS,map);
				
			}
		}
		else
		{
			try{
				process.getStreamsProxy().write("project("+projectName+").\n");
				projectCompiled=true;
				}catch(IOException e){Utility.showError("Error during console writing.",true);}
		}
		
		
		
		
		
		process.getStreamsProxy().getOutputStreamMonitor().addListener(new IStreamListener()
				{
					public void streamAppended(String text, IStreamMonitor monitor) 
					{
												
						
						if ((text.matches("(?sm).*[***].*"))&&(!text.matches("(?sm).*[****] Warning[:] atom in head [***].*"))){
							
							try{
							process.terminate();
							}catch(CoreException e){Utility.showError("Error during process termination.",true);}
							try{
							getMarker(text);
							
							
							}catch(CoreException e){Utility.showError("Error during marker writing.",true);}
							catch(IOException e){Utility.showError("Error during marker writing.",true);}
							}else{
							getSokbMarkerFile(text);
							if(sokbMarkerCheck()&&(!sokbMarkerCreated))
							{
								
								
								createSokbMarker();
								
							}
							}	
							
							
						
					}
				});
		
		process.getStreamsProxy().getErrorStreamMonitor().addListener(new IStreamListener()
				{
				
				
					
					public void streamAppended(String text, IStreamMonitor monitor) 
					{
						
						if((text.matches("(?sm:.*consulted "+temp+"/sciff.pl in module user.*)")))
						{
							try{
							process.getStreamsProxy().write("project("+projectName+").\n");
							projectCompiled=true;
							}catch(IOException e){Utility.showError("Error during console writing.",true);}
							
						}
						if(projectCompiled)
						{
							
							if(text.matches("(?sm:.*compiled "+projectDir+"/project.pl in module user.*)")&&!text.matches("(?sm:.*\n!.*)"))
							{
								try{
								
								process.getStreamsProxy().write("run.\n");
								monitor.removeListener(this);
								}catch(IOException e){Utility.showError("Error during console writing.",true);}
							}
							if(text.matches("(?sm:.*\n!.*)"))
							{
								try{
								process.terminate();
								}catch(DebugException e){}
								Vector vErrorLines=new Vector();
								String[] lines=text.split("\n");
								for(int i=0;i<lines.length;i++)
								{
									if (lines[i].startsWith("!"))
										vErrorLines.add(lines[i]);
								}
								String[] errorSokbLines=new String[vErrorLines.size()];
								vErrorLines.copyInto(errorSokbLines);
								numberSokbError=getSokbErrorLine(errorSokbLines);
								if(sokbMarkerCheck()&&(!sokbMarkerCreated))
								{
										
										
										createSokbMarker();
										
								}
								
							}
							
						}
					}
				});
		
		
		
	}catch(CoreException e){
		
		StackTraceElement[] stack=e.getStackTrace();
		for(int i=0;i<stack.length;i++)
		{
			stream.println(stack[i].getMethodName());
		}
		}
	}
	
	
	
	private void getMarker(String out)
	throws CoreException,IOException{
		
		String[] lines=out.split("(?sm:\n)");
		String[] linesError;
		Vector vLinesError=new Vector();
		for (int i=0;i<lines.length;i++)
		{
			if ((lines[i].matches(".*OK\\r"))||(lines[i].equals("")))
			{}
			else
			vLinesError.add(lines[i]);
				
		}
		
		linesError=new String[vLinesError.size()];
		vLinesError.copyInto(linesError);
		String pre="Parsing file";
		
		
		String file=linesError[0].substring(pre.length(),linesError[0].length()-1);
		file=file.trim();
		String root=ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).getLocation().toString();
		String[] temp=file.split(root+"[/]");
		IPath path=new Path(temp[1]);
		
		IFile iFile=ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).getFile(path);
		File sysFile=new File(ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).getLocation().toOSString()+"\\"+path.toOSString());
		sysFile.exists();
		IMarker marker=iFile.createMarker("org.eclipse.core.resources.problemmarker");
		marker.setAttribute(IMarker.SEVERITY,IMarker.SEVERITY_ERROR);
		
		String[] markerLines=new String[2];
		
		
		if(Utility.isICS(sysFile.getName()))
		{
			
			
			for(int i=0;i<lines.length;i++)
			{
				if (lines[i].matches("(?s:.*Error in IC number.*)"))
				{
					markerLines[0]=lines[i-1];
					markerLines[1]=lines[i];
					
				}
			}
			marker=getErrorLine(markerLines[1],sysFile,marker);
			
			markerMessage=markerLines[0].substring(4,linesError[1].length()-1);
			
			marker.setAttribute(IMarker.MESSAGE,markerMessage);
		}
		else
			marker=getErrorLine(linesError[2],sysFile,marker);
			markerMessage=linesError[1].substring(4,linesError[1].length()-1);
		
			marker.setAttribute(IMarker.MESSAGE,markerMessage);
		
		
		
	}
	
	private IMarker getErrorLine(String error,File file,IMarker marker)
	throws IOException, CoreException{
		String[] errors=error.split("(?s)number");
		errors[1]=errors[1].trim();
		String temp=errors[1].substring(0,errors[1].length()-4);
		Integer integer=new Integer(temp);
		int i=integer.intValue();
		if(Utility.isICS(file.getName()))
		{
			int[] ic=Utility.getLineOfIc(i,file);
			marker.setAttribute(IMarker.CHAR_START,ic[0]);
			marker.setAttribute(IMarker.CHAR_END,ic[1]);
			marker.setAttribute(IMarker.LINE_NUMBER,ic[0]);
			return marker;
		}
		else
		{
			int line=Utility.getLineOfClause(i,file);
			marker.setAttribute(IMarker.LINE_NUMBER,line);
			return marker;
		}
	}
	
	
	private void eraseAllMarkers(String project)
	{
		IFile projectFile=ResourcesPlugin.getWorkspace().getRoot().getProject(project).getFile("project.pl");
		
		projectHandle=new Project(projectFile);
		projectHandle.getFiles();
		IFile[] files=projectHandle.files;
		for(int i=0;i<files.length;i++)
		{
			
			try{
				
			    files[i].deleteMarkers(IMarker.PROBLEM,true,IResource.DEPTH_INFINITE);
			}catch(CoreException e){Utility.showError("Error deleting marker.",true);}
		}
		
	}
	
	private void getSokbMarkerFile(String out)
	{
		String[] lines=out.split("(?sm:\n)");
		String[] linesError;
		Vector vLinesError=new Vector();
		for (int i=0;i<lines.length;i++)
		{
			if ((lines[i].matches(".*OK\\r"))||(lines[i].equals("")))
			{}
			else
			vLinesError.add(lines[i]);
				
		}
		
		linesError=new String[vLinesError.size()];
		vLinesError.copyInto(linesError);
		String pre="Parsing file";
		
		
		String file=linesError[0].substring(pre.length(),linesError[0].length());
		file=file.trim();
		String root=ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).getLocation().toString();
		String[] temp=file.split(root+"[/]");
		IPath path=new Path(temp[1]);
		
		IFile iFile=ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).getFile(path);
		errorSokbFile=iFile;
		
	}
	
	private int getSokbErrorLine(String[] errors)
	{
		descriptionSokbMarker=errors[0];
		int i=0;
		String found=null;
		for(i=0;i<errors.length;i++)
		{
			if(errors[i].matches("(?sm).*in line.*"))
				found=errors[i];
		}
		
		String[] error=found.split("(?s)line");
		error[1]=error[1].substring(0,error[1].length()-1);
		error[1]=error[1].trim();
		Integer integer=new Integer(error[1]);
		
		return integer.intValue();
	}
	
	private boolean sokbMarkerCheck()
	{
		if((errorSokbFile!=null)&&(numberSokbError!=-1))
		return true;
		else return false;
	}
	
	private void createSokbMarker()
	{
		try{
		
		sokbMarkerCreated=true;
		
			
			if(errorSokbFile.exists())
			{
			IMarker sokbMarker=errorSokbFile.createMarker("org.eclipse.core.resources.problemmarker");
			
			sokbMarker.setAttribute(IMarker.SEVERITY,IMarker.SEVERITY_ERROR);
			sokbMarker.setAttribute(IMarker.MESSAGE,descriptionSokbMarker);
			sokbMarker.setAttribute(IMarker.LINE_NUMBER,numberSokbError);
			
			}
			
			
			
			}catch(CoreException e){
				System.out.println("Creazione marker fallita!\n");
			}
			
	}
	

}
