package sCIFF.launch;

import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.console.IConsole;
import org.eclipse.debug.ui.console.IConsoleColorProvider;
import org.eclipse.swt.graphics.Color;
import sCIFF.EDITOR.ColorManager;
import sCIFF.EDITOR.IColorConstants;

public class ConsoleColorProvider implements IConsoleColorProvider {
	IConsole console;
	IProcess process;
	ColorManager colorManager=new ColorManager();
	
	

	public boolean isReadOnly() {
		
		return false;
	}

	public Color getColor(String streamIdentifer) {
		if (streamIdentifer.equals("org.eclipse.debug.ui.ID_STANDARD_ERROR_STREAM"))
			return colorManager.getColor(IColorConstants.DEFAULT);
		if (streamIdentifer.equals("org.eclipse.debug.ui.ID_STANDARD_OUTPUT_STREAM"))
			return colorManager.getColor(IColorConstants.ICS_COMMENT);
		else return colorManager.getColor(IColorConstants.OPERATOR);
	}

	public void connect(IProcess process, IConsole console) {
		this.console=console;
		this.process=process;
		console.connect(process.getStreamsProxy());
		
	}

	public void disconnect() {

	}

}
