package sCIFF;

import javax.xml.parsers.DocumentBuilder; 
import javax.xml.parsers.DocumentBuilderFactory;  
import javax.xml.parsers.FactoryConfigurationError;  
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;  
import org.xml.sax.SAXParseException;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.w3c.dom.DOMException;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import java.io.File;
import java.lang.StringBuffer;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.eclipse.core.runtime.QualifiedName;
import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Display;
import java.net.URL;
import org.eclipse.core.runtime.Path;
import java.io.FileWriter;
import org.eclipse.core.runtime.Platform;

public class Utility {
	public static final QualifiedName fileType=new QualifiedName(null,"file_type");
	public static final String icsType="ics";
	public static final String rulemlType="ruleml";
	public static final String sokbType="sokb";
	public static final String historyType="his";

	public Utility() {
		super();
		// TODO Auto-generated constructor stub
	}
	
	public static void copyFile(String sourceDir,String file,IContainer destDir)
	{
		IFile destFile;
		String sPath=sourceDir+"\\"+file;
		File fileFrom=new File(sPath);
		try{
		FileInputStream in=new FileInputStream(fileFrom);
		if (destDir instanceof IFolder)
		{
		
		
		
		if (((IFolder)destDir).getName().equals("ICS"))
		{
			file=renameExtension(file,"ics");
			destFile=((IFolder)destDir).getFile(file);
			destFile.create(in,true,null);
		}
		
		if (((IFolder)destDir).getName().equals("SOKB"))
		{
			file=renameExtension(file,"sokb");
			destFile=((IFolder)destDir).getFile(file);
			destFile.create(in,true,null);
		}
		
		if (((IFolder)destDir).getName().equals("HISTORY"))
		{
			file=renameExtension(file,"his");
			destFile=((IFolder)destDir).getFile(file);
			destFile.create(in,true,null);
		}
		
		}
		else if(destDir instanceof IProject)
		{
		destFile=((IProject)destDir).getFile(file);
		destFile.create(in,true,null);
		}
				
		}catch(FileNotFoundException ex){Utility.showError("File not found.",false);}
		catch(CoreException ex){Utility.showError("Error creating file.",false);}
			
	}
	
	public static void copy(File origin,IContainer dest,String type)
	throws FileNotFoundException,CoreException{
		IFile destFile;
		Path destPath;
		
		if(type.equals(historyType))
		{
			destPath=new Path(Utility.renameExtension(origin.getName(),"his"));
			destFile=dest.getFile(destPath);
		}else
		if(type.equals(icsType))
		{
			destPath=new Path(Utility.renameExtension(origin.getName(),"ics"));
			destFile=dest.getFile(destPath);
		}else
		if(type.equals(rulemlType))
		{
			destPath=new Path(origin.getName());
			destFile=dest.getFile(destPath);
		}else
		if(type.equals(sokbType))
		{
			destPath=new Path(Utility.renameExtension(origin.getName(),"sokb"));
			destFile=dest.getFile(destPath);
		}else
		
		{
			destPath=new Path(origin.getName());
			destFile=dest.getFile(destPath);
		}
		
		FileInputStream stream=new FileInputStream(origin);
		destFile.create(stream,true,null);
	}
	
	public static void addFileToProjectFile(IFile project,IFolder folder,String nameFile,String type)
	{
		String line;
		
		if(type.equals(historyType))
		{
			nameFile=renameExtension(nameFile,"his");
		}
		
		if(type.equals(icsType))
		{
			nameFile=renameExtension(nameFile,"ics");
		}
		
		if(type.equals(sokbType))
		{
			nameFile=renameExtension(nameFile,"sokb");
		}
		
		String relPath="/"+folder.getName()+"/"+nameFile;
		if(folder.getName().equals("HISTORY"))
		{
			line="history_file('"+relPath+"').\n";
			addLineToProjectFile(project,line);
		}
		
		if(folder.getName().equals("ICS"))
		{
			line="ics_file('"+relPath+"').\n";
			addLineToProjectFile(project,line);
		}
		
		if(folder.getName().equals("SOKB"))
		{
			line="sokb_file('"+relPath+"').\n";
			addLineToProjectFile(project,line);
		}
		
	}
	
	public static void addLineToProjectFile(IFile project,String line)
	{
		StringBuffer temp=new StringBuffer();
		InputStreamReader reader;
		int x;
		try{
		reader=new InputStreamReader(project.getContents());
		
		
		try{
		while ((x=reader.read())>=0)
		{
			temp.append((char)x);
		}
		}catch(IOException e){Utility.showError(e.getMessage(),false);}
		
		temp.insert(temp.indexOf("\n")+2,line);
		ByteArrayInputStream s=new ByteArrayInputStream(temp.toString().getBytes());
		project.setContents(s,true,false,null);
		}catch(CoreException e){Utility.showError("Error nell'accesso al file project.pl.",false);}
	}
	
	public static String getFileType(IFile file)
	throws CoreException{
		return file.getPersistentProperty(fileType);
	}
	
	public static String renameExtension(String file,String ext)
	{
		int i;
		char[] chars=file.toCharArray();
		for(i=(chars.length-1);i>0;i--)
		{
			if (chars[i]=='.')
				break;
		}
		String result=file.substring(0,i)+"."+ext;
		return result;
	}
	
	//Restituisce tutti i progetti che presentano SCIFF nature nel workspace
	public static IProject[] getSciffNature(IWorkspaceRoot workRoot)
	throws CoreException{
		IProject[] projects=workRoot.getProjects();
		Vector vProjects=new Vector();
		
		for(int i=0;i<projects.length;i++)
		{
			if (projects[i].hasNature("SCIFF.SCIFFnature"))
				vProjects.add(projects[i]);
		}
		
		IProject[] sciffProjects=new IProject[vProjects.size()];
		vProjects.copyInto(sciffProjects);
		
		return sciffProjects;
		
	}
	
	public static int getLineOfClause(int n,File file)
	throws IOException, CoreException{
	
		int line=1;
		int lineFinal=1;
		int clause=0;
		
		
		boolean icFound=false;
		StringBuffer buffer=new StringBuffer("");
		int c;
		FileInputStream content=new FileInputStream(file);
		while((c=content.read())>=0)
		{
			buffer.append((char)c);
		}
		content.close();
		String stringContent=buffer.toString();
		
		for(int i=0;i<stringContent.length();i++)
		{
			if(stringContent.charAt(i)=='\n')
				line++;
			if (stringContent.charAt(i)=='%')
			{
				while(!(stringContent.charAt(i)=='\n'))
				{
					i++;
				}
				i++;
				line++;
			}
			if ((stringContent.charAt(i)=='/')&&(stringContent.charAt(i+1)=='*'))
			{
				while(!((stringContent.charAt(i)=='*')&&(stringContent.charAt(i+1)=='/')))
				{
					i++;
					if(stringContent.charAt(i)=='\n')
						line++;
				}
				i=i+2;
			}
			if (((int)(stringContent.charAt(i))>=((int)'A'))&&((int)(stringContent.charAt(i))<=((int)'Z'))||((int)(stringContent.charAt(i))>=((int)'a'))&&((int)(stringContent.charAt(i))<=((int)'z')))
			{
				if(icFound==false)
				{
					icFound=true;
					clause++;
					if(clause==n)
					{
						lineFinal=line;
						break;
					}
					
				}
				
			
			}
			if(stringContent.charAt(i)=='.')
			{
				if(icFound==true)
				{
					icFound=false;
				}
			}
		}
		
		
		
		return lineFinal;
	}
	
	public static void showError(String message,boolean nonUI)
	{
		Shell parentShell;
		if(nonUI)
		{
		Display display=new Display();
		parentShell=new Shell(display);
		}else{
			parentShell=SCIFFPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
		}
		
		MessageDialog dialog=new MessageDialog(parentShell,"Error",null,message,MessageDialog.ERROR,new String[]{"OK"},1);
		
		dialog.create();
		dialog.open();
	}
	
	public static boolean isICS(String file)
	{
		String ext=file.substring(file.lastIndexOf(".")+1);
		if (ext.equals("ics"))
			return true;
		else return false;
	}
	
	public static int[] getLineOfIc(int n,File file)
	throws IOException, CoreException{
			Vector vIcs=new Vector();
			int ics=0;
			int[] ic=new int[2];
			boolean icFound=false;
			StringBuffer buffer=new StringBuffer("");
			int c;
			FileInputStream content=new FileInputStream(file);
			while((c=content.read())>=0)
			{
				buffer.append((char)c);
			}
			content.close();
			String stringContent=buffer.toString();
			
			for(int i=0;i<stringContent.length();i++)
			{
				if (stringContent.charAt(i)=='%')
				{
					while(!(stringContent.charAt(i)=='\n'))
					{
						i++;
					}
					i++;
				}
				if ((stringContent.charAt(i)=='/')&&(stringContent.charAt(i+1)=='*'))
				{
					while(!((stringContent.charAt(i)=='*')&&(stringContent.charAt(i+1)=='/')))
					{
						i++;
					}
					i=i+2;
				}
				if (((int)(stringContent.charAt(i))>=((int)'A'))&&((int)(stringContent.charAt(i))<=((int)'Z')))
				{
					if(icFound==false)
					{
						icFound=true;
						ics++;
						ic[0]=i;
					}
					
				
				}
				if(stringContent.charAt(i)=='.')
				{
					if(icFound==true)
					{
						icFound=false;
						ic[1]=i;
						vIcs.add(new int[]{ic[0],ic[1]});
					}
				}
			}
			int[][] icsRange=new int[vIcs.size()][2];
			vIcs.copyInto(icsRange);
			
			
			return icsRange[n-1];
	}
	
	public static void refreshTocFile(String  path)
	throws IOException{
		path=path.replaceAll("\\\\","/");
		String content=	"<toc label="+'"'+"Sciff Help"+'"'+"  >\n"+
						"\t<topic label="+'"'+"User Manual"+'"'+" href="+'"'+"file:/"+path+"/userman.html"+'"'+"/>\n"+
						"\t<topic label="+'"'+"Developer Manual"+'"'+" href="+'"'+"file:/"+path+"/devman.html"+'"'+"/>\n"+
						"\t<topic label="+'"'+"Sciff Home Page"+'"'+" href="+'"'+"http://lia.deis.unibo.it/research/sciff/"+'"'+"/>\n"+
						"</toc>";
		Path pathToc=new Path("/help/toc.xml");
		URL url=SCIFFPlugin.getDefault().find(pathToc);
		url=Platform.asLocalURL(url);
		String stringTocPath=url.getPath();
		stringTocPath=stringTocPath.substring(1);
		File file=new File(stringTocPath.replaceAll("/","\\\\"));
		if(file.exists())
		{
			
			FileWriter writer=new FileWriter(file,false);
			writer.write(content);
			writer.close();
		}
	}
	
	public static String getRelativePath(File file,File dir)
	{
		String stringFile=file.getAbsolutePath();
		String stringDir=dir.getAbsolutePath();
		stringFile=stringFile.substring(stringDir.length()+1);
		return stringFile;
	}
	
	//ritorna il contenuto di un file
	public static String getFileContent(File file)
	throws FileNotFoundException{
		String content;
		StringBuffer buffer=new StringBuffer("");
		int c;
		FileInputStream stream=new FileInputStream(file);
		try{
		while((c=stream.read())>0)
		{
			buffer.append((char)c);
		}
		stream.close();
		}catch(IOException e){}
		content=buffer.toString();
		return content;
		
	}
	
	//elimina i commenti ("%", "/*----*/") da un testo
	public static String uncomment(String comment)
	{
		String[] temp=comment.split("(?s:[%][^\n]*)");
		comment="";
		for(int i=0;i<temp.length;i++)
		{
			comment+=temp[i];
		}
		temp=comment.split("(?sm:[/][*].*[*][/])");
		comment="";
		for(int i=0;i<temp.length;i++)
		{
			comment+=temp[i];
		}
		return comment;
	}
	
	//ricava i fatti prolog da un codice prolog
	public static String getFact(String content)
	{
		boolean currentBlock=false;
		boolean isRule=false;
		boolean quote=false;
		int counter=0;
		for (int i=0;i<content.length();i++)
		{
			if((content.charAt(i)=='\'')&&(!quote))
			{
				quote=true;
			}else
			if((content.charAt(i)=='\'')&&(quote))
			{
				quote=false;
			}else
			if(!quote)
			{
			if (currentBlock)
			{
				if ((content.charAt(i)==':')&&(content.charAt(i+1)=='-'))
				{
					isRule=true;
				}
				if (content.charAt(i)=='.')
				{
					if(isRule)
					{
						String tmp1=content.substring(0,counter);
						String tmp2=content.substring(i+1);
						content=tmp1+tmp2;
						i=counter;
						currentBlock=false;
						isRule=false;
					}
					else
					{
						currentBlock=false;
					}
				}
				
			}
			if (((content.charAt(i)==':')&&(content.charAt(i+1)=='-'))&&(!currentBlock))
			{
				isRule=true;
				currentBlock=true;
				counter=i;
			}
			
			if((((content.charAt(i))>=('A'))&&((content.charAt(i))<=('Z')))|(((content.charAt(i))>=('a'))&&((content.charAt(i))<=('z')))&&(!currentBlock))
			{
				currentBlock=true;
				counter=i;
			}
			}
		}
		
		return content;
	}
	
	//ritorna i predicati di nome "name" all'interno del testo "text"
	public static String[] getPredicates(String name, String text)
	{
	Vector vPredicates=new Vector();
	int l=0;
	for (int i=0;i<text.length();i++)
	{
		if(text.substring(i).startsWith(name+"("))
		{
			l=0;
			while (text.charAt(i+l)!='.')
				{
				l++;
				
				}
			vPredicates.add(text.substring(i,i+l));
		}
	}
	String[] predicates=new String[vPredicates.size()];
	vPredicates.copyInto(predicates);
	return predicates;
	}
	
	public static String getParameterHints(String type)
	{
		String result;
		
		try{
		URL url=SCIFFPlugin.getDefault().find(new Path("\\parameter_help\\parameter.xml"));
		url=Platform.asLocalURL(url);
		File file=new File(url.getPath().substring(1));
		
		
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		DocumentBuilder builder = factory.newDocumentBuilder();
		Document document = builder.parse(file);
		NodeList list=document.getElementsByTagName("parameter");
		list=list.item(0).getChildNodes();
		for(int i=0;i<list.getLength();i++)
		{
			if (list.item(i).getNodeName().equals(type))
			{
				return list.item(i).getChildNodes().item(0).getNodeValue();
			}
				
		}
		}catch(ParserConfigurationException spe){}
		catch(IOException e){}
		catch(SAXException spe){}
		
		return "";
	}

}
