package sCIFF;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import java.io.IOException;

public class SciffPathPreferencePage extends PreferencePage implements
		IWorkbenchPreferencePage {
	Text containerSOCSField,containerSCIFFField,containerSicstusField;
	String customSOCSFieldValue,customSCIFFFieldValue,customSicstusFieldValue,proof;
	Button containerBrowseButton,containerBrowseButton2,sicstusBrowseButton,proofCheck;

	public SciffPathPreferencePage() {
		super();
		// TODO Auto-generated constructor stub
	}

	public SciffPathPreferencePage(String title) {
		super(title);
		// TODO Auto-generated constructor stub
	}

	public SciffPathPreferencePage(String title, ImageDescriptor image) {
		super(title, image);
		// TODO Auto-generated constructor stub
	}

	protected Control createContents(Composite parent) {
		Composite composite = new Composite(parent, SWT.NULL);
        composite.setFont(parent.getFont());
        composite.setLayout(new GridLayout());
        composite.setLayoutData(new GridData(GridData.FILL_BOTH));
		
        Composite containerGroup = new Composite(composite, SWT.NONE);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        containerGroup.setLayout(layout);
        containerGroup.setLayoutData(new GridData(
                GridData.HORIZONTAL_ALIGN_FILL | GridData.GRAB_HORIZONTAL));
        containerGroup.setFont(parent.getFont());
        
        

        // container label
        Label resourcesLabel = new Label(containerGroup, SWT.NONE);
        resourcesLabel.setText("SOCS-SI folder:");
        resourcesLabel.setFont(parent.getFont());

        // container name entry field
        containerSOCSField = new Text(containerGroup, SWT.SINGLE | SWT.BORDER);
        GridData data = new GridData(GridData.HORIZONTAL_ALIGN_FILL
                | GridData.GRAB_HORIZONTAL);
        data.widthHint = 250;
        containerSOCSField.setLayoutData(data);
        containerSOCSField.setFont(parent.getFont());
        if (getPreferenceStore().getString(SCIFFPlugin.socs_path)!=null)
        	containerSOCSField.setText(getPreferenceStore().getString(SCIFFPlugin.socs_path));
        
        // container browse button
        containerBrowseButton = new Button(containerGroup, SWT.PUSH);
        containerBrowseButton.setText("Browse...");
        containerBrowseButton.setLayoutData(new GridData(
                GridData.HORIZONTAL_ALIGN_FILL));
        containerBrowseButton.setFont(parent.getFont());
        setButtonLayoutData(containerBrowseButton);
        containerBrowseButton.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent event) {
                DirectoryDialog dialog=new DirectoryDialog(containerSOCSField.getShell());
                dialog.setMessage("Seleziona directory contenente la gui SOCS-SI:");                             
                String selectedDirectory = dialog.open();
                if (selectedDirectory != null) {
                    containerSOCSField.setText(selectedDirectory);
                }
            }
        });
        
//      container label
        Label sicstusLabel = new Label(containerGroup, SWT.NONE);
        sicstusLabel.setText("SICStus Prolog executable:");
        sicstusLabel.setFont(parent.getFont());

        // container name entry field
        containerSicstusField = new Text(containerGroup, SWT.SINGLE | SWT.BORDER);
        containerSicstusField.setLayoutData(data);
        containerSicstusField.setFont(parent.getFont());
        if (getPreferenceStore().getString(SCIFFPlugin.sicstus_path)!=null)
        	containerSicstusField.setText(getPreferenceStore().getString(SCIFFPlugin.sicstus_path));
        
        // container browse button
        sicstusBrowseButton = new Button(containerGroup, SWT.PUSH);
        sicstusBrowseButton.setText("Browse...");
        sicstusBrowseButton.setLayoutData(new GridData(
                GridData.HORIZONTAL_ALIGN_FILL));
        sicstusBrowseButton.setFont(parent.getFont());
        setButtonLayoutData(sicstusBrowseButton);
        sicstusBrowseButton.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent event) {
                FileDialog dialog=new FileDialog(containerSicstusField.getShell());                          
                String selectedDirectory = dialog.open();
                if (selectedDirectory != null) {
                	containerSicstusField.setText(selectedDirectory);
                }
            }
        });
        
//      container label
        Label resourcesLabel2 = new Label(containerGroup, SWT.NONE);
        resourcesLabel2.setText("SCIFF folder:");
        resourcesLabel2.setFont(parent.getFont());

        // container name entry field
        containerSCIFFField = new Text(containerGroup, SWT.SINGLE | SWT.BORDER);
        containerSCIFFField.setLayoutData(data);
        containerSCIFFField.setFont(parent.getFont());
        if (getPreferenceStore().getString(SCIFFPlugin.sciff_path)!=null)
        	containerSCIFFField.setText(getPreferenceStore().getString(SCIFFPlugin.sciff_path));
        
        // container browse button
        containerBrowseButton2 = new Button(containerGroup, SWT.PUSH);
        containerBrowseButton2.setText("Browse...");
        containerBrowseButton2.setLayoutData(new GridData(
                GridData.HORIZONTAL_ALIGN_FILL));
        containerBrowseButton2.setFont(parent.getFont());
        setButtonLayoutData(containerBrowseButton2);
        containerBrowseButton2.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent event) {
                DirectoryDialog dialog=new DirectoryDialog(containerSCIFFField.getShell());
                dialog.setMessage("Seleziona directory contenente SCIFF:");                             
                String selectedDirectory = dialog.open();
                if (selectedDirectory != null) {
                    containerSCIFFField.setText(selectedDirectory);
                }
            }
        });
        
        proof=getPreferenceStore().getString(SCIFFPlugin.proof);
        	
        proofCheck=new Button(containerGroup,SWT.CHECK);
        proofCheck.setText("Use this version also with SOCS-SI");
        
        if(proof.equals("true"))
        	proofCheck.setSelection(true);
        else
        	proofCheck.setSelection(false);
        proofCheck.addSelectionListener(new SelectionAdapter(){
			public void widgetSelected(SelectionEvent e){
				Button button=(Button)e.widget;
				if(button.getSelection())
					proof="true";
				else
					proof="false";
			}
		});
        return composite;
	}

	public void init(IWorkbench workbench) {
		setPreferenceStore(SCIFFPlugin.getDefault().getPreferenceStore());
		
	}
	
	public boolean performOk()
	{
		getPreferenceStore().setValue(SCIFFPlugin.socs_path,containerSOCSField.getText());
		getPreferenceStore().setValue(SCIFFPlugin.sciff_path,containerSCIFFField.getText());
		getPreferenceStore().setValue(SCIFFPlugin.sicstus_path,containerSicstusField.getText());
		getPreferenceStore().setValue(SCIFFPlugin.proof,proof);
		try{
		Utility.refreshTocFile(containerSCIFFField.getText());
		}catch(IOException e){}
		return super.performOk();
		
	}
	
}
