package sCIFF;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Label;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.core.runtime.CoreException;

import sCIFF.launch.LaunchConfigurationDelegate;

public class SCIFFTab extends CommonTab {
	
	private Combo projectCombo;
	
	private String projectName;
	private IProject[] projects;
	

	public SCIFFTab() {
		super();
		
	}
	public void createControl(Composite parent) {	
		super.createControl(parent);
		Composite composite = new Composite(parent, SWT.NULL);
		setControl(composite);
        composite.setFont(parent.getFont());
        composite.setLayout(new GridLayout());
        composite.setLayoutData(new GridData(GridData.FILL_BOTH));
		
        Composite containerGroup = new Composite(composite, SWT.NONE);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        containerGroup.setLayout(layout);
        containerGroup.setLayoutData(new GridData(
                GridData.HORIZONTAL_ALIGN_FILL | GridData.GRAB_HORIZONTAL));
        containerGroup.setFont(parent.getFont());

        // container label
        Label resourcesLabel = new Label(containerGroup, SWT.NONE);
        resourcesLabel.setText("Source project:");
        resourcesLabel.setFont(parent.getFont());

        // container name entry field
        projectCombo=new Combo(containerGroup,SWT.DROP_DOWN); 
        IWorkspaceRoot workRoot=ResourcesPlugin.getWorkspace().getRoot();
        projects=workRoot.getProjects();
        for(int i=0;i<projects.length;i++)
        {
        	projectCombo.add(projects[i].getName());
        }
        projectCombo.addModifyListener(new ModifyListener(){
        	public void modifyText(ModifyEvent e)
        	{
        		if (e.widget instanceof Combo)
        		{
        			Combo project=(Combo)e.widget;
        			projectName=project.getItem(project.getSelectionIndex());
        			getLaunchConfigurationDialog().updateButtons();
        			
        		}
        	}
        });
        
	}
	
	public void initializeFrom(ILaunchConfiguration configuration)
	{
		String name="";
		try{
		name=configuration.getAttribute(LaunchConfigurationDelegate.PROJECT_NAME_ATTRIBUTE,"");
		}catch(CoreException e){}
		for(int i=0;i<projectCombo.getItemCount();i++)
		{
			if (projectCombo.getItem(i).equals(name))
				projectCombo.select(i);
		}
	}
	
	public String getProject()
	{
		return projectName;
	}
	
	public void performApply(ILaunchConfigurationWorkingCopy configuration) {
		configuration.exists();
		configuration.setAttribute("project",projectName);
	}

}
