package sCIFF;

import org.eclipse.ui.plugin.*;
import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.framework.BundleContext;

/**
 * The main plugin class to be used in the desktop.
 */
public class SCIFFPlugin extends AbstractUIPlugin {
	
	public static final String socs_path="SOCS_PATH"; 
	public static final String sciff_path="SCIFF_PATH";
	public static final String sicstus_path="SICSTUS_PATH";
	public static final String proof="PROOF";
	private NavigatorView navigator;

	//The shared instance.
	private static SCIFFPlugin plugin;
	
	/**
	 * The constructor.
	 */
	public SCIFFPlugin() {
		plugin = this;		
		}

	/**
	 * This method is called upon plug-in activation
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
		
	}

	/**
	 * This method is called when the plug-in is stopped
	 */
	public void stop(BundleContext context) throws Exception {
		super.stop(context);
		plugin = null;
	}

	/**
	 * Returns the shared instance.
	 */
	public static SCIFFPlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns an image descriptor for the image file at the given
	 * plug-in relative path.
	 *
	 * @param path the path
	 * @return the image descriptor
	 */
	public static ImageDescriptor getImageDescriptor(String path) {
		return AbstractUIPlugin.imageDescriptorFromPlugin("SCIFF", path);
	
	}
	public void setNavigator(NavigatorView navigator)
	{
		this.navigator=navigator;
	}
	
	public NavigatorView getNavigator()
	{
		return this.navigator;
	}
	
	
	
}
