package sCIFF;


import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.DirectoryDialog;
import java.io.File;
import java.io.FilenameFilter;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.wizard.WizardPage;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import org.eclipse.core.runtime.Path;

import org.eclipse.core.runtime.CoreException;
import java.io.InputStreamReader;

public class SCIFFImportPage extends WizardPage {
	private Text containerNameField;
	private Button containerBrowseButton;
	private String customLocationFieldValue;
	private IFolder HistoryFolder,IcsFolder,SokbFolder;
	private IProject project;
	private static final int SIZING_TEXT_FIELD_WIDTH = 250;
	private String match;
	private IWorkspaceRoot workRoot;
	private IFile projectFile;
	private String[] others;
	private File dir;
	private File originalProjectFile; 
	private String projectContent;

	public SCIFFImportPage(String name) {
		super(name);
		setPageComplete(false);
        customLocationFieldValue = "";
	}
	
	

	public void createControl(Composite parent) {
		// TODO Auto-generated method stub
		//	container specification group
		Composite composite = new Composite(parent, SWT.NULL);
        composite.setFont(parent.getFont());
        composite.setLayout(new GridLayout());
        composite.setLayoutData(new GridData(GridData.FILL_BOTH));
		
        Composite containerGroup = new Composite(composite, SWT.NONE);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        containerGroup.setLayout(layout);
        containerGroup.setLayoutData(new GridData(
                GridData.HORIZONTAL_ALIGN_FILL | GridData.GRAB_HORIZONTAL));
        containerGroup.setFont(parent.getFont());

        // container label
        Label resourcesLabel = new Label(containerGroup, SWT.NONE);
        resourcesLabel.setText("Source folder:");
        resourcesLabel.setFont(parent.getFont());

        // container name entry field
        containerNameField = new Text(containerGroup, SWT.SINGLE | SWT.BORDER);
        GridData data = new GridData(GridData.HORIZONTAL_ALIGN_FILL
                | GridData.GRAB_HORIZONTAL);
        data.widthHint = SIZING_TEXT_FIELD_WIDTH;
        containerNameField.setLayoutData(data);
        containerNameField.setFont(parent.getFont());
        containerNameField.addModifyListener(new ModifyListener(){
        	public void modifyText(ModifyEvent e)
        	{
        		customLocationFieldValue=containerNameField.getText();
        		if (validateDirectory(customLocationFieldValue))
        			setPageComplete(true);
        		else setPageComplete(false);
        	}
        });
        // container browse button
        containerBrowseButton = new Button(containerGroup, SWT.PUSH);
        containerBrowseButton.setText("Browse...");
        containerBrowseButton.setLayoutData(new GridData(
                GridData.HORIZONTAL_ALIGN_FILL));
        containerBrowseButton.setFont(parent.getFont());
        setButtonLayoutData(containerBrowseButton);
        containerBrowseButton.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent event) {
                DirectoryDialog dialog=new DirectoryDialog(containerNameField.getShell());
                dialog.setMessage("Seleziona directory origine:");                             
                String selectedDirectory = dialog.open();
                if (selectedDirectory != null) {
                    containerNameField.setText(selectedDirectory);
                }
            }
        });
        
        setErrorMessage(null);
        setMessage(null);
        setControl(composite);
	}
	
	public boolean validateDirectory(String directory)
	{
		dir=new File(directory);
		if (dir.isDirectory())
		return true;
		else return false;
	}
	
	//crea la struttura del progetto in eclipse e poi si occupa di popolarla,
	//modificando, laddove ve ne sia la necessit, il file project.pl
	public boolean createProject()
	{
		
		workRoot=ResourcesPlugin.getWorkspace().getRoot();
		dir=new File(customLocationFieldValue);
		originalProjectFile=new File(dir,"project.pl");
		try{
		
		
		if(dir.isDirectory())
		{
			if(originalProjectFile.exists())
			{
				FileInputStream stream=new FileInputStream(originalProjectFile);
				if(CleanSCIFFproject.CreateImport(dir.getName())==false)
					return false;
				else{
					project=workRoot.getProject(dir.getName());
					if(project.exists())
					{
					HistoryFolder=project.getFolder("HISTORY");
					IcsFolder=project.getFolder("ICS");
					SokbFolder=project.getFolder("SOKB");
					projectFile=project.getFile("project.pl");
					
					projectFile.create(stream,true,null);
					copyFolderContent(dir,project);
				}
				
				}
			}else{
				if(CleanSCIFFproject.Create(dir.getName())==false)
					return false;
				else{
					project=workRoot.getProject(dir.getName());
					if(project.exists())
					{
					HistoryFolder=project.getFolder("HISTORY");
					IcsFolder=project.getFolder("ICS");
					SokbFolder=project.getFolder("SOKB");
					projectFile=project.getFile("project.pl");
					copyFolderContent2(dir,project);
					}
				}
			}
				
				
				
				return true;
		}
		else return false;
		}catch(CoreException e){}
		catch(FileNotFoundException e){}
				
		
		return false;
		
		
	}

	
	
	
	
	//estrae dallo stream in ingresso il contenuto sotto forma di stringa
	public String getContent(InputStream input)
	throws CoreException,IOException{
		int c;
		StringBuffer contentTemp=new StringBuffer("");
		
		
		InputStreamReader streamRead=new InputStreamReader(input);
		while ((c=streamRead.read())>=0)
		{
			contentTemp.append((char)c);
		}
		streamRead.close();
		return contentTemp.toString();
		
	}
	//salva il contenuto modificato del file project.pl di nel file project.pl
	public void updateProjectFile(String content)
	{
		try{

		
		StringBufferInputStream stream=new StringBufferInputStream(content);
		
		projectFile.setContents(stream,IFile.FORCE,null);
		
		
		
		}catch(CoreException e){}
	}
	
	//importa il contenuto della directory origin nel progetto project mettendo 
	//i file riconosciuti come ics,sokb e history nelle relative directory di destinazione
	private void copyFolderContent(File origin,IProject project)
	{
		try{
		projectContent=getContent(projectFile.getContents());;
		
		scanDirectory(origin,project);
		updateProjectFile(projectContent);
		
		}catch(IOException e){}
		catch(CoreException e){}
	}
	
	// come copyFolderContent ma non aggiorna project.pl (poich nel progetto d'origine non c'era)
	private void copyFolderContent2(File origin,IProject project)
	{
		try{
		projectContent=getContent(projectFile.getContents());;
		
		scanDirectory(origin,project);
		
		}catch(IOException e){}
		catch(CoreException e){}
	}
	
	//effettua il controllo di una directory di origine ne importa il contenuto
	private void scanDirectory(File dir,IContainer dest)
	throws IOException{
		try{
		File[] files=dir.listFiles();
		for(int i=0;i<files.length;i++)
		{
			if(files[i].isDirectory())
			{
				Path path=new Path(files[i].getName());
				IFolder folder=dest.getFolder(path);
				folder.create(IFolder.FORCE,true,null);
				scanDirectory(files[i],folder);
			}
			else
			{
				if(files[i].isFile())
				{
					if(files[i].getName().matches(".*ics.*"))
					{
						
						IFolder destFolder=dest.getProject().getFolder("ICS");
						Utility.copy(files[i],destFolder,"ics");
						String filePath=Utility.getRelativePath(files[i],dir);
						filePath=Project.getPathToMatch(filePath);
						if (projectContent.matches("(?sm:.*"+filePath+".*)"))
						{
							String renamedExtension=Utility.renameExtension(files[i].getName(),"ics");
							projectContent=projectContent.replaceAll(".*"+filePath+".*","ics_file('/ICS/"+renamedExtension+"').");
						}
					}else
					if(files[i].getName().matches("(?s:.*[.]ruleml.*)"))
					{
						
						
						Utility.copy(files[i],dest.getProject().getFolder("ICS"),"ruleml");
						String filePath=Utility.getRelativePath(files[i],dir);
						filePath=Project.getPathToMatch(filePath);
						if (projectContent.matches("(?sm:.*"+filePath+".*)"))
						{
							projectContent=projectContent.replaceAll(".*"+filePath+".*","ics_file('/ICS/"+files[i].getName()+"').");
						}
					}else
					if(files[i].getName().matches(".*sokb.*"))
					{
						Utility.copy(files[i],dest.getProject().getFolder("SOKB"),"sokb");
						String filePath=Utility.getRelativePath(files[i],dir);
						filePath=Project.getPathToMatch(filePath);
						if (projectContent.matches("(?sm:.*"+filePath+".*)"))
						{
							String renamedExtension=Utility.renameExtension(files[i].getName(),"sokb");
							projectContent=projectContent.replaceAll(".*"+filePath+".*","sokb_file('/SOKB/"+renamedExtension+"').");
						}
					}else
					if(files[i].getName().matches(".*history.*"))
					{
						Utility.copy(files[i],dest.getProject().getFolder("HISTORY"),"his");
						String filePath=Utility.getRelativePath(files[i],dir);
						filePath=Project.getPathToMatch(filePath);
						if (projectContent.matches("(?sm:.*"+filePath+".*)"))
						{
							String renamedExtension=Utility.renameExtension(files[i].getName(),"his");
							projectContent=projectContent.replaceAll(".*"+filePath+".*","history_file('/HISTORY/"+renamedExtension+"').");
						}
					}else
						if(!files[i].getName().equals("project.pl"))
					{
						Utility.copy(files[i],dest,"other");
						
					}
				}
			}
		}
		}catch(CoreException e)
		{
			System.out.println(e.getMessage());
		}
	}
	
	
	
	
	
	

}
