package sCIFF;

import javax.swing.text.html.parser.ParserDelegator;
import java.io.FileReader;
import java.io.FileNotFoundException;
import java.io.File;
import java.io.IOException;
import javax.swing.text.html.HTMLEditorKit.ParserCallback;

public class ProjectOption {
	
	private String name;
	private String activeValue;
	private String deactiveValue;
	private boolean isDefault=false;
	private boolean isActive=false;
	private String help;
	

	public ProjectOption(String definition) {
		String[] temp=definition.split("[,]");
		name=temp[0].trim();
		setActiveValue(temp[1].trim());
		StringBuffer buffer=new StringBuffer("");
		int c;
		String sciffPath=SCIFFPlugin.getDefault().getPreferenceStore().getString(SCIFFPlugin.sciff_path);
		File file=new File(sciffPath+"\\userman.html");
		try{
		FileReader reader=new FileReader(file);
		while ((c=reader.read())>0)
		{
			buffer.append((char)c);
		}
		reader.close();
		help=buffer.toString();
		if(help.matches("(?sm:.*[<]a name=[\"]"+name+"[\"].*)"))
		{
		help=help.substring(help.indexOf("<a name=\""+name+"\"></a>"));
		help=help.substring(help.indexOf("<p>")+3);
		help=help.substring(0,help.indexOf("<a name="));
		help=help.trim();
		temp=help.split("(?sm:[<][^>]*[>])");
		help="";
		for(int i=0;i<temp.length;i++)
		{
			help+=temp[i];
		}
		}else {
			help="";
		}
		}catch(FileNotFoundException e){}
		catch(IOException e){}
	}
	
	public boolean isDefault()
	{
		return this.isDefault;
	}
	
	public void setActive(boolean status)
	{
		isActive=status;
	}
	
	public boolean isActive()
	{
		return isActive;
	}
	
	
	
	private void setActiveValue(String def)
	{
		if (def.equals("on"))
		{
			isDefault=true;
			activeValue="on";
			deactiveValue="off";
		}
		if (def.equals("off"))
		{
			isDefault=false;
			activeValue="on";
			deactiveValue="off";
		}
		if (def.equals("yes"))
		{
			isDefault=true;
			activeValue="yes";
			deactiveValue="no";
		}
		if (def.equals("no"))
		{
			isDefault=false;
			activeValue="yes";
			deactiveValue="no";
		}
	}

	
	public String getSyntax()
	{
		return "required_option("+name+","+activeValue+").";
	}
	
	public String getDisableSyntax()
	{
		return "required_option("+name+","+deactiveValue+").";
	}
	
	public String getName()
	{
		return this.name;
	}
	
	public String getHelp()
	{
		
		return help;
	}
	

}
