package sCIFF;


import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;

import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.io.InputStream;
import java.io.StringBufferInputStream;
import java.lang.StringBuffer;
import java.io.IOException;
import java.util.Vector;



public class Project {

	

	private String content;
	private ProjectOption[] options;
	private Vector vHistory,vIcs,vSokb;
	
	private IFile projectFile;
	public IFile[] files;
	private static final String intestazione=	":- dynamic ics_file/1, sokb_file/1, history_file/1, required_option/2.\n";
	private static final String fondo=	"%%%%%%%%%%%%%%%%%%%%%%% Constant Part %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\n"+
							"build_prj(Path):-\n"+
							"\tfindall(F,ics_file(F),ICS_files), append_path(Path,ICS_files,IcsPathFiles),\n"+
							"\ttranslate_ics_files(IcsPathFiles,'./ics.pl'),\n"+
							"\tfindall(F,history_file(F),Hist_files),  append_path(Path,Hist_files,HistPathFiles),\n"+
							"\ttranslate_histories(HistPathFiles,'./history.pl'),\n"+
							"\tfindall(F,sokb_file(F),Sokb_files),     append_path(Path,Sokb_files,SokbPathFiles),\n"+
							"\tconvert_sokb(SokbPathFiles,'./sokb.pl'),\n"+
							"\tcompile(sokb), compile(history), compile(ics),\n"+
							"\tfindall([O,V],required_option(O,V),LOptions),\n"+
							"\tset_options(LOptions).\n\n"+
							"% Default:\n"+
							"run(_):- run.\n"+
							"run_open(_):- run_no_close.\n"+
							"run_closed(_):- run.";
	
	
	public Project(IFile projectFile)
	{
		this.projectFile=projectFile;
		try{
		refreshView(projectFile.getContents());
		}catch(CoreException e){}
		catch(IOException e){}
		
	}
	
	public void refreshView(InputStream input)
	throws CoreException,IOException{
		int c;
		StringBuffer contentTemp=new StringBuffer("");
		
		
		InputStreamReader streamRead=new InputStreamReader(input);
		while ((c=streamRead.read())>=0)
		{
			contentTemp.append((char)c);
		}
		streamRead.close();
		content=contentTemp.toString();
		
	}
	
	
	
	
	
	public void setOptions()
	throws FileNotFoundException{
		Options option=new Options();
		options=option.getProjectOption();
		for(int i=0;i<options.length;i++)
		{
			if((getContent().matches("(?sm:.*"+getPathToMatch2(options[i].getSyntax())+".*)"))|((options[i].isDefault())&&(!getContent().matches("(?sm:.*"+getPathToMatch2(options[i].getDisableSyntax())+".*)"))))
				options[i].setActive(true);
			else if (getContent().matches("(?sm:.*"+getPathToMatch2(options[i].getDisableSyntax())+".*)"))
				options[i].setActive(false);
		}
	}
	
	public void getFiles()
	{
		IFile[] temp1,temp2;
		
		vIcs=new Vector();
		IFolder icsFolder=projectFile.getProject().getFolder("ICS");
		getResources(icsFolder,vIcs,"ics");
		
		vHistory=new Vector();
		IFolder historyFolder=projectFile.getProject().getFolder("HISTORY");
		getResources(historyFolder,vHistory,"history");
		
		vSokb=new Vector();
		IFolder sokbFolder=projectFile.getProject().getFolder("SOKB");
		getResources(sokbFolder,vSokb,"sokb");
		
		files=new IFile[vSokb.size()+vIcs.size()+vHistory.size()];
		vSokb.copyInto(files);
		
		temp1=new IFile[vIcs.size()];
		vIcs.copyInto(temp1);
		
		temp2=new IFile[vHistory.size()];
		vHistory.copyInto(temp2);
		
		for(int i=0;i<temp1.length;i++)
		{
			files[vSokb.size()+i]=temp1[i];
		}
		
		for(int i=0;i<temp2.length;i++)
		{
			files[vSokb.size()+vIcs.size()+i]=temp2[i];
		}
		
	}
	
	public ProjectOption getOption(String name)
	{
		ProjectOption found;
		for(int i=0;i<options.length;i++)
		{
			if (options[i].getName().equals(name))
				return options[i];
		}
		return null;
	}
	
	public ProjectOption[] getOptions()
	{
		return this.options;
	}
	
	
	
		
	public boolean isPresent(IFile file)
	{
		String match=".*"+file.getProjectRelativePath().toString()+".*";
		if(content.matches("(?sm:"+match+")"))
		return true;
		else return false;
	}
	
	private static String delItem(String item,String content)
	{
		String match=getPathToMatch2(item);
		String tmp,tmp2,tmp3;
		
		String[] temp2=content.split("(?sm:\n)");
		
		for(int i=0;i<temp2.length;i++)
		{
			if(temp2[i].matches("(?s:.*"+match+".*)"))
			{
				int inizio=content.indexOf(temp2[i],1);
				int fine=inizio+temp2[i].length();
				String inizioRiga,fineRiga;
				fine++;
				tmp=content.substring(0,inizio);
				tmp3=content.substring(fine);
				inizioRiga=temp2[i].substring(0,temp2[i].indexOf(item));
				fineRiga=temp2[i].substring(temp2[i].indexOf(item)+item.length(),temp2[i].length());
				temp2[i]=inizioRiga+fineRiga;
				temp2[i]=temp2[i].trim();
				if(temp2[i].length()>0)
				{
					tmp2=temp2[i]+"\n";
				}
				else tmp2=temp2[i];
				return tmp+tmp2+tmp3;
			}
		}
		
		
		return content;
	}
	
	public static String getPathToMatch(String item)
	{
		item=item.replaceAll("\\\\","/");
		item=getPathToMatch2(item);
		return item;
	}
	
	public static String getPathToMatch2(String item)
	{
		item=item.replaceAll("[(]","[(]");
		item=item.replaceAll("[)]","[)]");
		item=item.replaceAll("[_]","[_]");
		item=item.replaceAll("[']","[']");
		item=item.replaceAll("[.]","[.]");
		item=item.replaceAll("[/]","[/]");
		item=item.replaceAll("[#]","[#]");
		item=item.replaceAll("[$]","[$]");
		item=item.replaceAll("[@]","[@]");
		item=item.replaceAll("[%]","[%]");
		item=item.replaceAll("[!]","[!]");
		item=item.replaceAll("[&]","[&]");
		item=item.replaceAll("[*]","[*]");
		item=item.replaceAll("[+]","[+]");
		item=item.replaceAll("[,]","[,]");
		item=item.replaceAll("[-]","[-]");
		item=item.replaceAll("[:]","[:]");
		item=item.replaceAll("[;]","[;]");
		item=item.replaceAll("[=]","[=]");
		item=item.replaceAll("[<]","[<]");
		item=item.replaceAll("[>]","[>]");
		item=item.replaceAll("[?]","[?]");
		item=item.replaceAll("[~]","[~]");
		return item;
	}
	
	private static String addItem(String item,String content)
	{
		String temp,temp2;
		int his=content.indexOf("history_file(",1);
		int ics=content.indexOf("ics_file(",1);
		int sokb=content.indexOf("sokb_file(",1);
		int fine=content.indexOf("build_prj(Path)",1);
		
		int min=Math.min(his,ics);
		min=Math.min(min,sokb);
		
		if((min==-1)|(fine<min))
		{
			String[] arrayTemp=splitIntestazione(content);
			temp=arrayTemp[0];
			temp2=arrayTemp[1];
		}else{
		temp=content.substring(0,min);
		temp2=content.substring(min,content.length());
		}
		content=temp+item+"\n"+temp2;
		return content;
	}
	
	public String deleteFile(IFile file,String content)
	{
		String path=file.getFullPath().toString();
		if (path.matches(".*ICS.*"))
		return	delItem("ics_file[(']"+path+"[').]",content);
		
		if (path.matches(".*HISTORY.*"))
		return	delItem("history_file[(']"+path+"[').]",content);
		
		if (path.matches(".*SOKB.*"))
		return	delItem("sokb_file[(']"+path+"[').]",content);
		
		return null;
		
	}
	
	public static String deleteFile(String path,String content,String type)
	{
		String result;
				
		if (type.equals("ics"))
		{
		result=delItem("ics_file('/"+path+"').",content);
		return result;
		}
		else if (type.equals("history"))
		{
		result=delItem("history_file('/"+path+"').",content);
		return result;
		}
		else if (type.equals("sokb"))
		{
		result=delItem("sokb_file('/"+path+"').",content);
		return result;
		}
		else return null;
		
	}
	
	public String deleteOption(String name,String content)
	{
		ProjectOption option=getOption(name);
		if (option.isDefault())
			return addItem(option.getDisableSyntax(),content);
		else
		return delItem(option.getSyntax(),content);
	}
	
	public String addFile(IFile file,String content)
	{
		String path=file.getFullPath().toString();
		if (path.matches(".*ICS.*"))
		return	addItem("ics_file('"+path+"').",content);
		
		if (path.matches(".*HISTORY.*"))
		return	addItem("history_file('"+path+"').",content);
		
		if (path.matches(".*SOKB.*"))
		return	addItem("sokb_file('"+path+"').",content);
		
		return null;
	}
	
	public static String addFile(String path,String content,String type)
	{
		String result;
		if (type.equals("ics"))
		{
			if(path.matches(".*[/].*"))
				result=addItem("ics_file('/"+path+"').",content);
			else
				result=addItem("ics_file('"+path+"').",content);
		return	result;
		}
		
		
		
		if (type.equals("history"))
		{
			if(path.matches(".*[/].*"))
				result=addItem("history_file('/"+path+"').",content);
			else
				result=addItem("history_file('"+path+"').",content);
		return	result;
		}
		
		if (type.equals("sokb"))
		{
			if(path.matches(".*[/].*"))
				result=addItem("sokb_file('/"+path+"').",content);
			else
				result=addItem("sokb_file('"+path+"').",content);
		return	result;
		}
		
		return null;
	}
	
	public String addOption(String name,String content)
	{
		ProjectOption option=getOption(name);
		if (option.isDefault())
			return delItem(option.getDisableSyntax(),content);
		else
		return addItem(option.getSyntax(),content);
	}
	
	public String getIntestazione()
	{
		return intestazione;
	}
	
	public String getFondo()
	{
		return fondo;
	}
	
	public void save(String content)
	throws CoreException{
		StringBufferInputStream inputStream=new StringBufferInputStream(content);
		projectFile.setContents(inputStream,true,true,null);
		
	}
	
	public boolean isSelectedOption (String option)
	{
		return getOption(option).isActive();
	}
	
	public void setContent(String content)
	{
		this.content=content;
	}
	
	private void getResources(IFolder folder,Vector files,String type)
	{
		try{
		IResource[] resources=folder.members();
		
		
		for(int i=0;i<resources.length;i++)
		{
			if (resources[i].getType()==IResource.FOLDER )
			{
				getResources((IFolder)resources[i],files,type);
				
			}else 
			if (resources[i].getType()==IResource.FILE)
			{
				if (isPresent(((IFile)resources[i])))
				files.add((IFile)resources[i]);
			}
			
		}
		}catch(CoreException e){return;}
	}
	
	public String getContent()
	{
		return this.content;
	}
	
	public static String[] splitIntestazione(String content)
	{
		boolean found=false;
		String[] finalContent=new String[2];
		int index=content.indexOf(".",1);
		for(int i=index;i<(content.length()-index);i++)
		{
			if((content.charAt(i)=='\n')&&(found==true))
			{
				index=i+1;
				break;
			}
			
			if((content.charAt(i)=='\n')&&(found==false))
			{
				found=true;
			}
			
		}
		finalContent[0]=content.substring(0,index);
		finalContent[1]=content.substring(index);
		
		return finalContent;
	}
	
	public static String[] splitFondo(String content)
	{
		content=Utility.uncomment(content);
		int index=content.indexOf("build_prj(Path)");
		String[] result=new String[2];
		result[0]=content.substring(0,index);
		result[1]=content.substring(index);
		return result;
	}
	
	
	
	public static String getExtensionString(String path)
	{
		String temp=path.substring(path.lastIndexOf(".")+1);
		return temp;
	}
	
	public String[] getIcs()
	{
		String[] tmp1=Project.splitIntestazione(content);
		tmp1=Project.splitFondo(tmp1[1]);
		String temp=tmp1[0];
		
		Vector vResult=new Vector();
		String[] result;
		
		IProject project=projectFile.getProject();
		String[] files=temp.split("(?sm:(history[_]file[(]['][^(['][)][.])]*['][)][.])|(sokb[_]file[(]['][^(['][)][.])]*['][)][.])|(required[_]option[(][^([)][.])]*[)][.]))");
		for(int i=0;i<files.length;i++)
		{
			if(files[i].matches("(?s:.*ics[_]file.*)"))
			{
				String[] tmp2=files[i].split("(?sm:['][)][.])");
				for(int l=0;l<tmp2.length;l++)
				{
					if(tmp2[l].matches("(?s:.*ics[_]file.*)"))
					{
					tmp2[l]=tmp2[l].substring(tmp2[l].indexOf("ics_file('"));
					tmp2[l]=tmp2[l].replaceFirst("ics[_]file[(][']","");
					tmp2[l]=tmp2[l].trim();
					vResult.add(tmp2[l]);
					}
				}
			}
		}
		result=new String[vResult.size()];
		vResult.copyInto(result);
		return result;
	}
	
	public String[] getSokb()
	{
		String[] tmp1=Project.splitIntestazione(content);
		tmp1=Project.splitFondo(tmp1[1]);
		String temp=tmp1[0];
		
		Vector vResult=new Vector();
		String[] result;
		
		IProject project=projectFile.getProject();
		String[] files=temp.split("(?sm:(history[_]file[(]['][^(['][)][.])]*['][)][.])|(ics[_]file[(]['][^(['][)][.])]*['][)][.])|(required[_]option[(][^([)][.])]*[)][.]))");
		for(int i=0;i<files.length;i++)
		{
			if(files[i].matches("(?s:.*sokb[_]file.*)"))
			{
				String[] tmp2=files[i].split("(?sm:['][)][.])");
				for(int l=0;l<tmp2.length;l++)
				{
					if(tmp2[l].matches("(?s:.*sokb[_]file.*)"))
					{
					tmp2[l]=tmp2[l].substring(tmp2[l].indexOf("sokb_file('"));
					tmp2[l]=tmp2[l].replaceFirst("sokb[_]file[(][']","");
					tmp2[l]=tmp2[l].trim();
					vResult.add(tmp2[l]);
					}
				}
			}
		}
		result=new String[vResult.size()];
		vResult.copyInto(result);
		return result;
	}
	
	public String[] getHistory()
	{
		String[] tmp1=Project.splitIntestazione(content);
		tmp1=Project.splitFondo(tmp1[1]);
		String temp=tmp1[0];
		
		Vector vResult=new Vector();
		String[] result;
		
		IProject project=projectFile.getProject();
		String[] files=temp.split("(?sm:(sokb[_]file[(]['][^(['][)][.])]*['][)][.])|(ics[_]file[(]['][^(['][)][.])]*['][)][.])|(required[_]option[(][^([)][.])]*[)][.]))");
		for(int i=0;i<files.length;i++)
		{
			if(files[i].matches("(?s:.*history[_]file.*)"))
			{
				String[] tmp2=files[i].split("(?sm:['][)][.])");
				for(int l=0;l<tmp2.length;l++)
				{
					if(tmp2[l].matches("(?s:.*history[_]file.*)"))
					{
					tmp2[l]=tmp2[l].substring(tmp2[l].indexOf("history_file('"));
					tmp2[l]=tmp2[l].replaceFirst("history[_]file[(][']","");
					tmp2[l]=tmp2[l].trim();
					vResult.add(tmp2[l]);
					}
				}
			}
		}
		result=new String[vResult.size()];
		vResult.copyInto(result);
		return result;
	}
	

}
