package sCIFF;

import java.io.File;
import java.io.FileNotFoundException;

public class Options {
	
	private String sciffPath;
	private File optionsFile;
	private String optionsFileContent;
	private ProjectOption[] options;
	

	public Options() throws FileNotFoundException{
		super();
		sciffPath=SCIFFPlugin.getDefault().getPreferenceStore().getString(SCIFFPlugin.sciff_path);
		optionsFile=new File(sciffPath+"\\sciff_options.pl");
		optionsFileContent=Utility.getFileContent(optionsFile);
		options=setOptions(optionsFileContent);
		
	}
	
	public ProjectOption[] getProjectOption()
	{
		return options;
	}
	
	//inizializza l'array di oggetti ProjectOption
	private ProjectOption[] setOptions(String content)
	{
		ProjectOption[] options;
		String[] optionsString;
		
		optionsString=getOptionsString(content);
		options=new ProjectOption[optionsString.length];
		for(int i=0;i<options.length;i++)
		{
			options[i]=new ProjectOption(optionsString[i]);
		}
		return options;
	}
	
	//ritorna i parametri all'interno dei fatti prolog "sciff_option (definiscono le opzioni settabili  nel project.pl)"
	private String[] getOptionsString(String content)
	{
		content=Utility.uncomment(content);
		content=Utility.getFact(content);
		String[] predicates=Utility.getPredicates("sciff_option",content);
		for(int i=0;i<predicates.length;i++)
		{
			predicates[i]=predicates[i].substring(predicates[i].indexOf("(")+1,predicates[i].lastIndexOf(")"));
		}
		return predicates;
	}

}
