package sCIFF;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IFile;
import java.io.StringBufferInputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.part.FileEditorInput;

public class NewSokb extends Wizard implements INewWizard {
	private IStructuredSelection selection;
	private NewSokbPage Main;
	private IWorkbench workbench;

	public NewSokb() {
		super();
		// TODO Auto-generated constructor stub
	}

	public boolean performFinish() {
		IProject project=ResourcesPlugin.getWorkspace().getRoot().getProject(Main.projectName);
		IFile sokbFile=project.getFolder("SOKB").getFile(Main.fileName+".sokb");
		try{
		sokbFile.create(new StringBufferInputStream(""),true,null);
		
		Project projectFile=new Project(project.getFile("project.pl"));
		projectFile.setContent(Project.addFile(sokbFile.getProjectRelativePath().toString(),projectFile.getContent(),"sokb"));
		projectFile.save(projectFile.getContent());
		
		String editorId=workbench.getEditorRegistry().getDefaultEditor(sokbFile.getName()).getId();
		
		workbench.getActiveWorkbenchWindow().getActivePage().openEditor(new FileEditorInput(sokbFile),editorId);
		
		return true;
		}catch(CoreException e){Utility.showError("Error creating file.",false);
		return false;}
	}

	public void init(IWorkbench workbench, IStructuredSelection selection) {
		this.selection=selection;
		this.workbench=workbench;
		setWindowTitle("New Sokb file");
	}
	
	public void addPages() 

	{
		Main=new NewSokbPage("Sokb file creation",selection);
		addPage(Main);
		
	}

}
