package sCIFF;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class NewProjectPage extends WizardPage {

	private Text containerNameField;
	public String projectName;

	public NewProjectPage(String pageName,IStructuredSelection selection) {
		super(pageName);
	}

	public NewProjectPage(String pageName, String title, ImageDescriptor titleImage) {
		super(pageName, title, titleImage);
	}

	public void createControl(Composite parent) {
		Composite composite = new Composite(parent, SWT.NULL);
		setControl(composite);
        composite.setFont(parent.getFont());
        composite.setLayout(new GridLayout());
        composite.setLayoutData(new GridData(GridData.FILL_BOTH));
		
        Composite containerGroup = new Composite(composite, SWT.NONE);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        containerGroup.setLayout(layout);
        containerGroup.setLayoutData(new GridData(
                GridData.HORIZONTAL_ALIGN_FILL | GridData.GRAB_HORIZONTAL));
        containerGroup.setFont(parent.getFont());
        
        Label resourcesLabel = new Label(containerGroup, SWT.NONE);
        resourcesLabel.setText("Project name:");
        resourcesLabel.setFont(parent.getFont());
        resourcesLabel.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_BEGINNING,GridData.VERTICAL_ALIGN_CENTER,false,false,2,1));

        // container name entry field
        containerNameField = new Text(containerGroup, SWT.SINGLE | SWT.BORDER);
        GridData data = new GridData(GridData.HORIZONTAL_ALIGN_FILL
                | GridData.GRAB_HORIZONTAL);
        data.widthHint = 250;
        containerNameField.setLayoutData(data);
        containerNameField.setFont(parent.getFont());
        containerNameField.addModifyListener(new ModifyListener(){
        	public void modifyText(ModifyEvent e)
        	{
        		projectName=containerNameField.getText();
        		setPageComplete(true);
        	}
        });

        

	}
	
	public boolean createSCIFFProject()
    {
		return CleanSCIFFproject.Create(projectName);
    }

}
