package sCIFF;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.core.runtime.CoreException;

public class NewIcsPage extends WizardPage {
	
	private IStructuredSelection selection;
	private Combo projectCombo;
	private Text containerNameField;
	public String projectName;
	public String fileName;

	public NewIcsPage(String pageName,IStructuredSelection selection) {
		super(pageName);
		this.selection=selection;
	}

	public NewIcsPage(String pageName, String title, ImageDescriptor titleImage) {
		super(pageName, title, titleImage);
	}

	public void createControl(Composite parent) {
		Composite composite = new Composite(parent, SWT.NULL);
		setControl(composite);
        composite.setFont(parent.getFont());
        composite.setLayout(new GridLayout());
        composite.setLayoutData(new GridData(GridData.FILL_BOTH));
		
        Composite containerGroup = new Composite(composite, SWT.NONE);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        containerGroup.setLayout(layout);
        containerGroup.setLayoutData(new GridData(
                GridData.HORIZONTAL_ALIGN_FILL | GridData.GRAB_HORIZONTAL));
        containerGroup.setFont(parent.getFont());
        
        Label resourcesLabel = new Label(containerGroup, SWT.NONE);
        resourcesLabel.setText("Name file .ics:");
        resourcesLabel.setFont(parent.getFont());
        resourcesLabel.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_BEGINNING,GridData.VERTICAL_ALIGN_CENTER,false,false,2,1));

        // container name entry field
        containerNameField = new Text(containerGroup, SWT.SINGLE | SWT.BORDER);
        GridData data = new GridData(GridData.HORIZONTAL_ALIGN_FILL
                | GridData.GRAB_HORIZONTAL);
        data.widthHint = 250;
        containerNameField.setLayoutData(data);
        containerNameField.setFont(parent.getFont());
        containerNameField.addModifyListener(new ModifyListener(){
        	public void modifyText(ModifyEvent e)
        	{
        		fileName=containerNameField.getText();
        		setPageComplete(true);
        	}
        });

        // container label
        Label projectLabel = new Label(containerGroup, SWT.NONE);
        projectLabel.setText("Destination project:");
        projectLabel.setFont(parent.getFont());
        projectLabel.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_BEGINNING,GridData.VERTICAL_ALIGN_CENTER,false,false,2,1));
        
//      container name entry field
        projectCombo=new Combo(containerGroup,SWT.DROP_DOWN); 
        IWorkspaceRoot workRoot=ResourcesPlugin.getWorkspace().getRoot();
        
        try{
        IProject[] projects=Utility.getSciffNature(workRoot);
        for(int i=0;i<projects.length;i++)
        {
        	projectCombo.add(projects[i].getName());
//        	Object selObj=selection.getFirstElement();
//        	if((!selection.isEmpty())&&(selObj instanceof IResource))
//        		if (((IResource)selObj).getProject().getName().equals(projects[i].getName()))
//        		{
//        			projectCombo.select(projectCombo.indexOf(projects[i].getName()));
//        			projectName=projects[i].getName();
//        		}
        }
        }catch(CoreException e){}
        
        projectCombo.addModifyListener(new ModifyListener(){
        	public void modifyText(ModifyEvent e)
        	{
        		if (e.widget instanceof Combo)
        		{
        			Combo project=(Combo)e.widget;
        			projectName=project.getItem(project.getSelectionIndex());
        			if (project.getSelectionIndex()==-1)
        				setPageComplete(false);
        		}
        	}
        });

	}
	

}