package sCIFF;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import org.eclipse.core.runtime.CoreException;


public class FileImportPage extends WizardPage {
	private IStructuredSelection selection;
	private Text containerNameField;
	private Button containerBrowseButton;
	private String customLocationFieldValue;
	private IProject project;
	private static final int SIZING_TEXT_FIELD_WIDTH = 250;
	private Combo projectCombo;
	private String projectName;
	private Button radioGeneric,radioIcs,radioSokb,radioHis,radioRuleml;
	private String radioStatus="Generic";

	public FileImportPage(String pageName,IStructuredSelection selection) {
		super(pageName);
		this.selection=selection;
		setPageComplete(false);
        customLocationFieldValue = "";
	}

	public FileImportPage(String pageName, String title,
			ImageDescriptor titleImage) {
		super(pageName, title, titleImage);
	}

	public void createControl(Composite parent) {
		Composite composite = new Composite(parent, SWT.NULL);
		setControl(composite);
        composite.setFont(parent.getFont());
        composite.setLayout(new GridLayout());
        composite.setLayoutData(new GridData(GridData.FILL_BOTH));
		
        Composite containerGroup = new Composite(composite, SWT.NONE);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        containerGroup.setLayout(layout);
        containerGroup.setLayoutData(new GridData(
                GridData.HORIZONTAL_ALIGN_FILL | GridData.GRAB_HORIZONTAL));
        containerGroup.setFont(parent.getFont());

        // container label
        Label projectLabel = new Label(containerGroup, SWT.NONE);
        projectLabel.setText("Destination project:");
        projectLabel.setFont(parent.getFont());
        projectLabel.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_BEGINNING,GridData.VERTICAL_ALIGN_CENTER,false,false,3,1));

        // container name entry field
        projectCombo=new Combo(containerGroup,SWT.DROP_DOWN); 
        projectCombo.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_BEGINNING,GridData.VERTICAL_ALIGN_CENTER,false,false,3,1));
        IWorkspaceRoot workRoot=ResourcesPlugin.getWorkspace().getRoot();
        try{
        IProject[] projects=Utility.getSciffNature(workRoot);
        
        for(int i=0;i<projects.length;i++)
        {
        	projectCombo.add(projects[i].getName());
        }
        }catch(CoreException e){}
        Object objTemp;
        if ((objTemp=selection.getFirstElement()) instanceof IResource)
        {
        	String tempName=((IResource)objTemp).getProject().getName();
        	String[] tempProjects=projectCombo.getItems();
        	for(int i=0;i<tempProjects.length;i++)
        	{
        		if (tempProjects[i].equals(tempName))
        			projectCombo.select(projectCombo.indexOf(tempProjects[i]));
        	}
        }
        
        projectCombo.addModifyListener(new ModifyListener(){
        	public void modifyText(ModifyEvent e)
        	{
        		if (e.widget instanceof Combo)
        		{
        			Combo project=(Combo)e.widget;
        			projectName=project.getItem(project.getSelectionIndex());
        			if (project.getSelectionIndex()==-1)
        				setPageComplete(false);
        		}
        	}
        });
        
        
//      container label
        Label resourcesLabel = new Label(containerGroup, SWT.NONE);
        resourcesLabel.setText("Source file:");
        resourcesLabel.setFont(parent.getFont());
        resourcesLabel.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_BEGINNING,GridData.VERTICAL_ALIGN_CENTER,false,false,3,1));

        // container name entry field
        containerNameField = new Text(containerGroup, SWT.SINGLE | SWT.BORDER);
        GridData data = new GridData(GridData.HORIZONTAL_ALIGN_FILL
                | GridData.GRAB_HORIZONTAL);
        data.widthHint = SIZING_TEXT_FIELD_WIDTH;
        containerNameField.setLayoutData(data);
        containerNameField.setFont(parent.getFont());
        containerNameField.addModifyListener(new ModifyListener(){
        	public void modifyText(ModifyEvent e)
        	{
        		customLocationFieldValue=containerNameField.getText();
        		setPageComplete(true);
        	}
        });
        // container browse button
        containerBrowseButton = new Button(containerGroup, SWT.PUSH);
        containerBrowseButton.setText("Browse...");
        containerBrowseButton.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_BEGINNING,GridData.VERTICAL_ALIGN_CENTER,false,false,1,3));
        containerBrowseButton.setFont(parent.getFont());
        setButtonLayoutData(containerBrowseButton);
        containerBrowseButton.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent event) {
                FileDialog dialog=new FileDialog(containerNameField.getShell());                            
                String selectedDirectory = dialog.open();
                if (selectedDirectory != null) {
                    containerNameField.setText(selectedDirectory);
                }
            }
        });
        
        
        
        
        
        
        Label radioLabel=new Label(containerGroup,SWT.NULL);
        radioLabel.setText("Import file as:");
        radioLabel.setFont(parent.getFont());
        radioLabel.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_BEGINNING,GridData.VERTICAL_ALIGN_CENTER,false,false,3,1));
        
        Composite radioGroup=new Composite(containerGroup,SWT.NULL);
        radioGroup.setLayout(layout);
        radioGroup.setLayoutData(new GridData(
                GridData.HORIZONTAL_ALIGN_FILL | GridData.GRAB_HORIZONTAL));
        radioGroup.setFont(parent.getFont());
        
        radioGeneric=new Button(radioGroup,SWT.RADIO);
        radioGeneric.setFont(parent.getFont());
        radioGeneric.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_BEGINNING,GridData.VERTICAL_ALIGN_CENTER,false,false,2,1));
        radioGeneric.setText("Generic");
        radioGeneric.setSelection(true);
        radioGeneric.addSelectionListener(new SelectionAdapter(){
        	public void widgetSelected(SelectionEvent e) 
        	{
        		radioStatus="Generic";
        	}
        });
        
        
        
        radioIcs=new Button(radioGroup,SWT.RADIO);
        radioIcs.setFont(parent.getFont());
        radioIcs.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_BEGINNING,GridData.VERTICAL_ALIGN_CENTER,false,false,2,1));
        radioIcs.setText("Ics");
        radioIcs.addSelectionListener(new SelectionAdapter(){
        	public void widgetSelected(SelectionEvent e) 
        	{
        		radioStatus="Ics";
        	}
        });
        
        radioRuleml=new Button(radioGroup,SWT.RADIO);
        radioRuleml.setFont(parent.getFont());
        radioRuleml.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_BEGINNING,GridData.VERTICAL_ALIGN_CENTER,false,false,2,1));
        radioRuleml.setText(".ruleml");
        radioRuleml.addSelectionListener(new SelectionAdapter(){
        	public void widgetSelected(SelectionEvent e) 
        	{
        		radioStatus="Ruleml";
        	}
        });
        
        radioSokb=new Button(radioGroup,SWT.RADIO);
        radioSokb.setFont(parent.getFont());
        radioSokb.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_BEGINNING,GridData.VERTICAL_ALIGN_CENTER,false,false,2,1));
        radioSokb.setText("Sokb");
        radioSokb.addSelectionListener(new SelectionAdapter(){
        	public void widgetSelected(SelectionEvent e) 
        	{
        		radioStatus="Sokb";
        	}
        });
        
        radioHis=new Button(radioGroup,SWT.RADIO);
        radioHis.setFont(parent.getFont());
        radioHis.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_BEGINNING,GridData.VERTICAL_ALIGN_CENTER,false,false,2,1));
        radioHis.setText("History");
        radioHis.addSelectionListener(new SelectionAdapter(){
        	public void widgetSelected(SelectionEvent e) 
        	{
        		radioStatus="History";
        	}
        });
        
        setControl(composite);
	}
	
	public boolean importFile()
	{
		String project=projectCombo.getItem(projectCombo.getSelectionIndex());
		this.project=ResourcesPlugin.getWorkspace().getRoot().getProject(project);
		File file=new File(containerNameField.getText());
		try{
		FileInputStream fileStream=new FileInputStream(file);
		
		if(radioStatus.equals("Generic"))
		{
		IFile fileOut=this.project.getFile(file.getName());
		fileOut.create(fileStream,true,null);
		return true;
		}
		if(radioStatus.equals("Ics"))
		{
		IFolder dir=this.project.getFolder("ICS");
		if (dir.exists())
		{
		String newName=Utility.renameExtension(file.getName(),"ics");
		IFile fileOut=dir.getFile(newName);
		fileOut.create(fileStream,true,null);
		return true;
		}
		else return false;
		}
		
		if(radioStatus.equals("Ruleml"))
		{
		IFolder dir=this.project.getFolder("ICS");
		if (dir.exists())
		{
		IFile fileOut=dir.getFile(Utility.renameExtension(file.getName(),"ruleml"));
		fileOut.create(fileStream,true,null);
		return true;
		}
		else return false;
		}
		
		if(radioStatus.equals("Sokb"))
		{
		IFolder dir=this.project.getFolder("SOKB");
		if (dir.exists())
		{
		IFile fileOut=dir.getFile(Utility.renameExtension(file.getName(),"sokb"));
		fileOut.create(fileStream,true,null);
		return true;
		}
		else return false;
		}
		
		if(radioStatus.equals("History"))
		{
		IFolder dir=this.project.getFolder("HISTORY");
		if (dir.exists())
		{
		IFile fileOut=dir.getFile(Utility.renameExtension(file.getName(),"his"));
		fileOut.create(fileStream,true,null);
		return true;
		}
		else return false;
		}
		
		return false;
		
		}catch(FileNotFoundException e){return false;}
		catch(CoreException e){return false;}
		
	}

}
