package sCIFF;

import java.io.File;
import java.io.IOException;
import java.io.BufferedInputStream;
import java.io.LineNumberReader;
import java.io.InputStreamReader;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.core.runtime.IProgressMonitor;
import java.lang.InterruptedException;
import java.lang.reflect.InvocationTargetException;

public class ExportRulemlPage extends WizardPage {
	
	private Text containerNameField;
	private Text fileNameField;
	private Button containerBrowseButton;
	private String customLocationFieldValue=null;
	private String fileNameFieldValue=null;
	private String projectNameValue=null;
	private static final int SIZING_TEXT_FIELD_WIDTH = 250;
	private IWorkspaceRoot workRoot;
	private File dir;
	private Combo projectCombo;

	public ExportRulemlPage(String pageName) {
		super(pageName);
		// TODO Auto-generated constructor stub
	}

	public ExportRulemlPage(String pageName, String title,
			ImageDescriptor titleImage) {
		super(pageName, title, titleImage);
		// TODO Auto-generated constructor stub
	}

	public void createControl(Composite parent) {
		setPageComplete(false);
		Composite composite = new Composite(parent, SWT.NULL);
        composite.setFont(parent.getFont());
        composite.setLayout(new GridLayout());
        composite.setLayoutData(new GridData(GridData.FILL_BOTH));
		
        Composite containerGroup = new Composite(composite, SWT.NONE);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        containerGroup.setLayout(layout);
        containerGroup.setLayoutData(new GridData(
                GridData.HORIZONTAL_ALIGN_FILL | GridData.GRAB_HORIZONTAL));
        containerGroup.setFont(parent.getFont());
        
        Label projectLabel=new Label(containerGroup,SWT.NULL);
        GridData data = new GridData(GridData.HORIZONTAL_ALIGN_FILL
                | GridData.GRAB_HORIZONTAL);
        data.widthHint = SIZING_TEXT_FIELD_WIDTH;
		projectLabel.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL | GridData.GRAB_HORIZONTAL,SWT.CENTER,false,false,1,1));
		projectLabel.setText("Select a project:");
		
		projectCombo=new Combo(containerGroup,SWT.DROP_DOWN); 
	    
	    projectCombo.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL | GridData.GRAB_HORIZONTAL,SWT.CENTER,false,false,1,1));
	    
	    workRoot=ResourcesPlugin.getWorkspace().getRoot();
	    
	    try{
	    IProject[] projects=Utility.getSciffNature(workRoot);
	        
	    for(int i=0;i<projects.length;i++)
	    {
	    	projectCombo.add(projects[i].getName());
	    }
	    }catch(CoreException e){Utility.showError("Error during project nature reading.",true);}
	    
	    projectCombo.addModifyListener(new ModifyListener(){
	    	public void modifyText(ModifyEvent e)
	    	{
	    		if (e.widget instanceof Combo)
	    		{
	    			Combo projectCombo=(Combo)e.widget;
	    			projectNameValue=projectCombo.getItem(projectCombo.getSelectionIndex());
	    			if(((projectNameValue!=null)|(projectNameValue!=""))&&(validateDirectory(customLocationFieldValue))&&(fileNameFieldValue!=null) )
	    			{
	    				setPageComplete(true);
	    			}
	            	else setPageComplete(false);
	    			
	    			
	    		}
	    	}
	    });
        
        
        
        
        // container label
        Label fileLabel = new Label(containerGroup, SWT.NONE);
        fileLabel.setText("Select file name:");
        fileLabel.setFont(parent.getFont());

        // container name entry field
        fileNameField = new Text(containerGroup, SWT.SINGLE | SWT.BORDER);
        fileNameField.setLayoutData(data);
        fileNameField.setFont(parent.getFont());
        fileNameField.addModifyListener(new ModifyListener(){
        	public void modifyText(ModifyEvent e)
        	{
        		fileNameFieldValue=fileNameField.getText();
        		if (validateDirectory(customLocationFieldValue)&&(projectNameValue!=null))
        			setPageComplete(true);
        		else setPageComplete(false);
        	}
        });
        
        
        Composite compositeFolder = new Composite(composite, SWT.NULL);
        compositeFolder.setFont(parent.getFont());
        compositeFolder.setLayout(new GridLayout(3,false));
        compositeFolder.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL | GridData.GRAB_HORIZONTAL,SWT.CENTER,true,false,2,1)); 
               
        
        // container label
        Label resourcesLabel = new Label(compositeFolder, SWT.NONE);
        resourcesLabel.setText("Select destination folder:");
        resourcesLabel.setFont(parent.getFont());
        resourcesLabel.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL | GridData.GRAB_HORIZONTAL,SWT.CENTER,true,false,1,1));
        // container name entry field
        containerNameField = new Text(compositeFolder, SWT.SINGLE | SWT.BORDER);
        containerNameField.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL | GridData.GRAB_HORIZONTAL,SWT.CENTER,true,false,1,1));
        containerNameField.setFont(parent.getFont());
        containerNameField.addModifyListener(new ModifyListener(){
        	public void modifyText(ModifyEvent e)
        	{
        		customLocationFieldValue=containerNameField.getText();
        		if (validateDirectory(customLocationFieldValue)&&(fileNameFieldValue!=null)&&(projectNameValue!=null))
        			setPageComplete(true);
        		else setPageComplete(false);
        	}
        });
        // container browse button
        containerBrowseButton = new Button(compositeFolder, SWT.PUSH);
        containerBrowseButton.setText("Browse...");
        containerBrowseButton.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_FILL | GridData.GRAB_HORIZONTAL,SWT.CENTER,true,false,1,1));
        containerBrowseButton.setFont(parent.getFont());
        setButtonLayoutData(containerBrowseButton);
        containerBrowseButton.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent event) {
                DirectoryDialog dialog=new DirectoryDialog(containerNameField.getShell());
                dialog.setMessage("Seleziona directory origine:");                             
                String selectedDirectory = dialog.open();
                if (selectedDirectory != null) {
                    containerNameField.setText(selectedDirectory);
                }
            }
        });
        
        setControl(composite);

	}
	
	public boolean validateDirectory(String directory)
	{
		dir=new File(directory);
		if (dir.isDirectory())
		return true;
		else return false;
	}
	
	public boolean exportToRuleml()
	{
		try{
		getWizard().getContainer().run(false,false,new IRunnableWithProgress()
		{
			public void run(IProgressMonitor monitor)
			{
			try{
			String prova="";
			String sicstusPath=SCIFFPlugin.getDefault().getPreferenceStore().getString(SCIFFPlugin.sicstus_path);
			String sciffPath=SCIFFPlugin.getDefault().getPreferenceStore().getString(SCIFFPlugin.sciff_path);
			sciffPath=sciffPath.replaceAll("\\\\","/");
			sciffPath=sciffPath.toLowerCase();
			String destPath=customLocationFieldValue.replaceAll("\\\\","/");
			destPath=destPath.toLowerCase();
			File sicstusDir=new File(sicstusPath);
			sicstusDir=sicstusDir.getParentFile();
			sicstusPath=sicstusDir.getPath();
			String sicstusMatch=sicstusPath.replaceAll("\\\\","/");
			sicstusMatch=sicstusMatch.toLowerCase();
			
			String[] cmdLine={sicstusPath+"\\sicstus.exe","--goal","['"+sciffPath+"/sciff.pl'],project("+projectNameValue+"),ruleml_parser:save_ics_ruleml('"+destPath+"/"+fileNameFieldValue+".ruleml'). "};
			
			monitor.beginTask("SCIFF export",20);
			Process p=Runtime.getRuntime().exec(cmdLine,null,sicstusDir);
			LineNumberReader stream=new LineNumberReader(new InputStreamReader(new BufferedInputStream(p.getErrorStream())));
			
			
			while (!prova.matches("(?s).*consulted "+sicstusMatch+"/ics.pl in module ics.*"))
			{
				
				prova=stream.readLine();
				if (prova.matches("(?s:.*consulted "+sciffPath+"/sciff.pl in module user.*)"))
					{
					monitor.worked(10);
					}
				System.out.println(prova);
				if(prova.startsWith("!")||prova.matches(".*goal failed.*"))
				{
					Utility.showError("Project exporting failed!",false);
					break;
				}
				
			}
			monitor.done();
			stream.close();
			p.destroy();
			}catch(IOException e){}
			}
		});
		}catch(InvocationTargetException e){}
		catch(InterruptedException e){}
		return true;
	}

}
