package sCIFF.EDITOR;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WordRule;

public class SingleWordRule extends WordRule {
	
	private StringBuffer fBuffer= new StringBuffer();


	public SingleWordRule(IWordDetector detector) {
		super(detector);
	}

	public SingleWordRule(IWordDetector detector, IToken defaultToken) {
		super(detector, defaultToken);
		// TODO Auto-generated constructor stub
	}
	
	public IToken evaluate(ICharacterScanner scanner) {
		
		int c= scanner.read();
		if (fDetector.isWordStart((char) c)) 
		{
		
				fBuffer.setLength(0);
				do {
					fBuffer.append((char) c);
					c= scanner.read();
				} while (c != ICharacterScanner.EOF && fDetector.isWordPart((char) c));
				scanner.unread();

				IToken token= (IToken) fWords.get(fBuffer.toString());
				if (token != null)
				{
					
					return token;
									
				}
				else
				{
				unreadBuffer(scanner);
				int length=fBuffer.length();
				fBuffer.setLength(0);
				for(int i=0;i<length-1;i++)
				{
					c=scanner.read();
					fBuffer.append((char) c);
				}
				token= (IToken) fWords.get(fBuffer.toString());
				if (token!=null)
					{
					return Token.UNDEFINED;
					}
				else
				{
				scanner.read();
				return Token.UNDEFINED;
				}
				}
			}
		scanner.unread();
		return Token.UNDEFINED;
	}
	
	protected void unreadBuffer(ICharacterScanner scanner) {
		for (int i= fBuffer.length() - 1; i >= 0; i--)
			scanner.unread();
	}

}
