package sCIFF.EDITOR;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.SWT;

public class ProjectEditorConfiguration extends SourceViewerConfiguration {

	private ColorManager colorManager;
	private IToken token,commentPartition;


	public ProjectEditorConfiguration(ColorManager colorManager) {
		super();
		this.colorManager=colorManager;
	}
	
	public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer)
	{
		PresentationReconciler reconciler=new PresentationReconciler();
		
		DefaultDamagerRepairer dr=new DefaultDamagerRepairer(getCommentScanner());
		reconciler.setDamager(dr,DocumentSetupParticipant.COMMENT );
		reconciler.setRepairer(dr,DocumentSetupParticipant.COMMENT);
		
		dr=new DefaultDamagerRepairer(getScanner());
		reconciler.setDamager(dr,IDocument.DEFAULT_CONTENT_TYPE);
		reconciler.setRepairer(dr,IDocument.DEFAULT_CONTENT_TYPE);
		
		
		
		
		return reconciler;
	}
	
	private ITokenScanner getScanner()
	{
		IRule[] rules=null;
		RuleBasedScanner scanner=new RuleBasedScanner();
		token=new Token(new TextAttribute(colorManager.getColor(IColorConstants.CLAUSE),null,SWT.BOLD));
		commentPartition=new Token(new TextAttribute(colorManager.getColor(IColorConstants.ICS_COMMENT),null,SWT.ITALIC));
		
		SingleLineRule commentRule=new SingleLineRule("%",null,commentPartition,((char) 0),true);
		
		
		
		SingleWordRule wordRule=new SingleWordRule(new SimpleWordDetector());
		
		
			wordRule=getSokbRules(wordRule);
		
		
		rules=new IRule[]{commentRule,wordRule};
			if (rules!=null)
			scanner.setRules(rules);
		return scanner;
	}
	private ITokenScanner getCommentScanner()
	{
		IRule[] rules=null;
		RuleBasedScanner scanner=new RuleBasedScanner();
		commentPartition=new Token(new TextAttribute(colorManager.getColor(IColorConstants.DEFAULT),null,SWT.ITALIC));
		
		MultiLineRule rule=new MultiLineRule("/*","*/",commentPartition);
		
		
		rules=new IRule[]{rule};
			if (rules!=null)
			scanner.setRules(rules);
		return scanner;
	}
	
	private SingleWordRule getSokbRules(SingleWordRule wordRule)
	{
		wordRule.addWord("h",token);
		wordRule.addWord("noth",token);
		wordRule.addWord("e",token);
		wordRule.addWord("en",token);
		wordRule.addWord("note",token);
		wordRule.addWord("noten",token);
		
		
	
		
		return wordRule;
	}
	public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
		return new String[] { IDocument.DEFAULT_CONTENT_TYPE,DocumentSetupParticipant.COMMENT };
	}
	
	

}
