package sCIFF.EDITOR;

import org.eclipse.swt.SWT;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.layout.GridData;
import java.util.Vector;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.custom.ScrolledComposite;
import java.io.FileNotFoundException;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.jface.text.contentassist.ContextInformation;


import sCIFF.CheckFile;
import sCIFF.Project;
import sCIFF.Utility;


public class ProjectEditor extends MultiPageEditorPart {
	
	private Project project;
	private IFile projectFile;
	private IFolder ics;
	private IFolder history;
	private IFolder sokb;
	private IFile[] icsFiles,historyFiles,sokbFiles;
	private CheckFile[] icsCheck,historyCheck,sokbCheck;
	private Button[] options;
	private ProjectTextEditor textEditor=new ProjectTextEditor();
	private IEditorInput input;
	private Shell shell;
	
	

	public ProjectEditor() {
		
		super();
		
			
	}
	
	public void init(IEditorSite site, IEditorInput input)
    throws PartInitException {
		this.input=input;
		super.init(site,input);
		
		if (input instanceof IFileEditorInput)
		{
			IFileEditorInput temp=(IFileEditorInput)input;
			projectFile=temp.getFile();
			
			
		}
	}
	//Crea la pagina di controllo dell'editor
	private void createControlPage()
	{
		shell=this.getSite().getShell();
		GridLayout layout = new GridLayout();
		ScrolledComposite scrolledComposite=new ScrolledComposite(this.getContainer(),SWT.H_SCROLL | SWT.V_SCROLL | SWT.BORDER);
		scrolledComposite.setLayout(layout);
		
		
		Composite controlPage=new Composite(scrolledComposite,SWT.NULL);
		
		
		
		//istanzia l'oggetto che gestisce l'editing del file project.pl
		
		
		
		controlPage.setLayout(layout);
		layout.numColumns = 2;
		
		
		project=new Project(projectFile);
		try{
		project.setOptions();
		Composite optionsGroup=new Composite(controlPage,SWT.NULL);
		optionsGroup.setLayout(layout);
		Label optionsLabel=new Label(optionsGroup,SWT.LEFT);
		optionsLabel.setText("Project options:");
		optionsLabel.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_BEGINNING,GridData.VERTICAL_ALIGN_CENTER,false,false,2,1));
		options=new Button[project.getOptions().length];
		for (int i=0;i<project.getOptions().length;i++)
		{
			options[i]=new Button(optionsGroup,SWT.CHECK);
			options[i].setText(project.getOptions()[i].getName());
			if (project.isSelectedOption(options[i].getText()))
			options[i].setSelection(true);
			options[i].addSelectionListener(new SelectionAdapter(){
				public void widgetSelected(SelectionEvent e){
					
					String doc=textEditor.getDocumentProvider().getDocument(input).get();
					
					Button button=(Button)e.widget;
					if(button.getSelection())
					{
						String temp=project.addOption( button.getText(),textEditor.getDocumentProvider().getDocument(input).get());
						if(project.getOption(button.getText()).isDefault())
						{
							try{
							textEditor.getDocumentProvider().getDocument(input).replace(0,temp.length(),temp);
							textEditor.getDocumentProvider().getDocument(input).replace(temp.length(),doc.length()-temp.length(),"");
							}catch(BadLocationException ex){Utility.showError(ex.getMessage(),false);}
						}else{
						textEditor.getDocumentProvider().getDocument(input).set(temp);
						}
					}else{
						String temp=project.deleteOption( button.getText(),textEditor.getDocumentProvider().getDocument(input).get());
						try{
						if(project.getOption(button.getText()).isDefault())
						{textEditor.getDocumentProvider().getDocument(input).set(temp);}
						else {
						textEditor.getDocumentProvider().getDocument(input).replace(0,temp.length(),temp);
						textEditor.getDocumentProvider().getDocument(input).replace(temp.length(),doc.length()-temp.length(),"");
						}
						}catch(BadLocationException ex){Utility.showError(ex.getMessage(),false);}
					}
					
				}
					
			});
			
//			options[i].addMouseTrackListener(new MouseTrackAdapter()
//				{
//				private Shell info;
//					public void mouseEnter(MouseEvent e) 
//					{
//						info=new Shell(shell,SWT.BORDER);
//						info.setText("ciao");
//						info.setSize(40,40);
//						
//						Composite group=new Composite(info,SWT.NULL);
//						
//						String help=((Button)e.getSource()).getText();
//						Label label=new Label(group,SWT.NULL);
//						label.setText("jklljk");
//						info.open();
//					}
//					
//					public void mouseExit(MouseEvent e)
//					{
//						info.dispose();
//					}
//				});
			if(project.getOptions()[i].getHelp()!="")
			options[i].setToolTipText(project.getOptions()[i].getHelp());
			
		}
		}catch(FileNotFoundException e){}
		
		Composite filesGroup=new Composite(controlPage,SWT.NULL);
		filesGroup.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_BEGINNING,GridData.VERTICAL_ALIGN_CENTER,false,false,2,1));
		filesGroup.setLayout(layout);
		Label filesLabel=new Label(filesGroup,SWT.LEFT);
		filesLabel.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_BEGINNING,GridData.VERTICAL_ALIGN_CENTER,false,false,2,1));
		filesLabel.setText("Files to insert in the project file:");
		
		
		
		getCheckFileResources();
		
		Label icsLabel=new Label(filesGroup,SWT.LEFT);
		icsLabel.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_BEGINNING,GridData.VERTICAL_ALIGN_CENTER,false,false,2,1));
		icsLabel.setText("ICS files:");
		icsCheck=new CheckFile[icsFiles.length];
		for (int i=0;i<icsFiles.length;i++)
		{
			icsCheck[i]=new CheckFile(filesGroup,SWT.CHECK);
			icsCheck[i].setFile(icsFiles[i]);
			icsCheck[i].getButton().setText(icsCheck[i].getFile().getProjectRelativePath().toPortableString());
			if(project.isPresent(icsCheck[i].getFile()))
				icsCheck[i].getButton().setSelection(true);
			icsCheck[i].getButton().addSelectionListener(new SelectionAdapter(){
				public void widgetSelected(SelectionEvent e){
					String temp;
					
					Button button=(Button)e.widget;
					String doc=textEditor.getDocumentProvider().getDocument(input).get();
					if(button.getSelection())
					{
						temp=Project.addFile( button.getText(),textEditor.getDocumentProvider().getDocument(input).get(),"ics");
						textEditor.getDocumentProvider().getDocument(input).set(temp);			
					}else{
						temp=Project.deleteFile( button.getText(),textEditor.getDocumentProvider().getDocument(input).get(),"ics");
						try{
						textEditor.getDocumentProvider().getDocument(input).replace(0,temp.length(),temp);
						textEditor.getDocumentProvider().getDocument(input).replace(temp.length(),doc.length()-temp.length(),"");
						}catch(BadLocationException ex){Utility.showError(ex.getMessage(),false);}
					}
					
				}
					
			});
		}
		
		Label historyLabel=new Label(filesGroup,SWT.LEFT);
		historyLabel.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_BEGINNING,GridData.VERTICAL_ALIGN_CENTER,false,false,2,1));
		historyLabel.setText("HISTORY files:");
		historyCheck=new CheckFile[historyFiles.length];
		for (int i=0;i<historyFiles.length;i++)
		{
			historyCheck[i]=new CheckFile(filesGroup,SWT.CHECK);
			historyCheck[i].setFile(historyFiles[i]);
			historyCheck[i].getButton().setText(historyCheck[i].getFile().getProjectRelativePath().toPortableString());
			if(project.isPresent(historyCheck[i].getFile()))
				historyCheck[i].getButton().setSelection(true);
			historyCheck[i].getButton().addSelectionListener(new SelectionAdapter(){
				public void widgetSelected(SelectionEvent e){
					
					String doc=textEditor.getDocumentProvider().getDocument(input).get();
					
					Button button=(Button)e.widget;
					if(button.getSelection())
					{
						String temp=Project.addFile( button.getText(),textEditor.getDocumentProvider().getDocument(input).get(),"history");
						textEditor.getDocumentProvider().getDocument(input).set(temp);
					}else{
						String temp=Project.deleteFile( button.getText(),textEditor.getDocumentProvider().getDocument(input).get(),"history");
						try{
						textEditor.getDocumentProvider().getDocument(input).replace(0,temp.length(),temp);
						textEditor.getDocumentProvider().getDocument(input).replace(temp.length(),doc.length()-temp.length(),"");
						}catch(BadLocationException ex){Utility.showError(ex.getMessage(),false);}
					}
					
				}
					
			});
		}
		
		Label sokbLabel=new Label(filesGroup,SWT.LEFT);
		sokbLabel.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_BEGINNING,GridData.VERTICAL_ALIGN_CENTER,false,false,2,1));
		sokbLabel.setText("SOKB files:");
		sokbCheck=new CheckFile[sokbFiles.length];
		for (int i=0;i<sokbFiles.length;i++)
		{
			sokbCheck[i]=new CheckFile(filesGroup,SWT.CHECK);
			sokbCheck[i].setFile(sokbFiles[i]);
			sokbCheck[i].getButton().setText(sokbCheck[i].getFile().getProjectRelativePath().toPortableString());
			if(project.isPresent(sokbCheck[i].getFile()))
				sokbCheck[i].getButton().setSelection(true);
			sokbCheck[i].getButton().addSelectionListener(new SelectionAdapter(){
				public void widgetSelected(SelectionEvent e){
					
					String doc=textEditor.getDocumentProvider().getDocument(input).get();
					
					Button button=(Button)e.widget;
					if(button.getSelection())
					{
						String temp=Project.addFile( button.getText(),textEditor.getDocumentProvider().getDocument(input).get(),"sokb");
						textEditor.getDocumentProvider().getDocument(input).set(temp);
					}else{
						String temp=Project.deleteFile( button.getText(),textEditor.getDocumentProvider().getDocument(input).get(),"sokb");
						try{
						textEditor.getDocumentProvider().getDocument(input).replace(0,temp.length(),temp);
						textEditor.getDocumentProvider().getDocument(input).replace(temp.length(),doc.length()-temp.length(),"");
						}catch(BadLocationException ex){Utility.showError(ex.getMessage(),false);}
					}
					
				}
					
			});
		}
		
		scrolledComposite.setContent(controlPage);	
		scrolledComposite.setExpandVertical(true);
		scrolledComposite.setExpandHorizontal(true); 
		scrolledComposite.setMinHeight(controlPage.getBounds().height);
		scrolledComposite.setMinWidth(controlPage.getBounds().width); 
		addPage(0,scrolledComposite);
		setPageText(0,"settings");
		
		
	}
	//inserisce la pagina con il TextEditor
	private void createEditorPage()
	{
		try{
		addPage(1,textEditor,input);
		}catch(PartInitException e){Utility.showError(e.getMessage(),false);}
		setPageText(1,"Text Editor");
	}

	protected void createPages() {
		
		createControlPage();
		createEditorPage();
		
	}
	
	//popola gli array sokbFiles,historyFiles e icsFiles con i relativi file nel progetto
	private void getCheckFileResources()
	{
		Vector vAllFiles=new Vector();
		getResources(projectFile.getProject(),vAllFiles);
			
		ics=projectFile.getProject().getFolder("ICS");
		Vector vIcs=new Vector();
		Vector vRuleml=new Vector();
		getFileOfType("ics",vAllFiles,vIcs);
		getFileOfType("ruleml",vAllFiles,vRuleml);
		icsFiles=new IFile[vIcs.size()+vRuleml.size()];
		vIcs.copyInto(icsFiles);
		IFile[] rulemlFiles=new IFile[vRuleml.size()];
		vRuleml.copyInto(rulemlFiles);
		for(int i=vIcs.size();i<rulemlFiles.length+vIcs.size();i++)
		{
			icsFiles[i]=rulemlFiles[i-vIcs.size()];
		}
		
		history=projectFile.getProject().getFolder("HISTORY");
		Vector vHistory=new Vector();
		getFileOfType("his",vAllFiles,vHistory);
		historyFiles=new IFile[vHistory.size()];
		vHistory.copyInto(historyFiles);
		
		sokb=projectFile.getProject().getFolder("SOKB");
		Vector vSokb=new Vector();
		getFileOfType("sokb",vAllFiles,vSokb);
		sokbFiles=new IFile[vSokb.size()];
		vSokb.copyInto(sokbFiles);
		
		
		
	}
	//Inserisce in un Vector tutti i file nel progetto 
	private void getResources(IContainer folder,Vector files)
	{
		try{
		IResource[] resources=folder.members();
		
		
		for(int i=0;i<resources.length;i++)
		{
			if (resources[i].getType()==IResource.FOLDER )
			{
				getResources((IFolder)resources[i],files);
				
			}else 
			if (resources[i].getType()==IResource.FILE)
			{
				files.add((IFile)resources[i]);
			}
			
		}
		}catch(CoreException e){Utility.showError(e.getMessage(),false);}
	}
	

	public void doSave(IProgressMonitor monitor){
		
		textEditor.doSave(monitor);
	}

	public void doSaveAs() {
		// TODO Auto-generated method stub

	}

	public boolean isSaveAsAllowed() {
		// TODO Auto-generated method stub
		return false;
	}
	
	//Controlla il Vector dove sono tutti i file inseriti dal metodo getResources() e 
	//se hanno l'estensione specificata, li inserisce nel vettore vDest
	public void getFileOfType(String extension,Vector vOrigin,Vector vDest)
	{
		IFile[] files=new IFile[vOrigin.size()];
		vOrigin.copyInto(files);
		for(int i=0;i<files.length;i++)
		{
			if (files[i].getFileExtension().equals(extension))
				vDest.add(files[i]);
		}
	}

}
