package sCIFF.EDITOR;


import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.swt.SWT;

import sCIFF.Utility;



public class IcsEditorConfiguration extends SourceViewerConfiguration {
	
	private ColorManager colorManager;
	private IToken token,commentPartition,operatorToken;


	public IcsEditorConfiguration(ColorManager colorManager) {
		super();
		this.colorManager=colorManager;
	}
	
	public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer)
	{
		PresentationReconciler reconciler=new PresentationReconciler();
		
		
		DefaultDamagerRepairer dr=new DefaultDamagerRepairer(getScanner());
		reconciler.setDamager(dr,IDocument.DEFAULT_CONTENT_TYPE);
		reconciler.setRepairer(dr,IDocument.DEFAULT_CONTENT_TYPE);
		
		return reconciler;
	}
	
	private ITokenScanner getScanner()
	{
		IRule[] rules=null;
		RuleBasedScanner scanner=new RuleBasedScanner();
		token=new Token(new TextAttribute(colorManager.getColor(IColorConstants.CLAUSE),null,SWT.BOLD));
		operatorToken=new Token(new TextAttribute(colorManager.getColor(IColorConstants.OPERATOR),null,SWT.BOLD));
		commentPartition=new Token(new TextAttribute(colorManager.getColor(IColorConstants.ICS_COMMENT),null,SWT.ITALIC));
		
		SingleLineRule commentRule=new SingleLineRule("%",null,commentPartition,((char) 0),true);
		
		SingleWordRule wordRule=new SingleWordRule(new SimpleWordDetector());
		SingleWordRule operatorRule=new SingleWordRule(new SimpleOperatorDetector());
		
		operatorRule=getOperatorRules(operatorRule);
		wordRule=getIcsRules(wordRule);
		
		rules=new IRule[]{commentRule,wordRule,operatorRule};		
			if (rules!=null)
			scanner.setRules(rules);
		return scanner;
	}
	
	
	private SingleWordRule getIcsRules(SingleWordRule wordRule)
	{
		wordRule.addWord("H",token);
		wordRule.addWord("!H",token);
		wordRule.addWord("E",token);
		wordRule.addWord("EN",token);
		wordRule.addWord("!E",token);
		wordRule.addWord("!EN",token);
		wordRule.addWord("ABD",token);
		
		
		
		
		return wordRule;
	}
	
	private SingleWordRule getOperatorRules(SingleWordRule wordRule)
	{
		wordRule.addWord("--->",operatorToken);
		wordRule.addWord("/\\",operatorToken);
		wordRule.addWord("\\/",operatorToken);
		
		return wordRule;
	}
	
public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
		
		ContentAssistant assistant =new ContentAssistant();
		ContextInformation infoContext=new ContextInformation(IDocument.DEFAULT_CONTENT_TYPE,Utility.getParameterHints("ICS"));
		SciffContentAssistProcessor processor=new SciffContentAssistProcessor(infoContext);
		EventInformationValidator validator=new EventInformationValidator();
		processor.setContextInformationValidator(validator);
		assistant.setContentAssistProcessor(processor,IDocument.DEFAULT_CONTENT_TYPE);
		assistant.enableAutoActivation(true);
		assistant.setAutoActivationDelay(300);
		assistant.setContextInformationPopupOrientation(IContentAssistant.CONTEXT_INFO_ABOVE);
		return assistant;
	}
	
	

}
