package sCIFF.EDITOR;

import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.jface.text.PaintManager;
import org.eclipse.jface.text.source.MatchingCharacterPainter;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.graphics.Color;


public class HistoryEditor extends TextEditor {
	ColorManager colorManager;
	protected PaintManager fPaintManager;

	protected MatchingCharacterPainter fBracketPainter;


	
	

	public HistoryEditor() {
		super();
		colorManager = new ColorManager();
		setSourceViewerConfiguration(new HistoryEditorConfiguration(colorManager));
	}
	
	public void dispose()
	{
		super.dispose();
		colorManager.dispose();
	}
	
	protected void createActions() {
		super.createActions();

		fPaintManager = new PaintManager(this.getSourceViewer());

		
		startBracketHighlighting();
		
		} 
	
	
	private void startBracketHighlighting() {
		if (fBracketPainter == null) {
		fBracketPainter = new
		MatchingCharacterPainter(this.getSourceViewer(),new SomePairMatcher());
		fBracketPainter.setColor(new Color(Display.getCurrent(),IColorConstants.BRACKET));
		fPaintManager.addPainter(fBracketPainter);
		}
		} 
	
		
}