package sCIFF.EDITOR;

import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules .IPredicateRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.PatternRule;

public class DocumentSetupParticipant implements IDocumentSetupParticipant {
	
	public static final String COMMENT="SCIFF comment";
	public static final String[] TYPES=new String[]{IDocument.DEFAULT_CONTENT_TYPE,COMMENT};

	public void setup(IDocument document) {
		IDocumentPartitioner p;
		p=new FastPartitioner(getCommentPartition(),TYPES);
		p.connect(document);
	}
	
	private IPartitionTokenScanner getCommentPartition()
	{
		RuleBasedPartitionScanner scanner=new RuleBasedPartitionScanner();
		PatternRule rule=new PatternRule("/*","*/",new Token(COMMENT),(char)0,true);
		scanner.setPredicateRules(new IPredicateRule[]{rule});
		return scanner;
	}

}
