package sCIFF;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.core.runtime.CoreException;

public class CleanSCIFFproject {
	

	private static String prjClean=	"";
	private static String prjPre= ":- dynamic ics_file/1, sokb_file/1, history_file/1, required_option/2.\n\n";
	
	private static String prjPost= "\n\n"+
		"%%%%%%%%%%%%%%%%%%%%%%% Constant Part %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\n"+
			"build_prj(Path):-\n"+
			"\tfindall(F,ics_file(F),ICS_files), append_path(Path,ICS_files,IcsPathFiles),\n"+
			"\ttranslate_ics_files(IcsPathFiles,'./ics.pl'),\n"+
			"\tfindall(F,history_file(F),Hist_files),  append_path(Path,Hist_files,HistPathFiles),\n"+
			"\ttranslate_histories(HistPathFiles,'./history.pl'),\n"+
			"\tfindall(F,sokb_file(F),Sokb_files),     append_path(Path,Sokb_files,SokbPathFiles),\n"+
			"\tconvert_sokb(SokbPathFiles,'./sokb.pl'),\n"+
			"\tcompile(sokb), compile(history), compile(ics),\n"+
			"\tfindall([O,V],required_option(O,V),LOptions),\n"+
			"\tset_options(LOptions).\n\n"+
			"% Default:\n"+
			"run(_):- run.\n"+
			"run_open(_):- run_no_close.\n"+
			"run_closed(_):- run.";
	
	
	public static boolean Create(String name)
	{
		IPerspectiveDescriptor perspective=SCIFFPlugin.getDefault().getWorkbench().getPerspectiveRegistry().findPerspectiveWithId("SCIFF.perspective");
		SCIFFPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().setPerspective(perspective);
		
		IWorkspace work=ResourcesPlugin.getWorkspace();
		IWorkspaceRoot workRoot=ResourcesPlugin.getWorkspace().getRoot();
		IProject newProject=workRoot.getProject(name);
		IProjectDescription newProjectDescription=work.newProjectDescription(name);
		String[] natureId=new String[1];
		natureId[0]="SCIFF.SCIFFnature";
		newProjectDescription.setNatureIds(natureId);
		
		
		try{
						
		newProject.create(newProjectDescription,null);
		newProject.open(null);
		SCIFFPlugin.getDefault().getNavigator().getTreeViewer().refresh();
		}
		catch(CoreException e)
		{
			return false;
		}
		
//		try{
//		Options options=new Options();
//		ProjectOption[] prjOptions=options.getProjectOption();
//		for(int i=0;i<prjOptions.length;i++)
//		{
//			if(prjOptions[i].isDefault())
//			{
//				prjPre=prjPre+prjOptions[i].getSyntax()+"\n";
//			}
//		}
//		}catch(FileNotFoundException e){}
		
		prjClean=prjPre+prjPost;
		
		ByteArrayInputStream stream=new ByteArrayInputStream(prjClean.getBytes());
		
		
		
		IFile projectFile=newProject.getFile("project.pl");
		try{
		projectFile.create(stream,true,null);
		
		
		
		
		
		
		}catch(CoreException e){return false;}
		

		
		
		IFolder HistoryFolder=newProject.getFolder("HISTORY");
		try{
			HistoryFolder.create(true,true,null);
			}
			catch(CoreException e)
			{
				return false;
			}
			
		IFolder IcsFolder=newProject.getFolder("ICS");
			try{
			IcsFolder.create(true,true,null);
			}
			catch(CoreException e)
			{
				return false;
			}
		
		IFolder SokbFolder=newProject.getFolder("SOKB");
		try{
			SokbFolder.create(true,true,null);
			}
			catch(CoreException e)
			{
				return false;
			}
			
			try{
			newProject.isNatureEnabled("SCIFF.SCIFFnature");
			newProject.refreshLocal(IResource.DEPTH_INFINITE, null);
			}catch(CoreException e){}
			
		
		
		return true;
	}
	
	public static boolean CreateImport(String name)
	{
		
		IPerspectiveDescriptor perspective=SCIFFPlugin.getDefault().getWorkbench().getPerspectiveRegistry().findPerspectiveWithId("SCIFF.perspective");
		SCIFFPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().setPerspective(perspective);
		IWorkspace work=ResourcesPlugin.getWorkspace();
		IWorkspaceRoot workRoot=ResourcesPlugin.getWorkspace().getRoot();
		IProject newProject=workRoot.getProject(name);
		IProjectDescription newProjectDescription=work.newProjectDescription(name);
		String[] natureId=new String[1];
		natureId[0]="SCIFF.SCIFFnature";
		newProjectDescription.setNatureIds(natureId);
		
		
		try{
		newProject.create(newProjectDescription,null);
		newProject.open(null);
		
		SCIFFPlugin.getDefault().getNavigator().getTreeViewer().refresh();
		}catch(CoreException e)
		{
			return false;
		}
		
		
		
		
				
		
		
		
		
		
		
		
		
		

		
		
		IFolder HistoryFolder=newProject.getFolder("HISTORY");
		try{
			HistoryFolder.create(true,true,null);
			}
			catch(CoreException e)
			{
				return false;
			}
			
		IFolder IcsFolder=newProject.getFolder("ICS");
			try{
			IcsFolder.create(true,true,null);
			}
			catch(CoreException e)
			{
				return false;
			}
		
		IFolder SokbFolder=newProject.getFolder("SOKB");
		try{
			SokbFolder.create(true,true,null);
			}
			catch(CoreException e)
			{
				return false;
			}
			
			try{
			newProject.isNatureEnabled("SCIFF.SCIFFnature");
			}catch(CoreException e){}
			
		
		
		return true;
	}
	
}
