package res;


/**
 * @author  Luca Armani
 * @version 1, 09/02/2000
 * @see     res.ResourceManager
 */


public class JvmManager{

private native void init();

public JvmManager()
  {init();}

   /**
     * Ritorna le statistiche di tutti i thread attivi (dal momento del
     * lancio del monitor) nella JVM.
     */
public native ThreadStat[] getThreadStat();

   /**
     * Ritorna le statistiche, aggregate, dei thread deceduti.
     */
public native DeadThreadStat getDeadThreadStat();

   /**
     * Abilita o disabilita il tracing degli oggetti.
     */
public native void traceObjects(boolean set);

   /**
     * Abilita o disabilita il tracing dei metodi.
     */
public native void traceMethods(boolean set);

   /**
     * Abilita o disabilita il tracing dei monitor.
     */
public native void traceMonitors(boolean set);

   /**
     * Permette di caricare una classe contente il metodo
     * static void main(String[] args). Viene creato un nuovo thread
     * che esegue tale metodo.
     *
     * @param      clazz   il nome della classe
     * @param      args    gli argomenti da passare al main
     * @exception  Exception  se la classe non pu essere trovata, se
     *             non ha accesso public o se non possiede un main
     */
public static void run(String clazz,String[] args)
  throws Exception
//use fully qualified name
  {
  MainThread t;
  t=new MainThread(clazz,args);
  t.start();
  }
   
   
   /**
     * Ritorna la rappresentazione di questo oggetto.
     */
public String toString()
  {return "JVM Manager";}

   /**
     * Ritorna la versione della classe JvmManager.
     */
public int getVersion()
  {return 1;}

static
  {
  try{System.loadLibrary("lkpi");}   //carica dll
  catch(UnsatisfiedLinkError err)
    {
    throw new RuntimeException("Unable to find "+
      System.mapLibraryName("lkpi")+" in path "+
      System.getProperty("java.library.path"));
    }  
  }  
    
}







  