package res;

/**
 * Un oggetto ThreadStat contiene informazioni relative ad un 
 * singolo thread. I campi sono tipicamente contatori che misurano
 * la voce indicata.
 *
 * @author  Luca Armani<a href=mailto:outoftime@libero.it>outoftime@libero.it</a>
 */

public class ThreadStat{

/**
  * Riferimento al thread Java.
  */
public Thread thread;

/**
  * Numero di oggetti allocati, cumulativo. Sono conteggiati anche gli   * oggetti non pi presenti, ormai rilasciati dal Garbage Collector. 
  */
public int obj_num;

/**
  * Memoria allocata dagli oggetti (in bytes). Non si tiene conto della   * memoria rilasciata dal Garbage Collector.
  */
public int obj_size;

/**
  * Metodi chiamati, cumulativo.
  */
public int meth_num;

/**
  * Operazioni di lettura da file, cumulativo.
  */
public int file_in;  

/**
  * Operazioni di scrittura su file, cumulativo.
  */
public int file_out;  

/**
  * Operazioni di lettura TCP, cumulativo; ogni operazione
  * trasferisce da 1 a 1024 bytes.
  */
public int tcp_in;  

/**
  * Operazioni di scrittura TCP, cumulativo; ogni operazione
  * trasferisce da 1 a 1024 bytes.
  */
public int tcp_out;  

/**
  * Operazioni di lettura UDP, cumulativo; ogni operazione
  * equivale a un pacchetto ricevuto.
  */
public int udp_in;  

/**
  * Operazioni di scrittura UDP, cumulativo; ogni operazione
  * equivale a un pacchetto inviato.
  */
public int udp_out;  

/**
  * Classi caricate, cumulativo.
  */
public int class_num;

/**
  * Numero di monitor sui quali il thread ha
  * dovuto attendere, cumulativo.
  */
public int monitor_num;

/**
  * Millisecondi di cpu consumati dal thread dalla sua nascita.
  * Con questa versione il contatore  attivo solo su Windows NT,
  * mentre per altri sistemi il dato restituito  pari a zero.
  */
public long time;

/**
  * Percentuale di cpu occupata dal thread, calcolata rispetto alla
  * lettura precedente.
  * Con questa versione il contatore  attivo solo su Windows NT,
  * mentre per altri sistemi il dato restituito  pari a zero.
  */
public float cpu;
}
