package res;

import java.io.*;

/**
 * Un oggetto ProcessMonitor implementa un monitor di processi di
 * sistema sfruttando le potenzialit di JNI. Mediante i metodi di
 * tale oggetto  possibile recuperare informazioni sullo stato dei
 * processi, dei thread e della rete. Attualmente sono disponibili
 * le implementazioni per Windows NT e per Solaris.
 *
 * @author  Luca Armani<a href=mailto:outoftime@libero.it>outoftime@libero.it</a>
 * @version 1, 9/2/2000
 * @see     res.JvmMonitor
 */

public class ProcessMonitor{

   /**
     * Ritorna il Process IDentifier del processo java. 
     */
public native int getPid();


   /**
     * Ritorna le informazioni di performance di tutti i processi
     * del sistema nei successivi msec millisecondi.
     *
     * @param      msec   tempo in millisecondi 
     */
public native ProcessInfo[] getProcessInfo(long msec);

   /**
     * Ritorna le informazioni di performance del processo specificato
     * nei successivi msec millisecondi. Lanciaa un'eccezione se non
     * esiste un processo con il PID specificato.
     *
     * @param      pid    PID del processo
     * @param      msec   tempo in millisecondi 
     */
public native ProcessInfo getProcessInfo(int pid,long msec)
throws Exception;  

   /**
     * Ritorna le informazioni di performance della rete
     * nei successivi msec millisecondi.
     *
     * @param      msec   tempo in millisecondi 
     */
public NetworkInfo getNetworkInfo(long msec)
  {
  NetworkInfo before,after;
  before=getNetworkInfo();
  try{Thread.sleep(msec);}
  catch(Exception ecc) {}
  after=getNetworkInfo();
  after.udp_pack_in-=before.udp_pack_in;
  after.udp_pack_out-=before.udp_pack_out;
  after.udp_pack_in_err-=before.udp_pack_in_err;
  after.tcp_conn-=before.tcp_conn;
  after.tcp_seg_in-=before.tcp_seg_in;
  after.tcp_seg_out-=before.tcp_seg_out;
  after.ip_pack_in-=before.ip_pack_in;
  after.ip_pack_out-=before.ip_pack_out;
  after.ip_pack_in_err-=before.ip_pack_in_err;
  after.interval-=before.interval;
  return after;
  }


   /**
     * Ritorna il sistema operativo ospite.
     */
public String getOs()
  {
  return System.getProperty("os.name")+
    " "+
    System.getProperty("os.version"); 
  }  

   /**
     * Ritorna la rappresentazione di questo oggetto.
     */
public String toString()
  {return "ProcessMonitor"; }

   /**
     * Ritorna la versione della classe ProcessMonitor.
     */
public int getVersion()
  {return 1;}



    /**
     * Carica una classe esterna. La classe deve essere public e contentere
     * il metodo <code>static void main(String[] args)</code>. Viene creato
     * un nuovo thread che esegue tale metodo.
     *
     * @param      clazz   il nome della classe (completo di package)
     * @param      args    gli argomenti da passare al main
     * @exception  Exception  se la classe non pu essere trovata, se
     *             non ha accesso public o se non possiede un main
     */
public static void run(String clazz,String[] args)
  throws Exception
//use fully qualified name
  {
  MainThread t;
  t=new MainThread(clazz,args);
  t.start();
  }



private NetworkInfo getNetworkInfo()
  {
  //uso netstat
  NetworkInfo ni;
  Process netstat;
  StreamTokenizer st;
  ni=new NetworkInfo();
  ni.interval=new java.util.Date().getTime();
  try{
  if(System.getProperty("os.name").startsWith("Win"))
    {
    netstat=Runtime.getRuntime().exec("netstat -s");
    st=new StreamTokenizer(new InputStreamReader(netstat.getInputStream()));  
    int k;
    for(k=0;st.ttype!=StreamTokenizer.TT_EOF;st.nextToken())
      if(st.ttype==StreamTokenizer.TT_NUMBER)
        switch(k++)
          {
          case  0:ni.ip_pack_in=(int)st.nval;break;
          case  6:ni.ip_pack_in_err=ni.ip_pack_in-(int)st.nval;break;
          case  7:ni.ip_pack_out=(int)st.nval;break;
          case 47:ni.tcp_conn=(int)st.nval;break;
          case 48:ni.tcp_seg_in=(int)st.nval;break;
          case 49:ni.tcp_seg_out=(int)st.nval;break;
          case 51:ni.udp_pack_in=(int)st.nval;break;
          case 52:ni.udp_pack_in_err=(int)st.nval;break;
          case 53:ni.udp_pack_in_err+=(int)st.nval;break;
          case 54:ni.udp_pack_out=(int)st.nval;break;
          }
    }     
  else  //other OS
    {
    netstat=Runtime.getRuntime().exec("netstat -s");
    st=new StreamTokenizer(new InputStreamReader(netstat.getInputStream()));  
    int k;
    for(k=0;st.ttype!=StreamTokenizer.TT_EOF;st.nextToken())
      {
      if(st.ttype==StreamTokenizer.TT_NUMBER)
        switch(k++)
          {
          case 55:ni.ip_pack_in=(int)st.nval;break;
          case 56:ni.ip_pack_in_err=(int)st.nval;break;
          case 57:
          case 58:ni.ip_pack_in_err+=(int)st.nval;break;
          case 64:ni.ip_pack_out=(int)st.nval;break;
          case 11:ni.tcp_conn=(int)st.nval;break;
          case 25:ni.tcp_seg_in=(int)st.nval;break;
          case 12:ni.tcp_seg_out=(int)st.nval;break;
          case 0:ni.udp_pack_in=(int)st.nval;break;
          case 1:ni.udp_pack_in_err=(int)st.nval;break;
          case 2:ni.udp_pack_out=(int)st.nval;break;
          }
      }
    }//else
    }//try  
    catch(Exception ecc)
      {
      ni.ip_pack_in=0;
      ni.ip_pack_in_err=0;
      ni.ip_pack_out=0;
      ni.tcp_conn=0;
      ni.tcp_seg_in=0;
      ni.tcp_seg_out=0;
      ni.udp_pack_in=0;
      ni.udp_pack_in_err=0;
      ni.udp_pack_out=0;
      }
  return ni;
  }
  








static
  {
  try{System.loadLibrary("ps");}   //carica libps.so o ps.dll
  catch(UnsatisfiedLinkError err)
    {
    throw new RuntimeException("Unable to find "+
      System.mapLibraryName("ps")+" in path "+
      System.getProperty("java.library.path"));
    }  
  }  


}