#include <stdio.h>
#include <fcntl.h>
#include <dirent.h>
#include <sys/types.h>
#include <sys/procfs.h>
#include "res_ProcessMonitor.h"


jlong millisec(timestruc_t time)
{
return time.tv_sec*1000+time.tv_nsec/1000000;
}


jlong PhysicalMemory()
{
/* Questa  da sistemare! */
return 128*1024*1024;
}


void exception(JNIEnv *env)
{
jclass clazz;
clazz=(*env)->FindClass(env,"java/lang/Exception");
(*env)->ThrowNew(env,clazz,"Process not found");
}


typedef struct{
  int id;
  jlong cputime;
  jlong timestamp;
  } usage;





/*ottiene le informazioni su tutti i lwp
  appartenenti al processo fd */

usage *LwpData(int fd,int *lwpcount)
{
usage *result;
prusage_t buffer[32];
prusage_t *tmp;
int i;

memset(buffer,0,sizeof(prusage_t)*32);
if(ioctl(fd,PIOCLUSAGE,buffer)==-1)
  {
  *lwpcount=-1;
  return NULL;
  }
tmp=&buffer[1];
*lwpcount=0;
while(tmp->pr_lwpid!=0)
  {
  (*lwpcount)++;
  tmp++;
  }
result=(usage*)malloc(sizeof(usage)*(*lwpcount));  
for(i=0;i<(*lwpcount);i++)
  {
  result[i].id=buffer[i+1].pr_lwpid;
  result[i].cputime=millisec(buffer[i+1].pr_utime)+
                    millisec(buffer[i+1].pr_stime);
  result[i].timestamp=millisec(buffer[i+1].pr_tstamp);
  }
return result;
}




jobjectArray buildThreadInfo(JNIEnv *env,
                           usage lwpbefore[],
                           int nlwpbefore,
                           usage lwpafter[],
                           int nlwpafter)
{
jobjectArray array;
jclass clazz;
jobject tinfo;
jfieldID fid[3];
int i,j;
jlong prev;
jfloat cpu;


/*identificatori di classe e di metodi*/
clazz=(*env)->FindClass(env,"res/ThreadInfo");
fid[0]=(*env)->GetFieldID(env,clazz,"tid","I");
fid[1]=(*env)->GetFieldID(env,clazz,"cpu","F");
fid[2]=(*env)->GetFieldID(env,clazz,"time","J");

if(nlwpafter<=0) 
  return (*env)->NewObjectArray(env, 0, clazz, NULL);
  //non dovrebbe mai capitare, ma un controllino...

for(i=0;i<nlwpafter;i++)
  {
  prev=0;
  for(j=0;j<nlwpbefore;j++)
    if(lwpbefore[j].id==lwpafter[i].id)
      {
      prev=lwpbefore[j].cputime;
      break;
      }     
  tinfo=(*env)->AllocObject(env,clazz);
  (*env)->SetIntField(env,tinfo,fid[0],lwpafter[i].id);
  cpu= lwpafter[i].cputime-prev;
  cpu/=lwpafter[i].timestamp-lwpbefore[0].timestamp;    
  cpu*=100;
  (*env)->SetFloatField(env,tinfo,fid[1],cpu);
  (*env)->SetLongField(env,tinfo,fid[2],lwpafter[i].cputime);
  if(i==0) array=(*env)->NewObjectArray(env, nlwpafter, clazz, tinfo);
  else (*env)->SetObjectArrayElement(env,array,i,tinfo);
  }     
return array;
}









/*
 * Class:     res_ProcessMonitor
 * Method:    getPid
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_res_ProcessMonitor_getPid
  (JNIEnv *env, jobject thiz)
{return getpid();}










/*
 * Class:     res_ProcessMonitor
 * Method:    getProcessInfo
 * Signature: (IJ)Lres/ProcessInfo;
 */
JNIEXPORT jobject JNICALL Java_res_ProcessMonitor_getProcessInfo__IJ
  (JNIEnv *env, jobject thiz, jint pid, jlong msec)
{
jclass clazz;
jobject pinfo;
jfieldID fid[8];
jfloat cpu;
char nomefile[16];
int fd,sec;
prpsinfo_t ps;
prusage_t before,after;
usage *lwpbefore,*lwpafter;
int nlwpbefore,nlwpafter;

/*identificatori di classe e di metodi*/
clazz=(*env)->FindClass(env,"res/ProcessInfo");
fid[0]=(*env)->GetFieldID(env,clazz,"pid","I");
fid[1]=(*env)->GetFieldID(env,clazz,"phys_mem","J");
fid[2]=(*env)->GetFieldID(env,clazz,"virt_mem","J");
fid[3]=(*env)->GetFieldID(env,clazz,"thread","[Lres/ThreadInfo;");
fid[4]=(*env)->GetFieldID(env,clazz,"cpu","F");
fid[5]=(*env)->GetFieldID(env,clazz,"time","J");
fid[6]=(*env)->GetFieldID(env,clazz,"name","Ljava/lang/String;");
fid[7]=(*env)->GetStaticFieldID(env,clazz,"total_mem","J");


/*file nella directory /proc  */
sprintf(nomefile,"/proc/%ld",pid);
if((fd=open(nomefile,O_RDONLY))==-1) exception(env);

/*raccolta informazioni*/
if(ioctl(fd,PIOCUSAGE,&before)==-1 ) exception(env);
lwpbefore=LwpData(fd,&nlwpbefore);

sec=msec/1000;
if(sec<=0) sleep(1);
else sleep(sec);

if(ioctl(fd,PIOCUSAGE,&after)==-1) exception(env);
lwpafter=LwpData(fd,&nlwpafter);
if(ioctl(fd,PIOCPSINFO,&ps)==-1) exception(env);

close(fd);

/*allocaz oggetto e suoi campi*/

pinfo=(*env)->AllocObject(env,clazz);
(*env)->SetIntField(env,pinfo,fid[0],pid);
(*env)->SetLongField(env,pinfo,fid[1],ps.pr_byrssize);
(*env)->SetLongField(env,pinfo,fid[2],ps.pr_bysize);
(*env)->SetObjectField(env,pinfo,fid[3],
  buildThreadInfo(env,lwpbefore,nlwpbefore,lwpafter,nlwpafter));

cpu=millisec(after.pr_utime)+millisec(after.pr_stime)
    -millisec(before.pr_utime)-millisec(before.pr_stime);
cpu/=millisec(after.pr_tstamp)-millisec(before.pr_tstamp);
cpu*=100;
(*env)->SetFloatField(env,pinfo,fid[4],cpu);

(*env)->SetLongField(env,pinfo,fid[5],
           millisec(after.pr_utime)+millisec(after.pr_stime));

(*env)->SetObjectField(env,pinfo,fid[6],
           (*env)->NewStringUTF(env,ps.pr_fname));

(*env)->SetStaticLongField(env,clazz,fid[7],PhysicalMemory());

free(lwpbefore);
free(lwpafter);
return pinfo;
}






/*
 * Class:     res_ProcessMonitor
 * Method:    getProcessInfo
 * Signature: (J)[Lres/ProcessInfo;
 */
JNIEXPORT jobjectArray JNICALL Java_res_ProcessMonitor_getProcessInfo__J
  (JNIEnv *env, jobject thiz, jlong msec)
{
jobjectArray array;
jclass clazz;
jobject pinfo;
jfieldID fid[8];
jfloat cpu;
DIR *dir;
dirent_t *entry;
char nomefile[16];
int fd,sec,i,j,prev;
prpsinfo_t ps[128];
prusage_t tmp;
usage procbefore[128],procafter[128];
int nprocbefore,nprocafter;
usage *lwpbefore[128],*lwpafter[128];   //array di puntat
int nlwpbefore[128],nlwpafter[128];

/*identificatori di classe e di metodi*/
clazz=(*env)->FindClass(env,"res/ProcessInfo");
fid[0]=(*env)->GetFieldID(env,clazz,"pid","I");
fid[1]=(*env)->GetFieldID(env,clazz,"phys_mem","J");
fid[2]=(*env)->GetFieldID(env,clazz,"virt_mem","J");
fid[3]=(*env)->GetFieldID(env,clazz,"thread","[Lres/ThreadInfo;");
fid[4]=(*env)->GetFieldID(env,clazz,"cpu","F");
fid[5]=(*env)->GetFieldID(env,clazz,"time","J");
fid[6]=(*env)->GetFieldID(env,clazz,"name","Ljava/lang/String;");
fid[7]=(*env)->GetStaticFieldID(env,clazz,"total_mem","J");

//raccolta informazioni
dir=opendir("/proc");
nprocbefore=0;
for(entry=readdir(dir);
    entry;
    entry=readdir(dir))
  {
  sprintf(nomefile,"/proc/%s",entry->d_name);
  if((fd=open(nomefile,O_RDONLY))!=-1)
    {
    ioctl(fd,PIOCUSAGE,&tmp);
    procbefore[nprocbefore].id=atoi(entry->d_name);
    procbefore[nprocbefore].cputime=
      millisec(tmp.pr_utime)+millisec(tmp.pr_stime);
    procbefore[nprocbefore].timestamp=millisec(tmp.pr_tstamp);
    lwpbefore[nprocbefore]=LwpData(fd,&nlwpbefore[nprocbefore]);
    nprocbefore++;
    close(fd);
    }
  }  
closedir(dir);

sec=msec/1000;
if(sec<=0) sleep(1);
else sleep(sec);

dir=opendir("/proc");
nprocafter=0;
for(entry=readdir(dir);
    entry;
    entry=readdir(dir))
  {
  sprintf(nomefile,"/proc/%s",entry->d_name);
  if((fd=open(nomefile,O_RDONLY))!=-1)
    {
    ioctl(fd,PIOCUSAGE,&tmp);
    ioctl(fd,PIOCPSINFO,&ps[nprocafter]);
    procafter[nprocafter].id=atoi(entry->d_name);
    procafter[nprocafter].cputime=
      millisec(tmp.pr_utime)+millisec(tmp.pr_stime);
    procafter[nprocafter].timestamp=millisec(tmp.pr_tstamp);
    lwpafter[nprocafter]=LwpData(fd,&nlwpafter[nprocafter]);
    nprocafter++;
    close(fd);
    }
  }  
closedir(dir);

//restituisco risultati
for(i=0;i<nprocafter;i++)
  {
  prev=-1;
  for(j=0;j<nprocbefore;j++)
    if(procbefore[j].id==procafter[i].id)
      {
      prev=j;
      break;
      }
  pinfo=(*env)->AllocObject(env,clazz);
  (*env)->SetIntField(env,pinfo,fid[0],ps[i].pr_pid);
  (*env)->SetLongField(env,pinfo,fid[1],ps[i].pr_byrssize);
  (*env)->SetLongField(env,pinfo,fid[2],ps[i].pr_bysize);
  
  cpu=procafter[i].cputime;
  if(prev!=-1)
    {
    cpu-=procbefore[prev].cputime;
    (*env)->SetObjectField(env,pinfo,fid[3],
       buildThreadInfo(env,lwpbefore[prev],nlwpbefore[prev],lwpafter[i],nlwpafter[i]));
    }
  else 
    {
    (*env)->SetObjectField(env,pinfo,fid[3],
       buildThreadInfo(env,lwpbefore[0],0,lwpafter[i],nlwpafter[i]));
    prev=0;
    }  
  
  cpu/=procafter[i].timestamp-procbefore[prev].timestamp;
  cpu*=100;
  (*env)->SetFloatField(env,pinfo,fid[4],cpu);
  (*env)->SetLongField(env,pinfo,fid[5],procafter[i].cputime);
  (*env)->SetObjectField(env,pinfo,fid[6],
                         (*env)->NewStringUTF(env,ps[i].pr_fname));

  (*env)->SetStaticLongField(env,clazz,fid[7],PhysicalMemory());
  
  if(i==0) array=(*env)->NewObjectArray(env, nprocafter, clazz, pinfo);
  else (*env)->SetObjectArrayElement(env,array,i,pinfo);
  }


//dealloc delle LwpData
for(j=nprocafter-1;j>=0;j--)
  free(lwpafter[j]);
for(j=nprocbefore-1;j>=0;j--)
  free(lwpbefore[j]);

return array;
}


