#include <jni.h>
#include <wtypes.h>



static PPERF_DATA_BLOCK perfdata;
static int os=-1;   //0=NT, 1=win95





void getOs()
{
OSVERSIONINFO info;
info.dwOSVersionInfoSize=sizeof(OSVERSIONINFO);
GetVersionEx(&info);
switch(info.dwPlatformId)
{
case VER_PLATFORM_WIN32_WINDOWS:os=1;break;
case VER_PLATFORM_WIN32_NT:os=0;break;
default:os=2;
}
}









PPERF_DATA_BLOCK CollectData(LPTSTR query)
  {
  LPBYTE data;
  DWORD BufferSize=4096;
  data= malloc( BufferSize );

  while(RegQueryValueEx( HKEY_PERFORMANCE_DATA, query, NULL, NULL,
                         data, &BufferSize ) == ERROR_MORE_DATA )
   {
   BufferSize += 4096;
   data= realloc( data, BufferSize );
   }
 
  RegCloseKey(HKEY_PERFORMANCE_DATA);
  return (PPERF_DATA_BLOCK) data;
  }



PPERF_OBJECT_TYPE FindObject( PPERF_DATA_BLOCK perfdata , DWORD index)
{
PPERF_OBJECT_TYPE obj;
DWORD i;
for(i=0,obj= (PPERF_OBJECT_TYPE)((PBYTE)perfdata + perfdata->HeaderLength) ;   //1st
    i<perfdata->NumObjectTypes;
    i++,obj= (PPERF_OBJECT_TYPE)((PBYTE)obj + obj->TotalByteLength) )
 if(obj->ObjectNameTitleIndex==index) return obj;
 return NULL;    
}



void FindCounters(PPERF_OBJECT_TYPE obj, DWORD index[],
                  PPERF_COUNTER_DEFINITION result[], int len)
{
int i,j;
PPERF_COUNTER_DEFINITION cntr;                  
memset(result,0,sizeof(PPERF_COUNTER_DEFINITION)*len);
for(i=0,cntr = (PPERF_COUNTER_DEFINITION) ((PBYTE)obj + obj->HeaderLength);
    i< obj->NumCounters;
    i++,cntr= (PPERF_COUNTER_DEFINITION)((PBYTE)cntr + cntr->ByteLength) )
for(j=0;j<len;j++)
  if(cntr->CounterNameTitleIndex==index[j])
    result[j]=cntr;
}





PPERF_INSTANCE_DEFINITION FirstInstance( PPERF_OBJECT_TYPE obj )
{
    return( (PPERF_INSTANCE_DEFINITION)((PBYTE)obj + 
        obj->DefinitionLength) );
}

PPERF_INSTANCE_DEFINITION NextInstance( 
    PPERF_INSTANCE_DEFINITION inst )
{
    PPERF_COUNTER_BLOCK cntrBlk;

    cntrBlk = (PPERF_COUNTER_BLOCK)((PBYTE)inst + 
        inst->ByteLength);

    return( (PPERF_INSTANCE_DEFINITION)((PBYTE)cntrBlk + 
        cntrBlk->ByteLength) );
}






jlong InstanceData ( PPERF_INSTANCE_DEFINITION perfinst,PPERF_COUNTER_DEFINITION perfcntr)
   {
    PBYTE data;
    
    data=(PBYTE)perfinst +perfinst->ByteLength + //perf_block
         perfcntr->CounterOffset;
   if(perfcntr->CounterSize==4) return (jlong) (*((LONG*)(data)));
   if(perfcntr->CounterSize==8) return *((jlong*)(data));
   return -1;
   } 










void freeze()
{                           
if(os<0) getOs();
if(os==0) perfdata = CollectData("232");
}




jlong getCpu(DWORD tid)
{
if(os==0)
{
PPERF_OBJECT_TYPE obj;
PPERF_INSTANCE_DEFINITION inst;
PPERF_COUNTER_DEFINITION cntr[2];
DWORD index[]={804,6};   //tid,cpu
DWORD i;



//mi posiziono su obj232=thread
obj = FindObject( perfdata ,232);

//trovo i contatori tid+cpu
FindCounters(obj,index,cntr,2);

//cerco l'istanza con tid

for(i=0,inst = FirstInstance( obj );
    i<obj->NumInstances;  
    i++,inst = NextInstance( inst ))
if(InstanceData(inst,cntr[0])==tid)
  return InstanceData(inst,cntr[1])/10000;
}
//else
return 0;  
}








void unfreeze()
{                           
if(os==0) free(perfdata);
}
