#include "res_JvmMonitor.h"
#include <jvmpi.h>


extern "C"{


#ifdef WIN32
#include <wtypes.h>
jlong getCpu(DWORD tid);
#endif





//prototipi
JNIEXPORT jint JNICALL JVM_OnLoad(JavaVM *jvm, char *options, void *reserved);
void notifyEvent(JVMPI_Event *ev);
void freeze();
void unfreeze();
void lock();
void unlock();
jobject getJavaCurrentThread(JNIEnv *env);
void handle_monitor(JVMPI_Event *ev);
void handle_method(JVMPI_Event *ev);
void handle_object(JVMPI_Event *ev);


//classi
class Stat{
public:
  jobject thread; 
  jint obj_num;
  jint obj_size;
  jint method_num;
  jint file_in;
  jint file_out;
  jint tcp_in;
  jint tcp_out;
  jint udp_in;
  jint udp_out;
  jint class_num;
  jint monitor_num;
#ifdef WIN32
  DWORD tid;
  jlong time;
  jlong delta_time;
#endif
};



class ThreadTable{                      
private:
  JNIEnv *thread[128];   //dovrebbero bastare...
  int siz;
public:
  ThreadTable();
  void add(JNIEnv *env,Stat stat);
  Stat *get(JNIEnv *env);
  Stat *getAt(int index);
  void remove(JNIEnv *env);
  int size();
};






// var statiche globali 
static JVMPI_RawMonitor raw=NULL;
static JVMPI_Interface *jvmpi=NULL;
static ThreadTable thread_table;












//entry point al caricamento della dll
JNIEXPORT jint JNICALL
JVM_OnLoad(JavaVM *jvm, char *options, void *reserved)
{
if(jvmpi!=NULL) return JNI_OK;
if(jvm->GetEnv((void**)&jvmpi,JVMPI_VERSION_1)<0) return JNI_ERR;
raw=jvmpi->RawMonitorCreate("_mutex1");
jvmpi->NotifyEvent=notifyEvent;
jvmpi->EnableEvent(JVMPI_EVENT_CLASS_LOAD,NULL);
jvmpi->EnableEvent(JVMPI_EVENT_JVM_INIT_DONE,NULL);
jvmpi->EnableEvent(JVMPI_EVENT_JVM_SHUT_DOWN,NULL);

return JNI_OK;
}




/*
 * Class:     res_JvmMonitor
 * Method:    init
 * Signature: ()V
 */
JNIEXPORT void JNICALL
Java_res_JvmMonitor_init(JNIEnv *env, jobject thiz)
{
if(jvmpi!=NULL) return;
fprintf(stderr,"JvmMonitor not loaded at startup, probably you will loose some information\n");  
JavaVM *jvm;
env->GetJavaVM(&jvm);
jvm->GetEnv((void**)&jvmpi,JVMPI_VERSION_1);
raw=jvmpi->RawMonitorCreate("_mutex1");
jvmpi->NotifyEvent=notifyEvent;
jvmpi->EnableEvent(JVMPI_EVENT_CLASS_LOAD,NULL);
jvmpi->EnableEvent(JVMPI_EVENT_JVM_SHUT_DOWN,NULL);
jvmpi->EnableEvent(JVMPI_EVENT_THREAD_START,NULL);
jvmpi->EnableEvent(JVMPI_EVENT_THREAD_END,NULL);
jvmpi->EnableEvent(JVMPI_EVENT_METHOD_ENTRY2,NULL);
jvmpi->EnableEvent(JVMPI_EVENT_OBJECT_ALLOC,NULL);
jvmpi->EnableEvent(JVMPI_EVENT_MONITOR_CONTENDED_ENTER,NULL);
}  




//sincronizzazione
void lock()
{
jvmpi->RawMonitorEnter(raw);
}

void unlock()
{
jvmpi->RawMonitorExit(raw);
jvmpi->RawMonitorNotifyAll(raw);
}


//funzione di utilit
jobject getJavaCurrentThread(JNIEnv *env)
{
jclass clazz;
jmethodID mid;
clazz=env->FindClass("java/lang/Thread");
mid=env->GetStaticMethodID(clazz,"currentThread","()Ljava/lang/Thread;");
return env->CallStaticObjectMethod(clazz,mid);
}




//funzione di ricezione degli eventi
void notifyEvent(JVMPI_Event *ev)
{
switch(ev->event_type)
{
case JVMPI_EVENT_JVM_INIT_DONE:
  fprintf(stderr,"JvmMonitor start\n");
  jvmpi->EnableEvent(JVMPI_EVENT_THREAD_START,NULL);
  jvmpi->EnableEvent(JVMPI_EVENT_THREAD_END,NULL);
  jvmpi->EnableEvent(JVMPI_EVENT_METHOD_ENTRY2,NULL);
  jvmpi->EnableEvent(JVMPI_EVENT_OBJECT_ALLOC,NULL);
  jvmpi->EnableEvent(JVMPI_EVENT_MONITOR_CONTENDED_ENTER,NULL);
  break;
case JVMPI_EVENT_JVM_SHUT_DOWN:
  fprintf(stderr,"JvmMonitor exit\n");
  break;
case JVMPI_EVENT_THREAD_START:
  Stat stat;
  stat.obj_num=0;
  stat.obj_size=0;
  stat.method_num=0;
  stat.tcp_in=0;
  stat.tcp_out=0;
  stat.udp_in=0;
  stat.udp_out=0;
  stat.file_in=0;
  stat.file_out=0;
  stat.class_num=0;
  stat.monitor_num=0;
  lock();
#ifdef WIN32
  stat.time=0;
  stat.tid=GetCurrentThreadId();
#endif
  stat.thread=getJavaCurrentThread(ev->env_id);
  thread_table.add(ev->env_id,stat);
  unlock();
  break;
case JVMPI_EVENT_THREAD_END:
  lock();
  thread_table.remove(ev->env_id);
  unlock();
  break;
case JVMPI_EVENT_CLASS_LOAD:
case JVMPI_EVENT_METHOD_ENTRY2:
  handle_method(ev);
  break;
case JVMPI_EVENT_MONITOR_CONTENDED_ENTER:
  handle_monitor(ev);
  break;
case JVMPI_EVENT_OBJECT_ALLOC:
case JVMPI_EVENT_OBJECT_FREE:
case JVMPI_EVENT_OBJECT_MOVE:
  handle_object(ev);
  break;
}
}









//gestione riconoscimento classi e metodi
void handle_method(JVMPI_Event *ev)
{
static jmethodID tread=NULL;  //tcp
static jmethodID twrite=NULL;
static jmethodID ureceive=NULL;      //udp
static jmethodID usend=NULL;
static jmethodID fread=NULL;        //files
static jmethodID freadbytes=NULL;
static jmethodID fwrite=NULL;
static jmethodID fwritebytes=NULL;
Stat *stat;
JVMPI_Method *meth;

if(ev->event_type==JVMPI_EVENT_METHOD_ENTRY2)
  {
  //if(ev->u.method_entry2.method_id==twrite) printf("tcp out\n");
  //if(ev->u.method_entry2.method_id==tread) printf("tcp in\n");
  //if(ev->u.method_entry2.method_id==ureceive) printf("udp in\n");
  //if(ev->u.method_entry2.method_id==usend) printf("udp out\n");
  stat=thread_table.get(ev->env_id);
  if(stat==NULL) return;
  stat->method_num++;
  if(ev->u.method_entry2.method_id==twrite)
    stat->tcp_out++;
  else
  if(ev->u.method_entry2.method_id==tread)
    stat->tcp_in++;
  else
  if(ev->u.method_entry2.method_id==ureceive)
    stat->udp_in++;
  else
  if(ev->u.method_entry2.method_id==usend)
    stat->udp_out++;
  else
  if(ev->u.method_entry2.method_id==freadbytes||
     ev->u.method_entry2.method_id==fread) stat->file_in++;
  else
  if(ev->u.method_entry2.method_id==fwritebytes||
     ev->u.method_entry2.method_id==fwrite)
    stat->file_out++;
  }  
else  //class
  {
  if(tread==NULL && (strcmp(ev->u.class_load.class_name,"java/net/SocketInputStream")==0))
    {
    for(meth=ev->u.class_load.methods;;meth++)
    if(strcmp(meth->method_name,"socketRead")==0)
      {tread=meth->method_id;break;}
    }
  if(twrite==NULL && (strcmp(ev->u.class_load.class_name,"java/net/SocketOutputStream")==0))
    {
    for(meth=ev->u.class_load.methods;;meth++)
    if(strcmp(meth->method_name,"socketWrite")==0)
      {twrite=meth->method_id;break;}
    }
  if(usend==NULL && (strcmp(ev->u.class_load.class_name,"java/net/DatagramSocket")==0))
    {
    for(meth=ev->u.class_load.methods;usend==NULL||ureceive==NULL;meth++)
      {
      if(strcmp(meth->method_name,"send")==0)
        usend=meth->method_id;
      if(strcmp(meth->method_name,"receive")==0)
        ureceive=meth->method_id;
      }
    }
  if(fread==NULL && (strcmp(ev->u.class_load.class_name,"java/io/FileInputStream")==0))
    {
    for(meth=ev->u.class_load.methods;fread==NULL || freadbytes==NULL;meth++)
      {
      if(strcmp(meth->method_name,"read")==0 && strcmp(meth->method_signature,"()I")==0)
        fread=meth->method_id;
      if(strcmp(meth->method_name,"readBytes")==0)
        freadbytes=meth->method_id;
      }
    }
  if(fwrite==NULL && (strcmp(ev->u.class_load.class_name,"java/io/FileOutputStream")==0))
    {
    for(meth=ev->u.class_load.methods;fwrite==NULL || fwritebytes==NULL;meth++)
      {
      if(strcmp(meth->method_name,"write")==0 && strcmp(meth->method_signature,"(I)V")==0)
        fwrite=meth->method_id;
      if(strcmp(meth->method_name,"writeBytes")==0)
        fwritebytes=meth->method_id;
      }
    }
  stat=thread_table.get(ev->env_id);
  if(stat!=NULL) stat->class_num++;
  }
}


//gestione monitor (java)
void handle_monitor(JVMPI_Event *ev)
{
Stat *stat;
stat=thread_table.get(ev->env_id);
if(stat!=NULL) stat->monitor_num++;
}


//gestione oggetti
void handle_object(JVMPI_Event *ev)
{
Stat *stat;
stat=thread_table.get(ev->env_id);
if(stat==NULL) return;
stat->obj_num++;
stat->obj_size+=ev->u.obj_alloc.size;
}  








//funzione di lettura da java
/*
 * Class:     res_JvmMonitor
 * Method:    getThreadStat
 * Signature: ()[Lres/ThreadStat;
 */
JNIEXPORT jobjectArray JNICALL
Java_res_JvmMonitor_getThreadStat(JNIEnv *env, jobject thiz)
{
jclass clazz;
jobject obj;
jobjectArray array;
jfieldID fid[14];
jint i;
Stat *stat;

clazz=env->FindClass("res/ThreadStat");
if(thread_table.size()==0)   
  return env->NewObjectArray(0,clazz,NULL);
fid[0]=env->GetFieldID(clazz,"thread","Ljava/lang/Thread;");
fid[1]=env->GetFieldID(clazz,"obj_num","I");
fid[2]=env->GetFieldID(clazz,"obj_size","I");
fid[3]=env->GetFieldID(clazz,"meth_num","I");
fid[4]=env->GetFieldID(clazz,"tcp_in","I");
fid[5]=env->GetFieldID(clazz,"tcp_out","I");
fid[6]=env->GetFieldID(clazz,"udp_in","I");
fid[7]=env->GetFieldID(clazz,"udp_out","I");
fid[8]=env->GetFieldID(clazz,"class_num","I");
fid[9]=env->GetFieldID(clazz,"monitor_num","I");
fid[10]=env->GetFieldID(clazz,"file_in","I");
fid[11]=env->GetFieldID(clazz,"file_out","I");
fid[12]=env->GetFieldID(clazz,"time","J");
fid[13]=env->GetFieldID(clazz,"cpu","F");


freeze();
lock();

#ifdef WIN32
jlong delta_all,now;
delta_all=0;
for(i=0;i<thread_table.size();i++)
  {
  stat=thread_table.getAt(i);
  now=getCpu(stat->tid);
  stat->delta_time=now-stat->time;
  stat->time=now;
  delta_all+=stat->delta_time;
  }
if(delta_all<1) delta_all=1;  //un controllino...
#endif
for(i=0;i<thread_table.size();i++)
  {
  stat=thread_table.getAt(i);
  obj=env->AllocObject(clazz);
  env->SetObjectField(obj,fid[0],stat->thread);
  env->SetIntField(obj,fid[1],stat->obj_num);
  env->SetIntField(obj,fid[2],stat->obj_size);
  env->SetIntField(obj,fid[3],stat->method_num);
  env->SetIntField(obj,fid[4],stat->tcp_in);
  env->SetIntField(obj,fid[5],stat->tcp_out);
  env->SetIntField(obj,fid[6],stat->udp_in);
  env->SetIntField(obj,fid[7],stat->udp_out);
  env->SetIntField(obj,fid[8],stat->class_num);
  env->SetIntField(obj,fid[9],stat->monitor_num);
  env->SetIntField(obj,fid[10],stat->file_in);
  env->SetIntField(obj,fid[11],stat->file_out);
#ifdef WIN32
  env->SetLongField(obj,fid[12],stat->time);
  env->SetFloatField(obj,fid[13],((jfloat)stat->delta_time)*100/delta_all);
#else  
  env->SetLongField(obj,fid[12],0);
  env->SetFloatField(obj,fid[13],0);
#endif  
  if(i==0) array=env->NewObjectArray(thread_table.size(),clazz,obj);
      else env->SetObjectArrayElement(array,i,obj);
  }
unlock();
unfreeze();
return array;
}





ThreadTable::ThreadTable()
{
int i;
for(i=0;i<128;i++)
  thread[i]=NULL;
siz=0;
}



void ThreadTable::add(JNIEnv *env,Stat s)
{
Stat *stat;
int i;
for(i=0;i<128;i++)
  if(thread[i]==NULL)
    {
    stat=new Stat;
    *stat=s;
    jvmpi->SetThreadLocalStorage(env,stat);
    thread[i]=env;
    siz++;
    return;
    }
}


Stat *ThreadTable::get(JNIEnv *env)
{
return (Stat*)jvmpi->GetThreadLocalStorage(env);
}
    

Stat *ThreadTable::getAt(int index)
{
int i;
for(i=0;i<128;i++)
  if(thread[i]!=NULL)
    if(index--==0) return (Stat*)jvmpi->GetThreadLocalStorage(thread[i]);
return NULL;
}









void ThreadTable::remove(JNIEnv *env)
{
int i;
for(i=0;i<128;i++)
  if(thread[i]==env)
    {
    siz--;
    thread[i]=NULL;
    delete (Stat*)jvmpi->GetThreadLocalStorage(env);
    //return;
    }
}    




int ThreadTable::size()
{
return siz;
}




} //extern "C"