package SOMA.utility;

import java.io.*;
import java.util.*;

/** Attiva il <code>SecurityManager</code> standard.
*
* @author Livio Profiri
*/

public class StartSecurityManagerExplorerItem extends SOMA.explorer.ExplorerItem
{
  public StartSecurityManagerExplorerItem()
  {
    super( "Activates the system Security Manager." );
  }

  public Object Execute( Collection Parameters, PrintStream out )
  {
    SecurityManager theSecurityManager = null;

    try
    {
      theSecurityManager = System.getSecurityManager();
      if( theSecurityManager != null )
        out.println( "The Security Manager is ALREADY active."  );
      else
      {
        theSecurityManager = new SecurityManager();
        System.setSecurityManager( theSecurityManager );

        out.println( "Security Manager activated." );
      }
    }
    catch( Exception e )
    {
      e.printStackTrace( out );
    }

    return theSecurityManager;
  }
}