package SOMA.utility;

import java.util.*;
import java.io.*;

/** Voce di menu per leggere le proprieta' di sistema.
*
* @author Livio Profiri
*/
public class PropertiesExplorerItem extends SOMA.explorer.ExplorerItem
{
  public PropertiesExplorerItem()
  {
    super( "{property-key {property_value}}" );
  }

  /** Nessun argomento: lista di tutte le proprieta',
  * 1 argomento: Stampa la proprieta' corrispondente.
  * 2 argomenti (key value): assegna value a key, restituisce il vecchio valore.
  */
  public Object Execute( Collection Parameters, PrintStream out )
  {
    Object returnValue = null;

    if( Parameters.size() == 0 )
    {
      System.getProperties().list( out );
    }
    else if( Parameters.size() == 1 )
    {
      String Param = (String)Parameters.iterator().next();

      returnValue = System.getProperty( Param );
      out.println( Param + "=" + returnValue );
    }
    else if( Parameters.size() == 2 )
    {
      Iterator i = Parameters.iterator();
      String Key = (String)i.next();
      String Value = (String)i.next();
      returnValue = System.setProperty( Key, Value );

      out.println( "Key: " + Key  );
      out.println( "Old value: " + returnValue  );
      out.println( "New value: " + Value  );
    }

    return null;
  }

  public String Help( PrintStream out )
  {
    out.println( "No argument -> Lists all tha System Properties." );
    out.println( "1 argument KEY -> Prints the corresponding System Property value." );
    out.println( "2 argument KEY VALUE -> Sets the KEY property to VALUE." );
    return Syntax;
  }
}