package SOMA.utility;

import java.io.*;
import java.net.*;

/** Serializza su Sytsem.out l'Indirizzo locale.
* @author Livio Profiri
* @version 19/2/99
*/

public class GetLocalHost
{
  public static void main( String argv[] )
  {
    InetAddress Indirizzo = null;

    try
    {
      Indirizzo = InetAddress.getLocalHost();

      ObjectOutputStream Out =  new ObjectOutputStream( System.out );

      Out.writeObject( Indirizzo );
      Out.flush();
      Out.close();
    }
    catch( Exception e )
    {
      System.out.flush();
      System.out.close();
    }
  }

  /**
  *  Determina l'indirizzo IP attuale.
  *
  *  L'indirizzo IP viene richiesto ad un processo esterno, quindi si
  *  tratta dell'indirizzo effettivo, non di quello gi letto e mantenuto nella cache.
  *  Questo serve per accorgersi dei cambiamenti di IP dovuti a connessioni e deconnessioni
  *  dall'Internet Provider.
  *
  *
  *  @author Livio Profiri
  */

  static public InetAddress getCurrentLocalHost() throws UnknownHostException
  {
    return getCurrentLocalHost( System.out );
  }

  static public InetAddress getCurrentLocalHost( PrintStream out ) throws UnknownHostException
  {
    InetAddress VeroIP = null;

    try
    {
      Process Processo = null;
      Runtime Ambiente = Runtime.getRuntime();
      Processo = Ambiente.exec( "java SOMA.utility.GetLocalHost" );

      ObjectInputStream ObjIn = new ObjectInputStream( Processo.getInputStream() );
      VeroIP = (InetAddress) ObjIn.readObject();
      ObjIn.close();
    }
    catch (Exception e)
    {
      out.println( "GetLocalHost.getCurrentLocalhost() ERRORE: " + e );
      e.printStackTrace( out );
      out.println( "            Quindi: chiamo la solita getHostAddress!" );
    }

    // Se prima non ero riuscito riprovo con le buone maniere.
    if( VeroIP == null )
      VeroIP = InetAddress.getLocalHost(); // Possibile eccezione

    return VeroIP;
  }
}