package SOMA.security.utility;

/* This interface contain the name of the 6
 * roles to accept a password;
 * the user can use that to select the rules
 * to applicate in the ControlPassword class.
 */

public interface ControlPasswordRule {
    // Role 1
    //   the password must contain at least eight character
    public static final int PASSWORD_LENGTH = 1;

    // Role 2
    //   the password must contain at least one uppercase letter
    public static final int UPPERCASE_LETTER = 2;

    // Role 3
    //   the password must contain at least one lowercase letter
    public static final int LOWERCASE_LETTER = 4;

    // Role 4
    //  the password must contain at least one number
    public static final int NUMBER_IN_PASSWORD = 8;

    // Role 5
    //   the password cannot contain many occurrences of the same character
    public static final int SAME_CHARACTER = 16;

    // Role 6
    //   the password cannot contain a lengthy part of your profile name.
    //   Parameter:  password: the profile password;
    //               profileName: the profile file name.
    public static final int PROFILENAME_IN_PASSWORD = 32;


}