package SOMA.security.utility;

import java.lang.*;

/* This class control the password used for a profile.
 * The method Control verity the role for the
 * password format.
 */

public class ControlPassword implements ControlPasswordRule
{
    private static int passwordLengthMin = 8;

    //   Parameter:  password: the profile password;
    // This method do not use the Rule6 in control password
    public static boolean Control(String password){
        return (Rule1(password) &&
                Rule2(password) &&
                Rule3(password) &&
                Rule4(password) &&
                Rule5(password) );
    }

    // This method return tre string value for the application of the
    // password Rules.
    // This method do not use the Rule6 in control password
    public static String toString(String password){
        return new String(
                ((Rule1(password) ? "" : ("Password length error, at last " + passwordLengthMin) + " characters\n") +
                 (Rule2(password) ? "" : "The password must contain at least one uppercase letter\n") +
                 (Rule3(password) ? "" : "The password must contain at least one lowercase letter\n") +
                 (Rule4(password) ? "" : "The password must contain at least one number.\n") +
                 (Rule5(password) ? "" : "The password cannot contain many occurrences of the same character.\n")));
    }

    //   Parameter:  password: the profile password;
    //               profileName profile name
    public static boolean Control(String password, String profileName){
        return (Rule1(password) &&
                Rule2(password) &&
                Rule3(password) &&
                Rule4(password) &&
                Rule5(password) &&
                Rule6(password,profileName)  );
    }

    //   Parameter:  password: the profile password;
    //               profileName: profile name
    //               applayRules: the integer is the sum of the Rules to applay
    public static boolean Control(String password, String profileName, int applayRules){
        boolean valid = true;

        for (int i=5; valid && i >= 0; i--){
            int temp = elPot(2,i);
            if (applayRules >= temp) {
                applayRules =- temp;
                valid = Rule(password,profileName,temp);
            }
        }

        return valid;
    }


    private static int elPot (int b, int e){
        int retval = b;

        if (e <= 0) return 1;
        else return (b * elPot(b,e--));
    }


    private static boolean Rule(String password, String profileName, int applayRules){
        if (applayRules==PASSWORD_LENGTH)         return Rule1(password);
        if (applayRules==UPPERCASE_LETTER)        return Rule2(password);
        if (applayRules==LOWERCASE_LETTER)        return Rule3(password);
        if (applayRules==NUMBER_IN_PASSWORD)      return Rule4(password);
        if (applayRules==SAME_CHARACTER)          return Rule5(password);
        if (applayRules==PROFILENAME_IN_PASSWORD) return Rule6(password,profileName);
        return true;
    }

    // This method return the file name from a full path file name.
    public static String getFileName(String fullPath){
        char fullPathChar [];
        boolean findChar = false;
        int j;

        fullPathChar = fullPath.toCharArray();

        for(j=fullPathChar.length-1; (! findChar) && (j>=0); j--)
            if (findChar = (fullPathChar[j] == '\\')) j++;

        return new String(fullPathChar, j+1, fullPath.length()-(j+1));
    }

    // This method return tre string value for the application of the
    // password Rules.
    public static String toString(String password, String profileName){
        return new String(
                ((Rule1(password) ? "" : "Password length error, at last " + passwordLengthMin + " characters\n") +
                 (Rule2(password) ? "" : "The password must contain at least one uppercase letter\n") +
                 (Rule3(password) ? "" : "The password must contain at least one lowercase letter\n") +
                 (Rule4(password) ? "" : "The password must contain at least one number.\n") +
                 (Rule5(password) ? "" : "The password cannot contain many occurrences of the same character.\n") +
                 (Rule6(password,profileName) ? "" : "The password cannot contain a lengthy part of your profile name.\n")));
    }


        // This method return tre string value for the application of the
    // password Rules.
    public static String toString(String password, String profileName, int applayRules){
        String retMessage = new String("");

        if (applayRules >= PROFILENAME_IN_PASSWORD){
           retMessage = (Rule6(password,profileName) ? "" : "The password cannot contain a lengthy part of your profile name.\n");
           applayRules =- PROFILENAME_IN_PASSWORD;
        }
        if (applayRules >= SAME_CHARACTER){
           retMessage = (Rule5(password) ? "" : "The password cannot contain many occurrences of the same character.\n") + retMessage;
           applayRules =- SAME_CHARACTER;
        }
        if (applayRules >= NUMBER_IN_PASSWORD){
           retMessage = (Rule4(password) ? "" : "The password must contain at least one number.\n") + retMessage;
           applayRules =- NUMBER_IN_PASSWORD;
        }
        if (applayRules >= LOWERCASE_LETTER){
           retMessage = (Rule3(password) ? "" : "The password must contain at least one lowercase letter\n") + retMessage;
           applayRules =- LOWERCASE_LETTER;
        }
        if (applayRules >= UPPERCASE_LETTER){
           retMessage = (Rule2(password) ? "" : "The password must contain at least one uppercase letter\n") + retMessage;
           applayRules =- UPPERCASE_LETTER;
        }
        if (applayRules >= PASSWORD_LENGTH){
           retMessage = (Rule1(password) ? "" : "Password length error, at last " + passwordLengthMin + " characters\n") + retMessage;
           applayRules =- PASSWORD_LENGTH;
        }

        return retMessage;
    }



    // Rule 1
    //   the password must contain at least eight character
    public static boolean Rule1(String password) {
        return (password.length() >= passwordLengthMin);
    }

    // Rule 2
    //   the password must contain at least one uppercase letter
    public static boolean Rule2(String password) {
        return (password.compareTo(password.toLowerCase())!=0);
    }

    // Rule 3
    //   the password must contain at least one lowercase letter
    public static boolean Rule3(String password) {
        return (password.compareTo(password.toUpperCase())!=0);
    }

    // Rule 4
    //  the password must contain at least one number
    public static boolean Rule4(String password) {
        char passwordChar [] = password.toCharArray();
        boolean findNumber = false;

        for(int i=0; (! findNumber) && (i<passwordChar.length); i++)
            findNumber = ((passwordChar[i]>='0') && (passwordChar[i]<='9'));

        return findNumber;
    }

    // Rule 5
    //   the password cannot contain many occurrences of the same character
    public static boolean Rule5(String password) {
        char passwordChar [] = password.toCharArray();
        boolean charEqual = true;

        for(int j=1; (charEqual) && (j<passwordChar.length); j++)
            charEqual = (passwordChar[0] == passwordChar[j]);

        return (! charEqual);
    }


    // Rule 6
    //   the password cannot contain a lengthy part of your profile name.
    //   Parameter:  password: the profile password;
    //               profileName: the profile file name.
    public static boolean Rule6(String password, String profileName) {
        char profileChar [] = new char[profileName.length()];
        boolean containPart = false;

        for(int j=0; (! containPart) && (j <= (password.length()-profileName.length())); j++){
            password.getChars(j,j+profileName.length(),profileChar,0);
            containPart = profileName.equals(new String(profileChar));
        }

        return (! containPart);
    }

}