package SOMA.security.ssl;
/*
    This is the SSL-protected version of StringLengthServer.java.
    StringLengthServer.java (and SSL_StringLengthServer.java) do
    these steps:
    1. Listen for connections from clients.
    2. Return the length of incoming strings.
*/

import java.net.*;
import java.io.*;
import java.security.*;
import java.security.cert.X509Certificate;
import iaik.security.ssl.*;
import iaik.asn1.structures.Name;
import com.entrust.security.provider.*;
import com.entrust.toolkit.*;
import com.entrust.util.*;
import com.entrust.x509.directory.*;

import SOMA.network.connection.ConnectionServer;
import SOMA.security.infrastructure.*;


public class SSLConnectionServer extends ConnectionServer implements SSLControlCaller
{

    // Infrastruttura di riferimento.
    Infrastructure infrastructure = null;

    // profilo utente per la connessione.
    ProfileManager profile = null;

    int controlCaller = ControlCaller_ON;
/*
  Thread myServerDaemon = null;
  ServerSocket myServerSocket = null;
  ConnectionFactory myConnectionFactory = null;

  int status = OFF;
  String ErrorDescription = "";

  int port = 0;
  int backlog = 50;
*/

  public SSLConnectionServer (int port, int backlog, ConnectionFactory myConnectionFactory )
  {
    super.ConnectionServer(port, backlog, myConnectionFactory);
  }

  public SSLConnectionServer (int port, int backlog, ConnectionFactory myConnectionFactory, Infrastructure infrastructure, ProfileManager profile, int controlCaller)
  {
    this.infrastructure = infrastructure;
    this.profile = profile;
    this.controlCaller = controlCaller;
    super.ConnectionServer(port, backlog, myConnectionFactory);
  }

  public void setInfrastructure(Infrastructure infrastructure)
  {
    this.infrastructure = infrastructure;
  }

  public void setProfile(ProfileManager profile)
  {
    this.profile = profile;
  }


  public void setControlCaller(int controlCaller) throws SSLException
  {
    if (this.status != ON)
      this.controlCaller = controlCaller;
    else
      throw new SSLException( "Server already ON" );
  }

  public int getControlCaller()
  {
    return this.controlCaller;
  }

    /** Restituisce lo stato.
      * Metodo ereditato. */
    // public int getStatus()


  /* Rappresentazione in stringa dello stato del server. */
  public String toString()
  {
    return "<SSLConnectionServer: " + this +
           ": ControlCaller = " +
           (this.controlCaller == ControlCaller_ON ? "ON" : "OFF") +
           "\\n " + super.toString() + ">";
  }

  /** Avvia il server. */
  public synchronized void start() throws IOException, SSLException
  {
    if( status != ON )
    {
      try
      {
        myServerSocket = init();

        myServerDaemon = new Thread( this, toString() );

        status = ON;

        myServerDaemon.start();
      }
      catch( IOException e )
      {
        status = ERROR;
        ErrorDescription = e.toString();
        throw( e );
      }
    }
    else
      throw new SSLException( "Server already ON" );
  }

    /** Arresta il server.
      * Attenzione: questo metodo potrebbe non essere riscritto;
      *             lo si riscrive solo per poter ridefinire l'eccezione
      *             che viene chiamata in caso di stato diverso da OFF.
     **/

  public synchronized void stop() throws IOException, SSLException
  {
    if( status != OFF )
    {
      try
      {
        status = OFF;

        if( myServerSocket != null )
          myServerSocket.close();

        // Vedo se cos posso riattivarla in seguito.
        myServerSocket = null;
      }
      catch( IOException e )
      {
        status = ERROR;
        ErrorDescription = e.toString();
        throw( e );
      }
    }
    else
      throw new SSLException( "The server is already OFF" );
  }



  /** Metodo eseguito dal demone: attende richieste ed attiva connessioni finche' lo stato rimane ON e la ServerSocket attiva. */
  // Da sistemare.
  public void run()
  {
    Socket aSocket = null;
    Connection aConnection = null;

    while( status == ON )
    {
      try
      {
        //System.out.println( "SERVER " + toString() + " ACCEPT" );
        aSocket = (SSLSocket) myServerSocket.accept();

        // Control the caller
        if (this.controlCaller == ControlCaller_ON)
        {
            clientSocket.setAutoHandshake(false);
            java.security.cert.X509Certificate[] X509s = clientSocket.getPeerCertificateChain();
            // Verify the caller policy accept

            clientSocket.startHandshake();
        }


        //System.out.println( "SERVER " + toString() + " CREATE CONNECTION" );
        aConnection = myConnectionFactory.createConnection( aSocket );

        aConnection.start();
        //System.out.println( "SERVER " + toString() + " CONNECTION STARTED" );
      }
      catch( Exception e )
      {
        //if( (e instanceof SocketException) && (status == OFF) )
        //  System.err.println( "ConnectionServedDaemon: INTERROTTO" );
        //else
        if( status != OFF )  // Connessione non interrotta volutamente
        {
          //e.printStackTrace();
          status = ERROR;
          ErrorDescription = e.toString();
        }
      }
    }




    private static SSLServerSocket init() throws IOException, SSLException
    {
        BufferedReader stdIn = new BufferedReader(new InputStreamReader(System.in));

        // Initialize ciphers nel caso non sia stato fatto
        // Operazione inutile
        if (infrastructure.getInfrastructureAddress() == null)
          throw new SSLException( "Not found infrastructure address." );
        (infrastructure.getInfrastructureAddress()).checkCiphers();

        EntrustProfile entrustProfile;
        if ((entrustProfile = profile.getProfile()) == null)
          throw new SSLException( "Not found profile." );

        // EntrustProfile entrustProfile = new EntrustProfile();
        // System.out.println("EntrustProfile done.");

        SSLServerContext sslServerContext = new SSLServerContext();
        // Accept only these strong ciphers
        CipherSuite [] suites = {
                                    CipherSuite.SSL_RSA_WITH_3DES_EDE_CBC_SHA,
                                    CipherSuite.SSL_RSA_WITH_RC4_SHA,
                                    CipherSuite.SSL_RSA_WITH_RC4_MD5
                                };
        sslServerContext.setEnabledCipherSuites( suites );

        try {
            infrastructure.connectDirectory();
            JNDIDirectory directory = (infrastructure.getInfrastructureAddress()).getDirectory();

            ETKCertificateVerifier verifier = new ETKCertificateVerifier( directory, (profile.getProfile()) );

            sslServerContext.setTrustDecider(verifier);
        } catch (Exception ex) {
                ex.printStackTrace();
        }
        // System.out.println("ETKCertificateVerifier done.");

        try {
            // Set the RSA certificate.
            X509Certificate[] certchain=new X509Certificate[ 2];
            certchain[0] = entrustProfile.getEncryptionCertificate();
            certchain[1] = entrustProfile.getCaCertificate();
            sslServerContext.setRSACertificate(certchain,entrustProfile.getDecryptionKey());

            // Generate a temporary RSA key pair.
            KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA");
            kpg.initialize(512,Util.secureRandom());
            sslServerContext.setRSATempKeyPair(kpg.generateKeyPair());

            // Enable valid cipher suites.
            // CipherSuite[] enabledCS = serverContext.updateCipherSuites();
        } catch (Exception ex) {
            System.out.println("Unable to set RSA server certificate.");
            System.out.println("RSA cipher-suites can not be used.");
        }

        // System.out.println("Authentication (y/n)");

        if (this.controlCaller == ControlCaller_ON) {
            byte[] types = { ClientTrustDecider.rsa_sign //,
                            };
            Name[] cas=null;
            // For sample code illustrating how an
            // application could specify external CAs
            // as valid authenticators, see
            // SSLServerIOStream.java.

            cas = new Name[1];

            cas[0]=Util.getSubject(entrustProfile.getCaCertificate());
            sslServerContext.setRequireClientCertificate(types,cas);
        }
        else {
            // Turn off client authentication.
            sslServerContext.setRequireClientCertificate(null,null);
        }
        System.out.println("Server name is \"" + InetAddress.getLocalHost().getHostName() + "\".");

        SSLServerSocket serverListenSocket = null;

        try { // create a listen socket on any free port
            serverListenSocket = new SSLServerSocket(0, sslServerContext);
            System.out.println("StringLengthServer is listening on port \"" + serverListenSocket.getLocalPort() + "\"." );
        } catch (IOException e) {
            System.err.println("ERROR: Could not find a free port for listening.");
        }
        return serverListenSocket;
    }
}