package SOMA.security.infrastructure.explorer;

import java.util.*;
import java.io.*;

import SOMA.explorer.ExplorerItem;
import SOMA.explorer.DirExplorerItem;
import SOMA.security.infrastructure.ProfileManager;

/** Voce di menu per la gestione di un {@link SOMA.utility.Chronometer}.
*
* @author Luca Ghetti
*/
public class ProfileLoginExplorerItem extends SOMA.explorer.ExplorerItem
{
  /** @serial*/
  public ProfileManager profile;

  //  Current directory.
  public DirExplorerItem currentDir;

  public Object myKey;

  public ProfileLoginExplorerItem( ProfileManager profile, Object myKey, DirExplorerItem currentDir )
  {
    super( "[ logon FileProfile Password | create RefNum AuthCode Password FileName | recover RefNum AuthCode Password FileName ]" );
    this.profile = profile;
    this.currentDir = currentDir;
    this.myKey = myKey;
  }

  public Object Execute( Collection Parameters, PrintStream out )
  {
    if( Parameters.size() == 0 )
    {
      out.println( currentDir.toString() + "\n" + profile.toString() );
    }
    else
    {
      Iterator parametri = Parameters.iterator();
      String Param = (String)parametri.next();
      parametri.remove();

      if( Param.equals( "recover" ) && (Parameters.size() == 4 ) )
      {
        out.println("Recover Profile");
        try {
          String refnum   = (String)parametri.next() ;  // refnum
          parametri.remove();
          String authcode = (String)parametri.next() ;  // authcode
          parametri.remove();
          String password = (String)parametri.next() ;  // password
          parametri.remove();
          String filename = (String)parametri.next() ;   // filename


            profile.recoverProfile( refnum ,  // refnum
                                    authcode ,  // authcode
                                    password ,  // password
                                    filename ); // filename

        } catch (Exception e) { out.println("Error login profile: " + e); }
      }
      else if( Param.equals( "logon" ) && (Parameters.size() == 2 ) )
      {
        out.println("Logon Profile");
        try {
            String filename = (String)parametri.next();
            parametri.remove();
            String password = (String)parametri.next();

            parametri.remove();
            profile.logonProfile(filename ,    // filename
                                 password  );  // password
        } catch (Exception e) { out.println("Error login profile: " + e); }
        // Aggiunge la directory
        this.currentDir.addItem( "ProfileManager", new ProfileExplorerItem( "Profile_Manager" , this.profile , this.currentDir ) );
        // Toglie dalla directory il corrente men e ne aggiunge uno nuovo.
        this.currentDir.removeItem(this.myKey);
      }
      else if( Param.equals( "create" ) && (Parameters.size() == 4 ) )
      {
        out.println("Create Profile." );
        try {
          String refnum   = (String)parametri.next() ;  // refnum
          parametri.remove();
          String authcode = (String)parametri.next() ;  // authcode
          parametri.remove();
          String password = (String)parametri.next() ;  // password
          parametri.remove();
          String filename = (String)parametri.next() ;   // filename
          parametri.remove();

          profile.createProfile(refnum ,
                                authcode ,  // authcode
                                password ,  // password
                                filename ); // filename
        } catch (Exception e) { out.println("Error creating profile: " + e); }
      }
      else
      {
        out.println( "Unknown operation: " + Param );
      }
    }

    return profile;
  }

  public String Help( PrintStream out )
  {
    out.println( profile.toString() );
    return profile.toString();
  }
}