package SOMA.security.infrastructure.explorer;

import java.util.*;
import java.io.*;

import SOMA.explorer.ExplorerItem;
import SOMA.explorer.DirExplorerItem;
import SOMA.security.infrastructure.ProfileManager;

/** Voce di menu per la gestione di un del profilo.
*
* @author Luca Ghetti
*/
public class ProfileExplorerItem extends ExplorerItem
{
  /** @serial*/
  public ProfileManager profile;

  //  Current directory.
  public DirExplorerItem currentDir;

  // UpdatePolicy --> SubDir
  public DirExplorerItem updatePolicyDir;

  Object myKey;

  public ProfileExplorerItem( Object myKey, ProfileManager profile, DirExplorerItem currentDir )
  {
    super( "[ DistinguishName | logoff | changePassword oldPassword newPassword newPassword ]" );
    this.currentDir = currentDir;
    this.profile = profile;
    this.myKey = myKey;

    this.updatePolicyDir = new DirExplorerItem( "UpdatePolicy" );
    // Update subdir
    // this.updatePolicyDir( );
    String update = new String ("UpdatePolicy");
    String crlKey = new String ("showCRLs");

    this.updatePolicyDir.addItem( update, new PolicyUpdateItem ( update , this.profile , this.updatePolicyDir )  );
    this.updatePolicyDir.addItem( crlKey, new CRLsExplorerItem( crlKey, this.profile, this.updatePolicyDir ) );

    this.currentDir.addItem( this.updatePolicyDir );
  }

  public Object Execute( Collection Parameters, PrintStream out )
  {
    if( Parameters.size() == 0 )
    {
      out.println( currentDir.toString() + "\n" + profile.toString() );
    }
    else
    {
      Iterator parametri = Parameters.iterator();
      String Param = (String)parametri.next();
      parametri.remove();

      if( Param.equals( "DistinguishName" ) )
      {
        try {
           out.println( "Distinguish Name" + profile.getDistinguishName() );
        } catch ( Exception e ) { out.println( "Error reading Distinguish Name: " + e ); }
      }
      else if ( Param.equals( "logoff" ) )
      {
        try {
          out.println( "Logoff profile" );
          this.profile.logoffProfile();
          // disattiva questo men e ripristina il men profile logon
          String newKey = "ProfileLogon";
          this.currentDir.addItem( newKey , new ProfileLoginExplorerItem( profile , newKey , currentDir ) );
          // Toglie dalla directory il corrente men e ne aggiunge uno nuovo.
          this.currentDir.removeItem(this.myKey);

        } catch (Exception e) { out.println("Error changed password: " + e); }
      }
      else if( Param.equals( "changePassword" ) && (Parameters.size() == 3 ) )
      {
        out.println( "Change password" );
        try { // changePassword  newPassword newPassword
            String oldPassword = (String)parametri.next();
            parametri.remove();
            String newPassword1 = (String)parametri.next();
            parametri.remove();
            String newPassword2 = (String)parametri.next();


            if ( newPassword1.equals(newPassword2) )
            {
    //aggiungere il metodo cambia password cha ora manca
            }
            else out.println("password differenti.");
        } catch (Exception e) { out.println("Error changed password: " + e); }
      }
      else
      {
        out.println( "Unknown operation: " + Param );
      }
    }

    return profile;
  }

  public String Help( PrintStream out )
  {
    out.println( profile.toString() );
    return profile.toString();
  }
}