package SOMA.security.infrastructure.CRL;


import java.lang.String;
import java.util.Date;
import java.util.Calendar;
import java.math.BigInteger;
import java.security.Principal;
import java.security.cert.Certificate;

import iaik.x509.X509CRL;


public class LocalCRL
{
  protected X509CRL[] CRL;
  protected Date lastUpdate;

  public LocalCRL ()
  {
    this.CRL = null;
    this.lastUpdate = null;
  }

  public LocalCRL ( X509CRL[] CRL )
  {
    this.CRL = CRL;
    this.lastUpdate = Calendar.getInstance().getTime();
  }

  synchronized public void setCRL ( X509CRL[] CRL )
  {
    this.CRL = CRL;
    this.lastUpdate = Calendar.getInstance().getTime();
  }

  synchronized public int length ()
  {
    if (this.CRL == null) return 0;
    return this.CRL.length;
  }

  synchronized public Principal DistinguisName (int position)
  {
    if ((this.CRL != null) && (position >= 0) && (position < this.CRL.length))
      return this.CRL[position].getIssuerDN();
    return null;
  }

  synchronized public Principal DistinguisName ()
  {
    if ((this.CRL != null) && (this.CRL.length > 0))
      return this.CRL[0].getIssuerDN();
    return null;
  }

  synchronized public boolean isRevoked ( Certificate cert )
  {
    boolean isR = false;

    if (this.CRL == null) return false;
    for (int i=0; !isR && i<CRL.length; i++)
      isR = CRL[i].isRevoked( cert );
    return isR;
  }

  synchronized public boolean isRevoked (BigInteger serialNumber)
  {
    boolean isR = false;

    if (this.CRL == null) return false;
    for (int i=0; !isR && i<CRL.length; i++)
      isR = CRL[i].isRevoked( serialNumber );
    return isR;
  }

  synchronized public Date getNextUpdate()
  {
    if (this.CRL == null) return null;
    if (this.CRL.length > 0) return this.CRL[0].getNextUpdate();
    return null;
  }

  synchronized public Date getLastUpdate()
  {
    if (this.lastUpdate == null) return null;
    return this.lastUpdate;
  }



  synchronized public String toString ()
  {
    String returnVal = "Last CRL update: " + this.lastUpdate.toString() + "\n";

    for (int i=0 ; i<CRL.length ; i++)
      returnVal = returnVal + CRL[i].toString();

    return returnVal;
  }
}