package SOMA.security.auth;

import java.security.Principal;

/* Classe che implementa il Principal
   che sta a rappresentare lo username.
   L'implementazione e' quella standard
   di un principal del JAAS
*/

public class UserPrincipal implements Principal, java.io.Serializable {

  private String name;

  public UserPrincipal(String name) {

    if (name == null) throw new NullPointerException("illegal null input");
    this.name = name;

  }

  public String getName() {
    return name;
  }

  public String toString() {
    return("UserPrincipal:  " + name);
  }


  public boolean equals(Object o) {

    if (o == null) return false;
    if (this == o) return true;
    if (!(o instanceof UserPrincipal)) return false;
    UserPrincipal that = (UserPrincipal)o;
    if (this.getName().equals(that.getName())) return true;
    return false;
  }

  public int hashCode() {
    return name.hashCode();
  }

}
