package SOMA.security;

// Ecco dove trovare le classi degli oggetti
//   che compongono il sistema
import SOMA.Environment;
import SOMA.network.NetworkManager;
import SOMA.explorer.DirExplorerItem;
import SOMA.naming.PlaceID;
import SOMA.naming.domain.DomainNameService;
import SOMA.naming.place.PlaceNameService;
import SOMA.agent.mobility.*;
import SOMA.output.PlaceWindow;
import SOMA.agent.AgentWorker;
import SOMA.mobilePlace.*;
import java.io.*;
import SOMA.explorer.*;
import SOMA.network.connection.*;
import SOMA.naming.*;
import SOMA.naming.domain.*;
import SOMA.naming.place.*;

import SOMA.security.infrastructure.ProfileManager;
import SOMA.security.infrastructure.explorer.AddressExplorerItem;

/** Classe che rappresenta l'astrazione di place.
* <BR>Contiene i riferimenti a tutti gli oggetti che compongono un <I>place</I> o un <I>default place</I>,
* che e' il place che gestisce un dominio.
* <BR>Il costruttore di Environment avvia il place.
*
* @author Ghetti Luca
*/

public class SecurityEnvironment extends Environment
{
  /** Identificatore del place.
  * <code>final</code> impedisce ad un place di alterare il suo identificatore.*
   public final PlaceID placeID;
  * Gestore delle comunicazioni fra place.*
  public NetworkManager networkManager = null;
  * Menu di gestione del place.*
  public DirExplorerItem dir;
  * Servizio di nomi di dominio.
  * E' presente solo in un <I>default place</I>*
  public DomainNameService domainNameService;
  * Servizio di nomi di place.*
  public PlaceNameService placeNameService;
  * Gestore degli agenti.*
  public AgentManager agentManager;
  * L'InputStream del place.*
  public InputStream in;
  * L'OututStream del place.*
  public PrintStream out;
  * L'ErrorStream del place.*
  public PrintStream err;

  public ThreadGroup threadGroup = null;   **/

  private Exception creationException = null; // Un po' sporco, ma funziona...

  /** il profile manager **/
  public ProfileManager profile;


    /** Costruttore usato per avere un Environment "vuoto". */
  public SecurityEnvironment( DirExplorerItem dir, InputStream in, PrintStream out, PrintStream  err )
  {
    super (dir, in, out, err );
  }

  /** Costruttore: avvia il place chiamando i costruttori di tutti i suoi componenti.
  *
  * <P> I final servono solo per poter utilizzare delle classi anonime.
  */
  public SecurityEnvironment( final PlaceID placeID, final DirExplorerItem dir, final int port,
                              final InputStream in, final PrintStream out, final PrintStream  err)
    //throws IOException, ConnectionServer.ConnectionServerException, NameException
    throws Exception
           // Eccezioni di NetworkManager:

  {

   super( placeID );
    System.out.println("New del Profilo");
    // creazione della classe che verr inizializzata dall'utente.
    this.profile = new ProfileManager ();
    //this.placeID = placeID;
    this.dir = dir;

    this.in = in;
    this.out = out;
    this.err = err;
    multiOut.add( out );
    multiErr.add( err );


    dir.addItem( "env", new ObjectExplorerItem( this ) );

    aggiungiVociDellaGUI(dir);   // AGGIUNTA DA Luigi Antenucci (per la GUI)

    dir.addItem( "CA_address", new AddressExplorerItem( this , dir , profile ) );

    createNameServices();

    if( placeID.isDomain() )
      mobilePlaceManager = new MobilePlaceManager( this );


    // Tutti i threads creati dall'environment, ossia, facenti parte del place si
    //   troveranno in questo ThreadGroup.
    threadGroup = new ThreadGroup( "[Environment:" + placeID + "]" );
    threadGroup.setDaemon( true ); // Distrutto dopo l'ultimo thread di questo gruppo

    Thread initThread =
                 new Thread(  threadGroup, toString() + " Initialization Thread." )
                    {
                      public void run()
                      {
                        try
                        {
                          //out.println( "The initialization thread: " + Thread.currentThread() );
                          //out.println( "Threadgroup: " + Thread.currentThread().getThreadGroup() );

                          networkManager = new NetworkManager( SecurityEnvironment.this, port );
                          out.println( "NewtworkManager created!" );

                          agentManager = new AgentManagerSecurity( SecurityEnvironment.this );
                          out.println( "AgentManager created!" );

                          dir.addItem( "threads", new SOMA.utility.ThreadsExplorerItem() );
                        }
                        catch( Exception e )
                        {
                          creationException = e;
                        }
                      }
                    };

    initThread.setDaemon( true );
    initThread.start();
    initThread.join();

    if( creationException != null )
      throw( creationException );

    // Questo ha solo finalit di debugging.
    dir.addItem( "text", new ExplorerItem( "Writes text to 3 different PrintStreams." )
      {
        public Object Execute( java.util.Collection Parameters, PrintStream out )
        {
          out.println( "********** Testo di Explorer! *********" );
          SecurityEnvironment.this.out.println( "----------- Testo di PlaceWindow! -----------" );
          System.out.println( "############## Testo di System! ##############" );

          return null;
        }
      } );

    dir.addItem( "save", new ExplorerItem( "Save place info to disk." )
      {
        public Object Execute( java.util.Collection Parameters, PrintStream out )
        {
          try
          {
            save();
            out.println( "Saved!" );
          }
          catch( Exception e )
          {
            e.printStackTrace( out );
          }

          return null;
        }
      } );

    dir.addItem( "load", new ExplorerItem( "Load place info from disk." )
      {
        public Object Execute( java.util.Collection Parameters, PrintStream out )
        {
          try
          {
            load();
            out.println( "Loaded!" );
          }
          catch( Exception e )
          {
            e.printStackTrace( out );
          }

          return null;
        }
      } );

    // Questo ha solo finalit di debugging.
    /*
    (new Thread( threadGroup, "END Waiter" )
                {
                  public void run()
                  {
                    out.println( "ENVIRONMENT: I am waiting for the last thread of this place." );

                    AgentWorker.WaitForOtherThreads( out );

                    out.println( "ENVIRONMENT: this is the end!" );
                  }
                }).start();
    */
    /*
    try
    {
      initThread.join();
    }
    catch( InterruptedException e )
    {
      e.printStackTrace( out );
    }*/
  }

  /** Cambia in MobileEnvironment. */
  protected void createNameServices()
  {
    if( placeID.isDomain() )
    {
      domainNameService = new DomainNameService( this );
      dir.addItem( "dns", new DNSExplorerItem( domainNameService ) );
    }

    placeNameService = new PlaceNameService( this );
    dir.addItem( "pns", new PNSExplorerItem( placeNameService ) );
  }


  public String toString()
  {
    return ( (profile == null) ?
            ("[SecurityEnvironment " + placeID + " " + networkManager + " " + domainNameService + " " + placeNameService + " " + agentManager + " Null Profile]") :
            ("[SecurityEnvironment " + placeID + " " + networkManager + " " + domainNameService + " " + placeNameService + " " + agentManager + " " + profile.toString() + "]"));
  }
}