package SOMA.output;

import java.io.*;
import java.awt.*;

import java.awt.event.*;

public class TextFieldInputStream extends java.io.InputStream implements java.io.Serializable
{
  private TextField Source;
  private transient ByteArrayInputStream In;
  private String InputBuffer = "";

  private static final String LineSeparator = System.getProperty( "line.separator" );

  public TextFieldInputStream( TextField Source )
  {
    this.Source = Source;

    In = new ByteArrayInputStream( new byte[0] );

		SourceListener MySourceListener = new SourceListener();
		Source.addActionListener( MySourceListener );
  }

  // Questo metodo  chiamato durante la deserializzazione
	private void readObject(java.io.ObjectInputStream stream)
     throws IOException, ClassNotFoundException
  {
    stream.defaultReadObject();

    In = new ByteArrayInputStream( new byte[0] );
  }

  // Questo metodo  chiamato durante la serializzazione
	private void writeObject(java.io.ObjectOutputStream stream)
	   throws IOException
  {
    // Rimetto i bytes non ancora letti dentro il buffer.

    byte[] buffer = new byte[In.available()];
    In.read( buffer );
    InputBuffer = new String( buffer ) + InputBuffer;

    stream.defaultWriteObject();
  }





/*
*  Reads the next byte of data from the input stream. The value byte is returned as an int in the range 0 to 255. If no byte
*  is available because the end of the stream has been reached, the value -1 is returned. This method blocks until input
*  data is available, the end of the stream is detected, or an exception is thrown.
*
*  A subclass must provide an implementation of this method.
*  Returns:
*      the next byte of data, or -1 if the end of the stream is reached.
*  Throws:
*      IOException - if an I/O error occurs.
*/

  public synchronized int read() throws IOException
  {
  	int IntRead;

    while( In.available() == 0 )
      PrepareIn();

	  IntRead = In.read();

    notifyAll();

	  //System.err.print( "<" + IntRead + ">" );

    return IntRead;
  }

  public synchronized int read(byte[] b) throws IOException
  {
    //System.err.println( "INIZIO: read(byte[] b)  b.length ="
    //  + new Integer( b.length ) + " io sono: " + this );
    int retInt;

    while( In.available() == 0 )
      PrepareIn();

    retInt = In.read( b );

    notifyAll();

    //System.err.println( "FINE: read(byte[] b) =" + new Integer( retInt ) );

    return retInt;
  }

  public synchronized int read(byte[] b, int off, int len) throws IOException
  {
    //System.err.println( "INIZIO: read(byte[] b, int off, int len)  b.length ="
    //  + new Integer( b.length ) + "  off= "
    //  + new Integer( off ) + "  len= "
    //  + new Integer( len ) + " io sono: " + this );

    int retInt;

	  while( In.available() == 0 )
	    PrepareIn();

    retInt = In.read( b, off, len);

    notifyAll();

    //System.err.println( "FINE: read(byte[] b, int off, int len) ="
    //  + new Integer( retInt ) );

    return retInt;
  }

  public int available() throws IOException
  {
    //System.err.print( "available() = " + In.available() );
    return In.available();
  }

	private synchronized void PrepareIn()
	{
    if( InputBuffer.equals( "" ) )
      try { wait(); } catch( Exception e ) {}
    else
    {
       try{In.close();} catch( IOException e ) {}

		   In = new ByteArrayInputStream( InputBuffer.getBytes() );
		   InputBuffer = "";
    }
  }

	class SourceListener implements java.awt.event.ActionListener, java.io.Serializable
	{
		public synchronized void actionPerformed(java.awt.event.ActionEvent event)
		{
		   //System.err.println( "SourceListener: Mi sinchornizzo su " +
		   //  TextFieldInputStream.this );

		   synchronized( TextFieldInputStream.this )
		   {
		     InputBuffer = InputBuffer
		                   + Source.getText()
		                   + LineSeparator;

  		   //System.err.print( "SourceListener: InputBuffer =" + InputBuffer  );

   		   TextFieldInputStream.this.notifyAll();

   		   Source.setText( "" );
		   }
		}
	}
}

