package SOMA.output;

import SOMA.network.connection.Daemon;
import SOMA.Environment;
import SOMA.explorer.*;
import SOMA.mobilePlace.*;
import SOMA.naming.PlaceID;


import java.io.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class PlaceWindow implements Daemon
{
	Environment env;
	OutputFrame window = null;

	InputStream oldIn = null;
	OutputStream oldOut = null, oldErr = null;
	//PrintStream oldOut = null, oldErr = null;

	Object status = OFF;

  public PlaceWindow( Environment env )
  {
    this.env = env;

    /*
    try
    {
      UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
    }
    catch( Exception e )
    {
      env.err.println("Error loading L&F: " + e);
    }*/
  }

  public void start()
  {
    if( status == OFF )
    {
      oldIn = env.in;
      //oldOut = env.out;
      //oldErr = env.err;
      oldOut = env.multiOut.getFirst();
      oldErr = env.multiErr.getFirst();

      window = new OutputFrame( env.placeID.toString() );
      window.ListOut.Target.setBackground(new Color(12632256));

      MenuItem loadScript = new MenuItem( "Load script file..." );
      loadScript.addActionListener( new LoadScriptActionListener( window, "Load script", env.dir, env.out ) );

      window.menu1.insert( loadScript, 0 );

      MenuItem agentPath = new MenuItem( "Agent CLASSPATH..." );
      agentPath.addActionListener(
        new ActionListener()
          {
            public void actionPerformed(ActionEvent e)
            {
              JFileChooser chooser = new JFileChooser();
              chooser.setFileSelectionMode( JFileChooser.DIRECTORIES_ONLY );

              File dir = new File(env.agentManager.agentClassManager.getClassPathDirectory());
              //env.out.println( dir.getAbsolutePath() );
              chooser.setCurrentDirectory( dir );
              chooser.changeToParentDirectory();
              chooser.setSelectedFile( dir );
              chooser.setDialogTitle( "Agent CLASSPATH..." );

              if( chooser.showOpenDialog( window ) == JFileChooser.APPROVE_OPTION  )
                env.dir.Execute( "agentManager path " + chooser.getSelectedFile().getAbsolutePath(), env.out );
            }
          });



              //FileDialog fileDialog = new FileDialog( window, "Agent CLASSPATH directory", FileDialog.LOAD );

              //fileDialog.setDirectory( env.agentManager.agentClassManager.getClassPathDirectory() );
              /*
              fileDialog.setFilenameFilter( new FilenameFilter()
                {
                  public boolean accept(File dir, String name)
                  {
                    return (new File(dir, name)).isDirectory();
                  }
                });

              fileDialog.show();

              String file = fileDialog.getFile();

              if( file != null )
                env.dir.Execute( "agentManager path " + file, env.out );
            }
          });*/

      MenuItem agentCache = new MenuItem( "Agent cache..." );
      agentCache.addActionListener(
        new ActionListener()
          {
            public void actionPerformed(ActionEvent e)
            {
              JFileChooser chooser = new JFileChooser();
              chooser.setFileSelectionMode( JFileChooser.DIRECTORIES_ONLY );

              File dir = new File(env.agentManager.cacheClassManager.getClassPathDirectory());
              //env.out.println( dir.getAbsolutePath() );
              chooser.setCurrentDirectory( dir );
              chooser.changeToParentDirectory();
              chooser.setSelectedFile( dir );
              chooser.setDialogTitle( "Agent cache directory" );

              if( chooser.showOpenDialog( window ) == JFileChooser.APPROVE_OPTION  )
                env.dir.Execute( "agentManager cache " + chooser.getSelectedFile().getAbsolutePath(), env.out );
            }
          });




      window.menu1.insert( agentPath, 1 );
      window.menu1.insert( agentCache, 2 );
      window.menu1.insertSeparator( 3 );

      // Guarda mo' come ti lancio un agente!
      MenuItem launchAgent = new MenuItem( "Launch Agent...", new MenuShortcut( java.awt.event.KeyEvent.VK_L ) );
      launchAgent.addActionListener(
        new ActionListener()
          {
            public void actionPerformed(ActionEvent e)
            {
              window.out.println( "Insert: <agent_class_name> <parameters>:" );

              (new Thread( env.placeID.toString() + "Place Window: launch agent" )
                  {
                    public void run()
                    {
                      try
                      {
                         env.dir.Execute( "agentManager launch " +
                              window.inBufferedReader.readLine(), window.out );
                      }
                      catch( Exception f )
                      {
                        f.printStackTrace( window.out );
                      }
                    }
                  }).start();
            }
          });



      window.menu1.insert( launchAgent, 0 );
      window.menu1.insertSeparator( 1 );

      if( env.placeID instanceof MobilePlaceID )
      {
        MenuItem connect = new MenuItem( "Connect to domain...", new MenuShortcut( java.awt.event.KeyEvent.VK_C ) );

        connect.addActionListener(
          new ActionListener()
          {
            public void actionPerformed(ActionEvent e)
            {
              window.out.println( "Insert <domain name>:" );

              (new Thread( env.placeID.toString() + "Place Window: connect to..." )
                  {
                    public void run()
                    {
                      try
                      {
                         env.dir.Execute( "connect " +
                              window.inBufferedReader.readLine(), window.out );
                      }
                      catch( Exception f )
                      {
                        f.printStackTrace( window.out );
                      }
                    }
                  }).start();
            }
          });

        MenuItem disconnect = new MenuItem( "Disconnect", new MenuShortcut( java.awt.event.KeyEvent.VK_D ) );

        disconnect.addActionListener(
          new ActionListener()
          {
            public void actionPerformed(ActionEvent e)
            {
              (new Thread( env.placeID.toString() + "Place Window: disconnect" )
                  {
                    public void run()
                    {
                      try
                      {
                         env.dir.Execute( "disconnect", window.out );
                      }
                      catch( Exception f )
                      {
                        f.printStackTrace( window.out );
                      }
                    }
                  }).start();
            }
          });

        MenuItem status = new MenuItem( "Status" );

        status.addActionListener(
          new ActionListener()
          {
            public void actionPerformed(ActionEvent e)
            {
              try
              {
                PlaceID currentDomainID = (PlaceID)env.dir.Execute( "currentDomain", window.out );
                window.out.println();
                if( currentDomainID == MobilePlaceManager.DISCONNECTED )
                  window.out.println( "The mobile place is disconnected" );
                else
                  window.out.println( "The mobile place is connected to " + currentDomainID );
                window.out.println();
              }
              catch( Exception f )
              {
                f.printStackTrace( window.out );
              }
            }
          });

        window.menu1.insert( connect, 2 );
        window.menu1.insert( disconnect, 3 );
        window.menu1.insert( status, 4 );
        window.menu1.insertSeparator( 5 );
      }

      window.OnExitCommand = new OutputFrame.Listener() //Stabilisco il comportamento all'uscita
      {
		    public void run()
		    {
          window.out.println( "  Exiting!" );
          env.dir.Execute( "window stop", window.out );
        }
      };

      env.in = window.in;

      env.multiOut.setFirst( window.out );
      env.multiErr.setFirst( window.out );


      //env.out = window.out;
      //env.err = window.out;

      window.show();
      window.toFront();

      status = ON;
    }
    else
    {
      env.out.println( "Window already " + status );
    }
  }

  public void stop()
  {
    if( status == ON )
    {
      env.in = oldIn;
      //env.out = oldOut;
      //env.err = oldErr;
      env.multiOut.setFirst( oldOut );
      env.multiErr.setFirst( oldErr );

      window.setVisible( false );
      window.dispose();
      window = null;

      status = OFF;
    }
    else
    {
      env.out.println( "Window already " + status );
    }
  }

  public Object getStatus()
  {
    return status;
  }

  public String toString()
  {
   return "[PlaceWindow " + status + "]";
  }
}